﻿var kmldat = null;
var xmldat = '<kml xmlns="http://www.opengis.net/kml/2.2"><Document>';
(function () {
    "use strict";
    document.getElementById("speichern").addEventListener('click', function () {
        speichern();
    }, false);
    document.addEventListener('deviceready', onDeviceReady.bind(this), false);

    function onDeviceReady() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(successgeo, errorgeo, {
                maximumAge: 1000,
                timeout: 10000,
                enableHighAccuracy: true
            });

            navigator.geolocation.watchPosition(successgeo, errorgeo, {
                enableHighAccuracy: true,
                maximumAge: 1000,
                timeout: 1000,
                frequency: 1000
            });

        } else {
            document.getElementById("info").innerHTML = "Geolocation nicht möglich";
        }
    };

    function successgeo(position) {
        var latitude = position.coords.latitude;
        var longitude = position.coords.longitude;
        document.getElementById("info").innerHTML = latitude + ", " + longitude;
        var dat = new Date();
        xmldat += '<Placemark><TimeStamp><when>' + dat.getFullYear() + '-' + dat.getMonth() + '-' + dat.getDate() + 'T' + dat.getHours() + ':' + dat.getMinutes() + ':' + dat.getSeconds() + 'Z</when></TimeStamp><Point><coordinates>' + longitude + ',' + latitude + ',0</coordinates></Point> </Placemark>';

    }

    function errorgeo(msg) {
        document.getElementById("info").innerHTML = msg;
    }

    function speichern() {

        window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function (fileSystem) {
            kmldat = "weg" + Date.parse(new Date()) + ".kml";
            fileSystem.root.getFile(kmldat, {
                create: true,
                exclusive: true
            }, function (fileEntry) {
                fileEntry.createWriter(function (writer) {
                    writer.onwriteend = function (evt) {
                        document.getElementById("info").innerHTML = "Daten gespeichert in Datei " + kmldat;
                    };
                    writer.write('<?xml version="1.0" encoding="UTF-8"?>' + xmldat + '</Document></kml>');

                }, fail);
            }, fail);

        }, fail);
    }
    function fail(evt) {
        document.getElementById("info").innerHTML = evt;
    }
})();