﻿var watchId = null;
var kmldat = null;
var kmldatUpload = null;
var xmldat = '<kml xmlns="http://www.opengis.net/kml/2.2"><Document>';
(function () {
    "use strict";
    document.getElementById("speichern").addEventListener('click', function () {
        speichern();
    }, false);
    document.getElementById("hochladen").addEventListener('click', function () {
        hochladen();
    }, false);
    document.getElementById("trackstart").addEventListener('click', function () {
        tracken();
    }, false);
    document.addEventListener('deviceready', onDeviceReady.bind(this), false);

    function onDeviceReady() {
        
    };

    function successgeo(position) {
        var latitude = position.coords.latitude;
        var longitude = position.coords.longitude;
        $("#info").html("Position wird verfolgt!<hr />" + latitude + " - " + longitude);
        var dat = new Date();
        xmldat += '<Placemark><TimeStamp><when>' + dat.getFullYear() + '-' + dat.getMonth() + '-' + dat.getDate() + 'T' + dat.getHours() + ':' + dat.getMinutes() + ':' + dat.getSeconds() + 'Z</when></TimeStamp><Point><coordinates>' + longitude + ',' + latitude + ',0</coordinates></Point> </Placemark>';

    }

    function errorgeo(msg) {
        $("#info").html (msg);
    }
    function tracken() {
        $(this).removeClass("active").addClass("disabled");
        $("#speichern").removeClass("disabled").addClass("active");
        $("#hochladen").removeClass("active").addClass("disabled");
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(successgeo, errorgeo, {
                maximumAge: 1000,
                timeout: 10000,
                enableHighAccuracy: true
            });

            watchId = navigator.geolocation.watchPosition(successgeo, errorgeo, {
                enableHighAccuracy: true,
                maximumAge: 1000,
                timeout: 1000,
                frequency: 1000
            });

        } else {
            $("#info").html("Geolocation nicht möglich");
        }
    }
    function speichern() {
        $(this).removeClass("active").addClass("disabled");
        $("#trackstart").removeClass("disabled").addClass("active");
        $("#hochladen").removeClass("disabled").addClass("active"); 
        navigator.geolocation.clearWatch(watchId);

        window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function (fileSystem) {
            kmldat = "weg" + Date.parse(new Date()) + ".kml";
            fileSystem.root.getFile(kmldat, {
                create: true,
                exclusive: true
            }, function (fileEntry) {
                kmldatUpload = fileEntry.toInternalURL();
                fileEntry.createWriter(function (writer) {
                    writer.onwriteend = function (evt) {
                        $("#info").html("Daten gespeichert in Datei " + kmldatUpload + ".");
                    };
                    writer.write('<?xml version="1.0" encoding="UTF-8"?>' + xmldat + '</Document></kml>');

                }, fail);
            }, fail);

        }, fail);
    }
    function hochladen() {
         
                var options = new FileUploadOptions();
                options.fileKey = "file";
                options.fileName = kmldatUpload.substr(kmldatUpload.lastIndexOf('/') + 1);

                options.mimeType = "text/plain";
                var ft = new FileTransfer();
                ft.upload(kmldatUpload, encodeURI("http://localhost/upload.php"), function (e) {
                    var msg = "";
                    for (var i in e) {
                        msg += "<br />"+ i + ": " + e[i];
                    }
                    $("#info").html("Datei " + kmldat + " auf Server geladen.<br />Das liefert der Server:<br />" + msg);
                }, fail, options, true);
       

    }
    function fail(evt) {
        var msg = "Fehler:<br />";
        for (var i in evt) {
            msg += i + ": " + evt[i] + "<br />";
        }
        $("#info").html(msg);
    }
})();