﻿var zb1 = null;
var zb2 = null;
var img = null;
var winkelalt = 0;
var beschleunigungalt=0;
var beschleunigungsarray = [];

(function () {
    "use strict";
    document.getElementById("tacho").innerHTML = "0";
    img = new Image();
    img.src = 'images/kompass.png';
    zb1 = document.getElementById("rose").getContext('2d');
    zb1.translate(125, 125);

    document.addEventListener( 'deviceready', onDeviceReady.bind( this ), false );

    function onDeviceReady() {
        if (navigator.geolocation) {
            navigator.geolocation.watchPosition(successgeo, errorgeo, {
                enableHighAccuracy: true,
                maximumAge: 15000,
                timeout: 1000,
                frequency: 5000
            }); 
        }
        else {
            document.getElementById('karte').innerHTML =
              "Geolocation nicht möglich";
            document.getElementById("tacho").innerHTML = "0";
        }
        if (navigator.accelerometer) {
            navigator.accelerometer.getCurrentAcceleration(
            function (acceleration) {
                beschleunigungalt = acceleration.z
            }, errorbeschleu); 
            navigator.accelerometer.watchAcceleration(
            successbeschleu, errorbeschleu, {
                frequency: 1500
            });
        }
        else {
            document.getElementById('beschleunigung').innerHTML = '#';
        }
        navigator.compass.watchHeading(successcomp, errorcomp, {
            frequency: 1500
        });

        function successgeo(position) {
            // Die Karte
            var map = null;
            var pinPoint = null;
            var pinPixel = null;
            var latitude = position.coords.latitude;
            var longitude = position.coords.longitude;
            document.getElementById('karte').style.width = "300px";
            document.getElementById('karte').style.height = "150px";
            var coords = new google.maps.LatLng(latitude, longitude);
           
            map = new google.maps.Map(document.getElementById("karte"), {
                zoom: 11,
                center: coords,
                mapTypeId: google.maps.MapTypeId.HYBRID
            });
            var marker = new google.maps.Marker({
                position: coords,
                map: map,
                title: "Ihre aktuelle Position!"
            });

            // Die Geschwindigkeit
            var speed = Math.floor(position.coords.speed * 3.6);
            if (speed > 270)
                speed = 270;
            document.getElementById("tacho").innerHTML = speed + " Km/h";
            zb2 = document.getElementById("digitacho").getContext('2d');
            zb2.font = "16px Arial";
            zb2.fillStyle = "red";
            zb2.fillText("0", 20, 0);
            zb2.fillText("0", 0, 20);
            zb2.fillText("50", 50, 20);
            zb2.fillText("100", 100, 20);
            zb2.fillText("150", 150, 20);
            zb2.fillText("200", 200, 20);
            zb2.fillText("250", 250, 20);
            zb2.fillText("|", 0, 38);
            zb2.fillText("|", 50, 38);
            zb2.fillText("|", 100, 38);
            zb2.fillText("|", 150, 38);
            zb2.fillText("|", 200, 38);
            zb2.fillText("|", 250, 38);
            zb2.clearRect(0, 42, 270, 38);
            if (speed > 249)
                zb2.fillStyle = "red";
            else
                zb2.fillStyle = "green";
            zb2.fillRect(0, 42, speed, 50);
        }
        function successcomp(heading) {
            var winkel = Math.floor(heading.trueHeading);
            document.getElementById('kompass').innerHTML =
              winkel + " &#176;";
            zb1.translate(-125, -125);
            zb1.clearRect(0, 0, 500, 500);
            zb1.translate(125, 125);
            zb1.rotate((winkelalt - winkel) * Math.PI / 180);
            winkelalt = winkel;
            zb1.drawImage(img, -125, -125);
        }
        function successbeschleu(acceleration) {
            var beschleu = acceleration.z;
            if (beschleunigungsarray.length < 5) {
                beschleunigungsarray[beschleunigungsarray.length] = beschleu;
                return;
            }
            else {
                beschleu = 0;
                for (var i = 0; i < beschleunigungsarray.length; i++) {
                    beschleu += 1 * (beschleunigungsarray[i]);
                };
                beschleu = beschleu / beschleunigungsarray.length;
                beschleunigungsarray = [];
            }
            var aender = beschleu - beschleunigungalt;
            if (aender < -0.5) {
                document.getElementById('beschleunigung').style.color =
                  "red";
                document.getElementById('beschleunigung').innerHTML =
                  Math.floor(aender) + ' m/s^2';
            } else if (aender > 0.5) {
                document.getElementById('beschleunigung').style.color =
                  "green";
                document.getElementById('beschleunigung').innerHTML =
                  Math.floor(aender) + ' m/s^2';
            }
            else {
                document.getElementById('beschleunigung').style.color =
                  "green";
                document.getElementById('beschleunigung').innerHTML =
                  '0 m/s^2';
            }
            beschleunigungalt = beschleu;
        }
        function errorbeschleu() {
            document.getElementById('beschleunigung').style.color = "red";
            document.getElementById('beschleunigung').innerHTML =
              '0.00 m/s^2';
        }
        function errorgeo(msg) {
            document.getElementById("tacho").innerHTML = "0";
        }
        function errorcomp(compassError) {
            document.getElementById('kompass').innerHTML = winkel;
        }


    };

} )();