/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var app = {
    // Application Constructor
    initialize: function() {
        this.bindEvents();
    },
    // Bind Event Listeners
    //
    // Bind any events that are required on startup. Common events are:
    // 'load', 'deviceready', 'offline', and 'online'.
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    // deviceready Event Handler
    //
    // The scope of 'this' is the event. In order to call the 'receivedEvent'
    // function, we must explicitly call 'app.receivedEvent(...);'
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
    },
    // Update DOM on a Received Event
    receivedEvent: function(id) {
       if (navigator.geolocation) {
			navigator.geolocation.getCurrentPosition(success, error);
		} else {
			document.getElementById('karte').innerHTML = "Geolokation ist nicht möglich";
		}
    }
};

function success(position) {
	document.getElementById('karte').innerHTML = 
	  "Das Objekt navigator.geolocation liefert:<hr />" + 
	  "Breitengrad: " + position.coords.latitude + 
	  "<br />L&auml;ngengrad: " + position.coords.longitude + 
	  '<br />&Uuml;bergangsh&ouml;he: ' + position.coords.altitude + 
	  '<br />' + 'Genauigkeit: ' + position.coords.accuracy + 
	  '<br />' + 'Genauigkeit &Uuml;bergangsh&ouml;he: ' + position.coords.altitudeAccuracy + 
	  '<br />' + 'Steuerkurs: ' + position.coords.heading + '<br />' + 
	  'Geschwindigkeit: ' + position.coords.speed + '<br />' + 
	  'Zeitstempel: ' + position.timestamp;
}
function error(msg) {
	document.getElementById('karte').innerHTML = 
	  "Fehler bei der Lokalisierung:<br /> " + msg;
}
app.initialize();