
var app = {
    initialize: function() {
        this.bindEvents();
    },
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
    },
    receivedEvent: function(id) {
       if (navigator.geolocation) {
			navigator.geolocation.getCurrentPosition(success, error);
		} else {
			document.getElementById('karte').innerHTML = "Geolocation ist nicht möglich";
		}
    }
};

function success(position) {
	 document.getElementById('karte').style.width = 
    (screen.width - 10) + "px";
	 document.getElementById('karte').style.height = 
    (screen.height - 100) + "px";

  var map = null;
  var pinPoint = null;
  var pinPixel = null;
  var latitude = position.coords.latitude;
  var longitude = position.coords.longitude;
  
  var LA = new VELatLong(latitude, longitude);
  map = new VEMap('karte');
  map.LoadMap(LA, 15, VEMapStyle.Hybrid, false,
    VEMapMode.Mode2D, true, 1);
  pinPoint = map.GetCenter();
  pinPixel = map.LatLongToPixel(pinPoint);
  map.AddPushpin(pinPoint);


}
function error(msg) {
	document.getElementById('karte').innerHTML = 
	  "Fehler bei der Lokalisierung:<br /> " + msg;
}
app.initialize();