
var app = {
    initialize: function() {
        this.bindEvents();
    },
    bindEvents: function() {
        document.addEventListener('deviceready', this.onDeviceReady, false);
    },
    onDeviceReady: function() {
        app.receivedEvent('deviceready');
    },
    receivedEvent: function(id) {
		document.getElementById("tacho").innerHTML = "0 km/h";
       if (navigator.geolocation) {
			navigator.geolocation.watchPosition(success, error, { maximumAge: 0, timeout: 200, enableHighAccuracy: true });
		} else {
			document.getElementById('tacho').innerHTML = "##";
		}
    }
};

function success(position) {
	      var speed = Math.floor(position.coords.speed * 3.6);
      if (speed > 270)
        speed = 270;
      document.getElementById("tacho").innerHTML = speed + "km/h";
      zb = document.getElementById("digitacho").getContext('2d');
      zb.font = "18px Arial";
      zb.fillStyle = "red";
      zb.fillText("0", 20, 0);
      zb.fillText("0", 0, 20);
      zb.fillText("50", 50, 20);
      zb.fillText("100", 100, 20);
      zb.fillText("150", 150, 20);
      zb.fillText("200", 200, 20);
      zb.fillText("250", 250, 20);
      zb.fillText("|", 0, 40);
      zb.fillText("|", 50, 40);
      zb.fillText("|", 100, 40);
      zb.fillText("|", 150, 40);
      zb.fillText("|", 200, 40);
      zb.fillText("|", 250, 40);
      zb.clearRect(0, 45, 270, 55);
      if(speed>249) zb.fillStyle = "red";
      else zb.fillStyle = "green";
      zb.fillRect(0, 45, speed, 55);

}
function error(msg) {
	document.getElementById("tacho").innerHTML = "#";
}
app.initialize();