var zb1 = null;
var zb2 = null;
var img = null;
var winkelalt = 0;
var beschleunigungalt;
var beschleunigungsarray = [];
var vmax = 50;
var varray = [0, 10, 20, 30, 40, 50];
var speed = 10;
function zeichneAnzeige() {
    zb2 = $("#digitacho").get(0).getContext('2d');
    zb2.font = "16px Arial";
    zb2.fillStyle = "red";
    zb2.clearRect(0, 0, 320, 50);
    for (var i = 0; i < varray.length; i++) {
        zb2.fillText(varray[i], i * 50, 20);
        zb2.fillText("|", i * 50, 38);
    }
    zb2.clearRect(0, 42, 270, 38);
    if (speed > vmax) zb2.fillStyle = "red";
    else zb2.fillStyle = "green";
    zb2.fillRect(0, 42, speed / vmax * 250, 50);
}
function zeigeKarte() {
    
    if ($("#checkboxkarte").val() == 0) {
        $("#karte").css({
            "display": "none"
        });
    } else {
        $("#karte").css({
            "display": "block"
        });
    }
}
$(function () {
    $("#tacho").html("0");
    $("#retur").bind("click", function () {
        vmax = $("#slider").val();
        var skal = Math.floor(vmax / 5);
        for (var i = 1; i < 6; i++) {
            varray[i] = skal * i;
        }
        zeichneAnzeige();
        zeigeKarte();
    });
    img = new Image();
    img.src = 'images/kompass.png';
    zb1 = document.getElementById("rose").getContext('2d');
    zb1.translate(125, 125);
    document.addEventListener("deviceready", function () {
        if (navigator.geolocation) {
            navigator.geolocation.watchPosition(successgeo, errorgeo, {
                enableHighAccuracy: true,
                maximumAge: 15000,
                timeout: 1000,
                frequency: 5000
            });
        } else {
            $("#karte").html("Geolocation nicht mglich");
            $("#tacho").html("0");
        }
        if (navigator.accelerometer) {
            navigator.accelerometer.getCurrentAcceleration(
              function (acceleration) {
                  beschleunigungalt = acceleration.z
              }, errorbeschleu);
            navigator.accelerometer.watchAcceleration(successbeschleu,
              errorbeschleu, {
                  frequency: 400
              });
        } else {
            $('#beschleunigung').html('#');
        }
        navigator.compass.watchHeading(successcomp, errorcomp, {
            frequency: 1000
        });
    }, false);
});
function successgeo(position) {
    // Die Karte
    var map = null;
    var pinPoint = null;
    var pinPixel = null;
    var latitude = position.coords.latitude;
    var longitude = position.coords.longitude;
    $('#karte').css({
        "width": "300px", "height": "150px"
    });
    var coords = new google.maps.LatLng(latitude, longitude);

    map = new google.maps.Map(document.getElementById("karte"), {
        zoom: 11,
        center: coords,
        mapTypeId: google.maps.MapTypeId.HYBRID
    });
    var marker = new google.maps.Marker({
        position: coords,
        map: map,
        title: "Ihre aktuelle Position!"
    });
    // Die Geschwindigkeit
    speed = Math.floor(position.coords.speed * 3.6);
    if (speed > vmax)
        speed = vmax;
    $("#tacho").html(speed + " Km/h");
    zeichneAnzeige();
}
function successcomp(heading) {
    var anzwinkel = Math.floor(heading.trueHeading) + " &#176;";
    var winkel = Math.floor(heading.trueHeading);
    $('#kompass').html(anzwinkel);
 
    zb1.translate(-125, -125);
    zb1.clearRect(0, 0, 500, 500);
    zb1.translate(125, 125);
    zb1.rotate((winkelalt - winkel) * Math.PI / 180);
    winkelalt = winkel;
    zb1.drawImage(img, -125, -125);
}
function successbeschleu(acceleration) {
    var beschleu = acceleration.z;
    if (beschleunigungsarray.length < 5) {
        beschleunigungsarray[beschleunigungsarray.length] = beschleu;
        return;
    } else {
        beschleu = 0;
        for (var i = 0; i < beschleunigungsarray.length; i++) {
            beschleu += 1 * (beschleunigungsarray[i]);
        };
        beschleu = beschleu / beschleunigungsarray.length;
        beschleunigungsarray = [];
    }
    var aender = beschleu - beschleunigungalt;
    if (aender < -0.5) {
        $('#beschleunigung').css({
            "color": "red"
        });
        $('#beschleunigung').html(Math.floor(aender) + ' m/s^2');
    } else if (aender > 0.5) {
        $('#beschleunigung').css({
            "color": "green"
        });
        $('#beschleunigung').html(Math.floor(aender) + ' m/s^2');
    } else {
        $('#beschleunigung').css({
            "color": "green"
        });
        $('#beschleunigung').html('0 m/s^2');
    }
    beschleunigungalt = beschleu;
}
function errorbeschleu() {
    $('#beschleunigung').css({
        "color": "red"
    });
    $('#beschleunigung').html('0 m/s^2');
}
function errorgeo(msg) {
    $("#tacho").html("0");
}
function errorcomp(compassError) {
    $("#kompass").html(winkel);
}
