var zb = null;
var vmax = 50;
var varray = [0, 10, 20, 30, 40, 50];
var speed = 10;
function zeichneAnzeige() {
    zb = $("#digitacho").get(0).getContext('2d');
    zb.font = "18px Arial";
    zb.fillStyle = "red";
    zb.clearRect(0, 0, 320, 100);
    for (var i = 0; i < varray.length; i++) {
        zb.fillText(varray[i], i * 50, 20);
        zb.fillText("|", i * 50, 40);
    }
    zb.clearRect(0, 45, 270, 55);
    if (speed > vmax)
        zb.fillStyle = "red";
    else
        zb.fillStyle = "green";
    zb.fillRect(0, 45, speed / vmax * 250, 55);
}
$(function () {
    $("#tacho").html("0");
    $("#slider").bind("change", function () {
        vmax = $("#slider").val();
        var skal = Math.floor(vmax / 5);
        for (var i = 1; i < 6; i++) {
            varray[i] = skal * i;
        }
        zeichneAnzeige();
    });
    document.addEventListener("deviceready", function () {
        navigator.geolocation.watchPosition(function (position) {
            speed = Math.floor(position.coords.speed * 3.6);
            if (speed > vmax)
                speed = vmax;
            $("#tacho").html(speed);
            zeichneAnzeige();
        }, function (error) {
            $("#tacho").html("0");
        }, {
            enableHighAccuracy: true, maximumAge: 500,
            timeout: 1000, frequency: 500
        });
    }, false);
});
