﻿var destinationType;
var bildBreite;

(function () {
    "use strict";

    document.addEventListener( 'deviceready', onDeviceReady.bind( this ), false );

    function onDeviceReady() {
        destinationType = navigator.camera.DestinationType;
    };

    $("#aufnahme").click(function () {
        navigator.camera.getPicture(onSuccess1, onFail, {
            quality: 50, destinationType: destinationType.DATA_URL
        });
    });
    $("#loeschen").click(function () {
        $('#bild').css({
            'display': "none"
        });
        $("#meldung").html('Bildanzeige gel&ouml;scht');
    });
    $("#speichern").click(function () {
        navigator.camera.getPicture(onSuccess2, onFail, {
            quality: 50, destinationType: destinationType.FILE_URI,
            saveToPhotoAlbum: true,
            encodingType: navigator.camera.EncodingType.PNG
        });
    });
    function onSuccess1(imageData) {
        bildBreite = (screen.width * 0.9) + "px";
        $('#bild').attr('src', "data:image/jpeg;base64," + imageData);
        $('#bild').css({
            'display': "block", 'width': bildBreite, 'margin': 'auto'
        });
        $("#meldung").html('Aufnahme erfolgreich');
    }
    function onSuccess2(imageData) {
        $("#meldung").html('Aufnahme erfolgreich gespeichert');
    }
    function onFail(message) {
        $("#meldung").html('Fehler bei der Aufnahme: ' + message);
        $('#bild').css({
            'display': "none"
        });
    }

} )();