﻿// Eine Einführung zur leeren Vorlage finden Sie in der folgenden Dokumentation:
// http://go.microsoft.com/fwlink/?LinkID=397704
// So debuggen Sie Code beim Seitenladen in Ripple oder auf Android-Geräten/-Emulatoren: Starten Sie die App, legen Sie Haltepunkte fest, 
// und führen Sie dann "window.location.reload()" in der JavaScript-Konsole aus.
(function () {
    "use strict";

    document.addEventListener( 'deviceready', onDeviceReady.bind( this ), false );

    function onDeviceReady() {
            $("#p_aufnahme").click(function () {
                try {
                    navigator.device.capture.captureImage(onSuccess, onFail, {
                        limit: 5
                    });
                } catch (e) {
                    $("#meldung").html('Bildaufnahme wird nicht unterstützt');
                }
            });
            $("#v_aufnahme").click(function () {
                try {
                    navigator.device.capture.captureVideo(onSuccess, onFail, {
                        duration: 1000
                    });
                } catch (e) {
                    $("#meldung").html('Videoaufnahme wird nicht unterstützt');
                }
            });
            $("#a_aufnahme").click(function () {
                try {
                    navigator.device.capture.captureAudio(onSuccess, onFail, {
                        limit: 2, duration: 1000
                    });
                } catch (e) {
                    $("#meldung").html('Tonaufnahme wird nicht unterstützt');
                }
            });
        function onSuccess(mediaFiles) {
            var i;
            var dateidaten = "";
            $("#meldung").html('<h4>Aufnahme erfolgreich</h4>');
            for (i = 0; i < mediaFiles.length; i++) {
                dateidaten += "<h5>Aufgenommene Datei " + (i + 1) +
                  "</h5>Vollqualifizierter Dateiname:<br />" +
                  mediaFiles[i].fullPath +
                  "<br />Letzte Modifikation:<br />" +
                  new Date(mediaFiles[i].lastModifiedDate) +
                  "<br />MIME-Typ: " + mediaFiles[i].type + "<br/><br/>";
                mediaFiles[i].getFormatData(function (mediaDetails) {
                    for (j in mediaDetails) {
                        dateidaten += j + ": " + mediaDetails[j] + "<br />";
                    }
                }, function () {
                    dateidaten += "Keine Details";
                });
            }
            dateidaten += "<hr />";
            $("#meldung").append(dateidaten);
        }
        function onFail(message) {
            $("#meldung").html('Fehler bei der Aufnahme: ' + message.code);
        }

 
    };

 } )();