pdf_datei<-"karten_deutschland_choropleth_kreise.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8,height=9)

par(mai=c(0,0,0,0),omi=c(1,0.25,1,0.25),family="Lato Light",las=1)
library(maptools)
library(RColorBrewer)

# Daten einlesen und Grafik vorbereiten

x<-readShapeSpatial("daten/Geometrie_Wahlkreise_16DBT_VG1000.shp")
y<-read.csv(file="daten/struktbtwkr2005.csv",head=F,sep=";",dec=".")
kreisstrukturdaten<-subset(y,V2 > 0)
n<-length(x)
position<-vector()
for (i in 1:n){
	position[i]<-match(x$WKR_NR[i], kreisstrukturdaten$V2)
}
farb_nr<-cut(kreisstrukturdaten$V34[position],c(4,9,12.5,16.5,20,24,28))
levels(farb_nr)<-c("4 bis 9 %","9 bis 12.5 %","12.5 bis 16.5 %",
	"16.5 bis 20 %","20 bis 24 %","24 bis 28 %")
farben<-brewer.pal(6,"Oranges")

# Grafik erstellen

plot(x,col=farben[farb_nr],border=grey(.8),lwd=.5)
legend("bottomright",levels(farb_nr),cex=0.95,border=F,bty="n",fill=farben)

# Betitelung

mtext("Arbeitslose auf Wahlkreisebene 2005",3,line=1,adj=0,family="Lato Black",outer=T,cex=2)
mtext("Quelle (Kartengeometrie und Daten): www.bundeswahlleiter.de",1,line=2.6,adj=0,cex=0.95,font=3,outer=T)
dev.off()
