pdf_datei<-"lorenzkurven_panel_05.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11,height=8)

par(omi=c(0.5,0.5,1.1,0.5),family="Lato Light",las=1)
layout(matrix(data=c(1,2,3,4,5),nrow=1,ncol=5),
		widths=c(2.0,1,1,1,1),heights=c(1,1))

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/einkommen_fuenf_klassen.xlsx",skip=1,dec=".")
tdaten<-t(daten)
DD_transparenz<-c(0,50,100,150,200)
DD_zahlenfarbe<-c("black","black","black","black","white")
DD_pos<-c(45,45,45,45,35)
par(cex=1.05)

# Grafik erstellen und weitere Elemente

for (i in 1:5) {
if (i == 1)
{
par(mai=c(0.25,1.75,0.25,0.15))
bp1<-barplot(tdaten[ ,i],horiz=T,cex.names=1.6,axes=F,
			names.arg=gsub("."," ",names(daten),fixed=T),
			xlim=c(0,60),col=rgb(43,15,52,0,maxColorValue=255))
} else
{
par(mai=c(0.25,0.1,0.25,0.15))
bp2<-barplot(tdaten[ ,i],horiz=T,axisnames=F,axes=F,
			xlim=c(0,60),col=rgb(200,0,0,DD_transparenz[i],
			maxColorValue=255),border=par("bg"))
}
text(DD_pos[i],bp1,adj=1,
		labels=paste(round(daten[i ,],digits=0),"%",sep=" "),
		col=DD_zahlenfarbe[i],xpd=T,cex=1.3)
mtext(seq(0,60,by=15),at=seq(0,60,by=15),1,line=0,cex=0.85)
arrows(0,-0.1,0,14.6,lwd=2.5,length=0,xpd=T,col="grey") 
}

# Betitelung

title(main="Einkommensverteilung auf fünf Klassen in verschiedenen Ländern",line=3,adj=0,cex.main=1.75,family="Lato Black",outer=T)
DD_umbruch<-strsplit( strwrap("In Mexiko verfügen die reichsten 20 % der Einkommensempfänger über 64 % des Gesamteinkommens, in Norwegen sind es 40 %. Deutschland liegt im internationalen Vergleich in der oberen Hälfte.",width=110),"\n") 
for(i in seq(along=DD_umbruch)) 
{
mtext(DD_umbruch[[i]],line=(1.8-i)*1.7,adj=0,side=3,cex=1.25,outer=T)
}
mtext("Quelle: World Income Inequality Database V2.0c May 2008",1,line=2,adj=1,font=3)
dev.off()
