pdf_datei<-"streudiagramme_symbole.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=7.5,height=12)

par(omi=c(0.5,0.5,0,0),mai=c(0.5,1.25,0,0.25),family="Lato Light",las=1)
library(maptools)

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/Intra-StateWarData_v4.1.xlsx")
auswahl<-subset(daten, daten$StartYear1>=1995 & daten$SideADeaths > 0 & daten$SideADeaths < 2000 & daten$SideBDeaths > 0 & daten$SideBDeaths < 4000)
attach(auswahl)

farbe<-"darkred"
n<-nrow(auswahl)
h<-rep(0, n)
v<-rep(0, n)
offset<-cbind(h, v)

auswahl[, c("WarName", "StartYear1", "SideADeaths", "SideBDeaths")]
offset[1, "h"]<--400
offset[5, "h"]<-232
offset[4, "h"]<--275
offset[2, "h"]<-270; offset[2, "v"]<-100; 
offset[13, "h"]<--275
offset[12, "h"]<--300

x<-as.numeric(SideADeaths)
y<-as.numeric(SideBDeaths)

# Grafik definieren und weitere Elemente

plot(x, y, typ="n", xlab="", ylab="", axes=F, xlim=c(0, 2000), ylim=c(0, 4000))
axis(1,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
axis(2,col=par("bg"),col.ticks="grey81",lwd.ticks=0.5,tck=-0.025)
text(x+130+offset[, "h"], y-180+offset[, "v"], paste(WarName, StartYear1, sep=" "), cex=0.8, xpd=T, col="grey")

mtext(side=1, "Side A Deaths (Authorities)", adj=0.5, line=3)
mtext(side=2, "Side B Deaths (Rebels)", las=0, adj=0.5, line=4)

# Betitelung

mtext("Deaths by Intra-State Wars",3,adj=1,line=-3,cex=2.1,family="Lato Black")
mtext("1997-2007",3,adj=1,line=-5,cex=1.4,font=3)
mtext("Source: correlatesofwar.org",1,line=1,adj=0,cex=0.95,outer=T,font=3)

# weitere Elemente der Grafik

par(family="Datendesign")
text(x, y, "b", col=farbe, cex=5, xpd=T)
dev.off()


