# ************************************************************
# Sequel Pro SQL dump
# Version 4096
#
# http://www.sequelpro.com/
# http://code.google.com/p/sequel-pro/
#
# Host: localhost (MySQL 5.1.44)
# Datenbank: datendesign
# Erstellungsdauer: 2014-01-31 19:35:06 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Export von Tabelle gemeinden
# ------------------------------------------------------------

DROP TABLE IF EXISTS `gemeinden`;

CREATE TABLE `gemeinden` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `s_land` int(11) DEFAULT NULL,
  `s_rb` int(11) DEFAULT NULL,
  `s_kreis` int(11) DEFAULT NULL,
  `s_verb` int(11) DEFAULT NULL,
  `s_gem` int(11) DEFAULT NULL,
  `gemeinde` varchar(256) CHARACTER SET latin1 DEFAULT NULL,
  `plz` int(11) DEFAULT NULL,
  `flaeche` float DEFAULT NULL,
  `bevinsg` int(11) DEFAULT NULL,
  `bevm` int(11) DEFAULT NULL,
  `bevw` int(11) DEFAULT NULL,
  `bevkm` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

LOCK TABLES `gemeinden` WRITE;
/*!40000 ALTER TABLE `gemeinden` DISABLE KEYS */;

INSERT INTO `gemeinden` (`id`, `s_land`, `s_rb`, `s_kreis`, `s_verb`, `s_gem`, `gemeinde`, `plz`, `flaeche`, `bevinsg`, `bevm`, `bevw`, `bevkm`)
VALUES
	(1,11,0,0,0,0,'Berlin, Stadt',10178,891,3442675,1686256,1756419,3861),
	(2,2,0,0,0,0,'Hamburg, Freie und Hansestadt',20038,755,1774224,866623,907601,2349),
	(3,9,1,62,0,0,'München',80331,310,1330440,643090,687350,4282),
	(4,5,3,15,0,0,'Köln, Stadt',50667,405,998105,482795,515310,2463),
	(5,6,4,12,0,0,'Frankfurt am Main, Stadt',60311,248,671927,328835,343092,2706),
	(6,8,1,11,0,0,'Stuttgart, Landeshauptstadt',70173,207,601646,298015,303631,2902),
	(7,5,1,11,0,0,'Düsseldorf, Stadt',40213,217,586217,279388,306829,2699),
	(8,5,9,13,0,0,'Dortmund, Stadt',44135,280,581308,284669,296639,2073),
	(9,5,1,13,0,0,'Essen, Stadt',45127,210,576259,276910,299349,2740),
	(10,4,0,11,0,0,'Bremen, Stadt',28195,325,547685,265674,282011,1683),
	(11,3,2,41,1,1,'Hannover, Landeshauptstadt',30159,204,520966,251266,269700,2552),
	(12,14,7,13,0,0,'Leipzig, Stadt',4109,297,518862,251748,267114,1745),
	(13,14,6,12,0,0,'Dresden, Stadt',1067,328,517052,252919,264133,1575),
	(14,9,5,64,0,0,'Nürnberg',90403,186,503673,243354,260319,2702),
	(15,5,1,12,0,0,'Duisburg, Stadt',47051,232,491931,241459,250472,2113),
	(16,5,9,11,0,0,'Bochum, Stadt',44787,145,376319,183648,192671,2587),
	(17,5,1,24,0,0,'Wuppertal, Stadt',42275,168,351050,169266,181784,2085),
	(18,5,7,11,0,0,'Bielefeld, Stadt',33602,257,323084,154497,168587,1253),
	(19,5,3,14,0,0,'Bonn, Stadt',53111,141,319841,153345,166496,2265),
	(20,8,2,22,0,0,'Mannheim, Universitätsstadt',68159,144,311969,154640,157329,2152),
	(21,8,2,12,0,0,'Karlsruhe, Stadt',76133,173,291959,145419,146540,1683),
	(22,6,4,14,0,0,'Wiesbaden, Landeshauptstadt',65183,203,277493,133654,143839,1361),
	(23,5,5,15,0,0,'Münster, Stadt',48143,302,275543,129246,146297,910),
	(24,9,7,61,0,0,'Augsburg',86150,146,263646,127308,136338,1795),
	(25,5,5,13,0,0,'Gelsenkirchen, Stadt',45879,104,259744,126065,133679,2477),
	(26,5,3,34,2,2,'Aachen, Stadt',52062,160,258380,133028,125352,1606),
	(27,5,1,16,0,0,'Mönchengladbach, Stadt',41061,170,258251,125317,132934,1515),
	(28,3,1,1,0,0,'Braunschweig, Stadt',38100,192,247400,121742,125658,1288),
	(29,14,5,11,0,0,'Chemnitz, Stadt',9111,220,243089,116856,126233,1101),
	(30,1,0,2,0,0,'Kiel, Landeshauptstadt',24103,118,238281,116559,121722,2008),
	(31,5,1,14,0,0,'Krefeld, Stadt',47803,137,235414,114249,121165,1709),
	(32,15,0,2,0,0,'Halle (Saale), Stadt',6108,135,232323,110209,122114,1721),
	(33,15,0,3,0,0,'Magdeburg, Landeshauptstadt',39104,200,230456,111848,118608,1148),
	(34,8,3,11,0,0,'Freiburg im Breisgau, Stadt',79098,153,221924,105859,116065,1450),
	(35,5,1,19,0,0,'Oberhausen, Stadt',46045,77,214024,104050,109974,2776),
	(36,1,0,3,0,0,'Lübeck, Hansestadt',23539,214,209818,99747,110071,979),
	(37,16,0,51,0,0,'Erfurt, Stadt',99084,269,203830,98616,105214,757),
	(38,13,0,3,0,0,'Rostock, Hansestadt',18055,181,201442,98911,102531,1111),
	(39,7,3,15,0,0,'Mainz, Stadt',55116,97,197778,95324,102454,2024),
	(40,6,6,11,0,0,'Kassel, documenta-Stadt',34117,106,194774,93227,101547,1824),
	(41,5,9,14,0,0,'Hagen, Stadt',58095,160,190121,91545,98576,1186),
	(42,5,9,15,0,0,'Hamm, Stadt',59065,226,181741,90251,91490,803),
	(43,10,0,41,100,100,'Saarbrücken, Landeshauptstadt',66111,167,175810,84510,91300,1052),
	(44,5,1,17,0,0,'Mülheim an der Ruhr, Stadt',45468,91,167471,80190,87281,1834),
	(45,5,9,16,0,0,'Herne, Stadt',44623,51,165632,81301,84331,3222),
	(46,3,4,4,0,0,'Osnabrück, Stadt',49074,119,163514,78156,85358,1365),
	(47,7,3,14,0,0,'Ludwigshafen am Rhein, Stadt',67059,77,163340,81375,81965,2106),
	(48,3,4,3,0,0,'Oldenburg (Oldenburg), Stadt',26122,102,161334,77859,83475,1567),
	(49,5,1,22,0,0,'Solingen, Stadt',42651,89,160992,77892,83100,1799),
	(50,5,3,16,0,0,'Leverkusen, Stadt',51373,78,160593,77708,82885,2036),
	(51,12,0,54,0,0,'Potsdam, Stadt',14461,187,154606,74859,79747,825),
	(52,5,1,62,24,24,'Neuss, Stadt',41460,99,151280,73224,78056,1520),
	(53,8,2,21,0,0,'Heidelberg, Stadt',69117,108,146466,69258,77208,1346),
	(54,5,7,74,32,32,'Paderborn, Stadt',33098,179,145320,71448,73872,810),
	(55,6,4,11,0,0,'Darmstadt, Wissenschaftsstadt',64283,122,143332,71333,71999,1174),
	(56,9,3,62,0,0,'Regensburg',93047,80,134218,64311,69907,1663),
	(57,9,6,63,0,0,'Würzburg',97070,87,133195,62011,71184,1520),
	(58,9,1,61,0,0,'Ingolstadt',85049,133,124387,61932,62455,933),
	(59,8,1,21,0,0,'Heilbronn, Stadt',74072,99,122415,60412,62003,1226),
	(60,8,4,21,0,0,'Ulm, Universitätsstadt',89073,118,122087,60096,61991,1029),
	(61,3,1,52,12,12,'Göttingen, Stadt',37083,116,121457,58767,62690,1039),
	(62,3,1,3,0,0,'Wolfsburg, Stadt',38440,204,121109,59460,61649,594),
	(63,8,2,31,0,0,'Pforzheim, Stadt',75175,98,119788,57917,61871,1222),
	(64,5,5,62,32,32,'Recklinghausen, Stadt',45657,66,119050,57539,61511,1792),
	(65,6,4,13,0,0,'Offenbach am Main, Stadt',63065,44,118770,59406,59364,2646),
	(66,5,5,12,0,0,'Bottrop, Stadt',46236,100,117241,56504,60737,1165),
	(67,9,5,63,0,0,'Fürth',90762,63,114044,55209,58835,1800),
	(68,4,0,12,0,0,'Bremerhaven, Stadt',27576,78,114031,56553,57478,1446),
	(69,8,4,15,61,61,'Reutlingen, Stadt',72764,87,112132,54714,57418,1288),
	(70,5,1,20,0,0,'Remscheid, Stadt',42853,74,111422,54033,57389,1494),
	(71,7,1,11,0,0,'Koblenz, Stadt',56068,105,106445,51098,55347,1013),
	(72,5,1,70,24,24,'Moers, Stadt',47441,67,105929,51037,54892,1565),
	(73,5,3,78,4,4,'Bergisch Gladbach, Stadt',51465,83,105699,50887,54812,1272),
	(74,9,5,62,0,0,'Erlangen',91052,76,105554,51696,53858,1372),
	(75,7,2,11,0,0,'Trier, Stadt',54290,117,104587,49576,55011,893),
	(76,16,0,53,0,0,'Jena, Stadt',7743,114,104449,51638,52811,912),
	(77,5,9,70,40,40,'Siegen, Stadt',57072,114,103984,51202,52782,907),
	(78,3,1,2,0,0,'Salzgitter, Stadt',38226,223,103446,50632,52814,462),
	(79,3,2,54,21,21,'Hildesheim, Stadt',31134,92,102903,48478,54425,1116),
	(80,12,0,52,0,0,'Cottbus, Stadt',3046,164,101671,49916,51755,619),
	(81,16,0,52,0,0,'Gera, Stadt',7545,151,99987,48326,51661,658),
	(82,7,3,12,0,0,'Kaiserslautern, Stadt',67657,139,99275,49991,49284,711),
	(83,5,9,54,36,36,'Witten, Stadt',58452,72,98601,47357,51244,1362),
	(84,5,7,54,8,8,'Gütersloh, Stadt',33330,111,96320,47241,49079,860),
	(85,5,9,62,24,24,'Iserlohn, Stadt',58636,125,95232,46373,48859,759),
	(86,13,0,4,0,0,'Schwerin, Landeshauptstadt',19053,130,95041,45627,49414,728),
	(87,14,5,24,330,330,'Zwickau, Stadt',8056,102,94340,45379,48961,920),
	(88,5,3,58,8,8,'Düren, Stadt',52349,85,92906,46721,46185,1093),
	(89,8,1,16,19,19,'Esslingen am Neckar, Stadt',73728,46,91463,45018,46445,1970),
	(90,5,1,58,28,28,'Ratingen, Stadt',40878,88,91306,43719,47587,1029),
	(91,1,0,1,0,0,'Flensburg, Stadt',24937,56,88502,43648,44854,1560),
	(92,6,4,35,14,14,'Hanau, Stadt',63450,76,88358,43297,45061,1155),
	(93,5,5,62,24,24,'Marl, Stadt',45768,87,88202,42953,45249,1007),
	(94,8,4,16,41,41,'Tübingen, Universitätsstadt',72070,108,87788,42261,45527,812),
	(95,5,9,78,24,24,'Lünen, Stadt',44532,59,87783,42469,45314,1483),
	(96,15,0,1,0,0,'Dessau-Roßlau, Stadt',6844,244,87764,42184,45580,359),
	(97,8,1,18,48,48,'Ludwigsburg, Stadt',71638,43,87460,42423,45037,2018),
	(98,5,1,58,32,32,'Velbert, Stadt',42551,74,84633,40992,43641,1130),
	(99,8,3,35,5004,43,'Konstanz, Universitätsstadt',78462,54,83644,40422,43222,1546),
	(100,5,7,70,24,24,'Minden, Stadt',32423,101,82400,40036,42364,815),
	(101,7,3,19,0,0,'Worms, Stadt',67547,108,81784,39991,41793,752),
	(102,3,4,5,0,0,'Wilhelmshaven, Stadt',26382,106,81137,40760,40377,759),
	(103,8,3,26,5004,74,'Villingen-Schwenningen, Stadt',78050,165,80941,39144,41797,489),
	(104,6,5,34,14,14,'Marburg, Universitätsstadt',35037,123,80123,38239,41884,647),
	(105,5,5,62,12,12,'Dorsten, Stadt',46284,171,77308,37615,39693,452),
	(106,1,0,4,0,0,'Neumünster, Stadt',24534,71,76897,37718,39179,1074),
	(107,5,5,66,76,76,'Rheine, Stadt',48431,144,76529,38020,38509,528),
	(108,6,5,31,5,5,'Gießen, Universitätsstadt',35390,72,76090,36303,39787,1049),
	(109,5,9,62,32,32,'Lüdenscheid, Stadt',58507,86,75946,37220,38726,876),
	(110,5,5,62,4,4,'Castrop-Rauxel, Stadt',44575,51,75762,36676,39086,1466),
	(111,5,5,62,14,14,'Gladbeck, Stadt',45964,35,75520,36498,39022,2103),
	(112,5,1,66,32,32,'Viersen, Stadt',41747,91,75475,36376,39099,829),
	(113,5,3,82,68,68,'Troisdorf, Stadt',53840,62,75150,37102,38048,1209),
	(114,5,9,58,4,4,'Arnsberg, Stadt',59759,193,74805,36582,38223,387),
	(115,3,4,1,0,0,'Delmenhorst, Stadt',27749,62,74512,36613,37899,1195),
	(116,5,5,54,8,8,'Bocholt, Stadt',46395,119,73279,35904,37375,614),
	(117,5,7,66,20,20,'Detmold, Stadt',32756,129,73003,34505,38498,564),
	(118,3,3,55,22,22,'Lüneburg, Hansestadt',21335,70,72800,35281,37519,1035),
	(119,9,4,62,0,0,'Bayreuth',95444,66,72576,35007,37569,1085),
	(120,12,0,51,0,0,'Brandenburg an der Havel, Stadt',14770,228,72264,35558,36706,316),
	(121,1,0,60,63,63,'Norderstedt, Stadt',22846,58,71970,34740,37230,1239),
	(122,3,3,51,6,6,'Celle, Stadt',29221,175,70446,33701,36745,402),
	(123,9,4,61,0,0,'Bamberg',96047,54,69827,32612,37215,1278),
	(124,5,1,70,8,8,'Dinslaken, Stadt',46535,47,69687,33896,35791,1462),
	(125,9,6,61,0,0,'Aschaffenburg',63739,62,68722,32915,35807,1100),
	(126,5,9,74,28,28,'Lippstadt, Stadt',59555,113,66948,32549,34399,589),
	(127,5,9,78,36,36,'Unna, Stadt',59423,88,66652,33589,33063,753),
	(128,14,5,23,320,320,'Plauen, Stadt',8523,102,66412,31960,34452,650),
	(129,8,1,36,5001,88,'Aalen, Stadt',73430,146,66196,32678,33518,451),
	(130,16,0,55,0,0,'Weimar, Stadt',99423,84,65233,31562,33671,775),
	(131,13,0,2,0,0,'Neubrandenburg, Stadt',17033,85,65137,31675,33462,760),
	(132,5,3,62,32,32,'Kerpen, Stadt',50171,113,64669,31748,32921,568),
	(133,7,1,38,45,45,'Neuwied, Stadt',56564,86,64591,31359,33232,747),
	(134,5,7,58,12,12,'Herford, Stadt',32052,79,64469,30893,33576,816),
	(135,6,6,31,9,9,'Fulda, Stadt',36037,104,64177,30885,33292,617),
	(136,5,1,62,8,8,'Grevenbroich, Stadt',41515,102,64039,31694,32345,625),
	(137,5,1,62,4,4,'Dormagen, Stadt',41539,85,62924,31215,31709,736),
	(138,9,2,61,0,0,'Landshut',84028,65,62735,29767,32968,953),
	(139,5,5,62,20,20,'Herten, Stadt',45699,37,62639,30375,32264,1678),
	(140,5,3,62,8,8,'Bergheim, Stadt',50126,96,62143,31050,31093,645),
	(141,9,7,63,0,0,'Kempten (Allgäu)',87435,63,62007,29528,32479,980),
	(142,3,2,41,5,5,'Garbsen, Stadt',30827,79,61818,30074,31744,779),
	(143,5,1,70,48,48,'Wesel, Stadt',46483,122,60958,29532,31426,497),
	(144,9,1,63,0,0,'Rosenheim',83022,37,60877,29768,31109,1636),
	(145,12,0,53,0,0,'Frankfurt (Oder), Stadt',15230,147,60625,29420,31205,410),
	(146,8,1,15,45,45,'Sindelfingen, Stadt',71063,50,60475,29968,30507,1189),
	(147,8,1,36,5007,65,'Schwäbisch Gmünd, Stadt',73525,113,60167,29134,31033,529),
	(148,6,4,33,12,12,'Rüsselsheim, Stadt',65428,58,59847,29722,30125,1027),
	(149,8,3,17,5010,96,'Offenburg, Stadt',77652,78,59156,28758,30398,755),
	(150,5,1,58,20,20,'Langenfeld (Rheinland), Stadt',40764,41,59038,28831,30207,1435),
	(151,8,4,35,5002,16,'Friedrichshafen, Stadt',88045,69,58726,28887,29839,840),
	(152,3,2,52,6,6,'Hameln, Stadt',31785,102,57906,27914,29992,566),
	(153,13,0,5,0,0,'Stralsund, Hansestadt',18439,39,57778,27988,29790,1480),
	(154,5,3,34,32,32,'Stolberg (Rhld.), Stadt',52222,98,57755,28446,29309,586),
	(155,5,3,62,28,28,'Hürth, Stadt',50354,51,57501,28254,29247,1123),
	(156,8,1,17,5005,26,'Göppingen, Stadt',73033,59,57068,27922,29146,964),
	(157,5,9,62,40,40,'Menden (Sauerland), Stadt',58706,86,56078,27609,28469,652),
	(158,14,6,26,110,110,'Görlitz, Stadt',2826,67,55957,26811,29146,832),
	(159,5,3,66,16,16,'Euskirchen, Stadt',53879,139,55871,27310,28561,401),
	(160,5,9,54,16,16,'Hattingen, Stadt',45525,71,55817,26767,29050,782),
	(161,5,1,58,16,16,'Hilden, Stadt',40721,25,55551,26638,28913,2140),
	(162,5,3,82,56,56,'Sankt Augustin, Stadt',53757,34,55524,27223,28301,1622),
	(163,5,3,34,12,12,'Eschweiler, Stadt',52249,75,55389,26769,28620,729),
	(164,8,2,11,0,0,'Baden-Baden, Stadt',76530,140,54494,25381,29113,389),
	(165,13,0,1,0,0,'Greifswald, Hansestadt',17489,50,54362,26015,28347,1076),
	(166,5,1,62,22,22,'Meerbusch, Stadt',40667,64,54190,25724,28466,842),
	(167,5,7,66,8,8,'Bad Salzuflen, Stadt',32105,100,54010,25720,28290,540),
	(168,5,3,62,36,36,'Pulheim, Stadt',50259,72,53842,26035,27807,746),
	(169,9,6,62,0,0,'Schweinfurt',97421,35,53533,25675,27858,1500),
	(170,7,3,16,0,0,'Neustadt an der Weinstraße, Stadt',67433,117,53525,25771,27754,457),
	(171,5,5,70,4,4,'Ahlen, Stadt',59227,123,53516,26010,27506,435),
	(172,3,1,58,37,37,'Wolfenbüttel, Stadt',38300,78,53460,25912,27548,680),
	(173,3,4,56,15,15,'Nordhorn, Stadt',48529,149,53353,26096,27257,356),
	(174,9,7,75,135,135,'Neu-Ulm, GKSt',89231,80,53034,26334,26700,655),
	(175,8,1,19,79,79,'Waiblingen, Stadt',71332,42,52776,25883,26893,1234),
	(176,3,2,41,10,10,'Langenhagen, Stadt',30853,71,51982,25281,26701,723),
	(177,5,1,66,36,36,'Willich, Stadt',47877,67,51962,25387,26575,767),
	(178,6,4,34,1,1,'Bad Homburg v. d. Höhe, Stadt',61348,51,51887,24185,27702,1014),
	(179,5,3,74,12,12,'Gummersbach, Stadt',51643,95,51545,25132,26413,540),
	(180,6,5,32,23,23,'Wetzlar, Stadt',35578,75,51497,24712,26785,681),
	(181,5,5,66,28,28,'Ibbenbüren, Stadt',49477,108,51477,25404,26073,474),
	(182,3,4,54,32,32,'Lingen (Ems), Stadt',49808,176,51459,25358,26101,292),
	(183,3,4,2,0,0,'Emden, Stadt',26721,112,51292,25430,25862,457),
	(184,5,9,78,4,4,'Bergkamen, Stadt',59192,44,51149,25382,25767,1141),
	(185,3,3,52,11,11,'Cuxhaven, Stadt',27472,161,50846,24403,26443,314),
	(186,5,3,62,20,20,'Erftstadt, Stadt',50374,119,50754,24751,26003,423),
	(187,9,2,62,0,0,'Passau',94032,69,50627,23863,26764,728),
	(188,7,3,18,0,0,'Speyer, Stadt',67346,42,49811,23951,25860,1170),
	(189,5,3,62,24,24,'Frechen, Stadt',50226,45,49752,24060,25692,1103),
	(190,8,4,36,5005,64,'Ravensburg, Stadt',88212,92,49418,23848,25570,537),
	(191,5,1,54,36,36,'Kleve, Stadt',47533,97,49392,24193,25199,505),
	(192,3,1,57,6,6,'Peine, Stadt',31224,119,49038,23902,25136,410),
	(193,5,9,74,40,40,'Soest, Stadt',59494,85,48573,23410,25163,566),
	(194,5,3,82,12,12,'Bornheim, Stadt',53332,82,48544,23833,24711,587),
	(195,5,9,78,28,28,'Schwerte, Stadt',58239,56,48523,23527,24996,863),
	(196,5,7,70,4,4,'Bad Oeynhausen, Stadt',32545,64,48516,23150,25366,749),
	(197,8,1,35,5002,19,'Heidenheim an der Brenz, Stadt',89522,107,48503,23501,25002,453),
	(198,1,0,56,15,15,'Elmshorn, Stadt',25335,21,48444,23542,24902,2267),
	(199,8,3,36,5003,50,'Lörrach, Stadt',79539,39,48190,23279,24911,1222),
	(200,10,0,43,114,114,'Neunkirchen, Kreisstadt',66538,75,47896,23325,24571,638),
	(201,8,2,16,5005,43,'Rastatt, Stadt',76437,59,47413,23113,24300,803),
	(202,15,0,91,375,375,'Wittenberg, Lutherstadt',6886,160,47256,22693,24563,295),
	(203,5,3,34,16,16,'Herzogenrath, Stadt',52134,33,47054,23025,24029,1409),
	(204,5,7,54,28,28,'Rheda-Wiedenbrück, Stadt',33378,86,46988,23251,23737,542),
	(205,7,3,11,0,0,'Frankenthal (Pfalz), Stadt',67227,43,46874,22973,23901,1071),
	(206,5,5,58,16,16,'Dülmen, Stadt',48249,184,46817,22681,24136,254),
	(207,9,4,64,0,0,'Hof',95028,58,46779,22338,24441,806),
	(208,5,5,54,20,20,'Gronau (Westf.), Stadt',48599,78,46549,22910,23639,591),
	(209,3,4,59,24,24,'Melle, Stadt',49324,254,46352,22897,23455,182),
	(210,8,1,15,3,3,'Böblingen, Stadt',71032,39,46198,22675,23523,1183),
	(211,5,1,58,4,4,'Erkrath, Stadt',40699,26,46084,22203,23881,1716),
	(212,3,3,59,38,38,'Stade, Hansestadt',21682,110,46080,22234,23846,419),
	(213,15,0,82,5001,15,'Bitterfeld-Wolfen, Stadt',6766,87,45968,22007,23961,526),
	(214,5,3,82,20,20,'Hennef (Sieg), Stadt',53773,105,45875,22704,23171,433),
	(215,16,0,67,29,29,'Gotha, Stadt',99867,69,45736,22266,23470,658),
	(216,5,3,34,4,4,'Alsdorf, Stadt',52477,31,45721,22567,23154,1444),
	(217,8,3,35,5005,75,'Singen (Hohentwiel), Stadt',78224,61,45427,21983,23444,735),
	(218,8,4,17,5001,79,'Albstadt, Stadt',72458,134,45327,22136,23191,337),
	(219,3,2,41,12,12,'Neustadt am Rübenberge, Stadt',31535,357,45237,22388,22849,127),
	(220,8,1,15,28,28,'Leonberg, Stadt',71229,48,45236,22097,23139,928),
	(221,9,1,78,124,124,'Freising, GKSt',85354,88,45118,22250,22868,509),
	(222,5,9,78,20,20,'Kamen, Stadt',59174,40,44803,21645,23158,1095),
	(223,5,7,58,4,4,'Bünde, Stadt',32257,59,44733,21558,23175,754),
	(224,5,3,70,4,4,'Erkelenz, Stadt',41812,117,44583,21846,22737,380),
	(225,9,2,63,0,0,'Straubing',94315,67,44493,22147,22346,658),
	(226,13,0,6,0,0,'Wismar, Hansestadt',23952,41,44470,21847,22623,1068),
	(227,8,1,19,20,20,'Fellbach, Stadt',70734,27,44354,21606,22748,1601),
	(228,5,3,62,12,12,'Brühl, Stadt',50321,36,44259,21236,23023,1225),
	(229,16,0,62,41,41,'Nordhausen, Stadt',99734,105,44127,21602,22525,419),
	(230,8,1,16,77,77,'Filderstadt, Stadt',70794,38,44099,21580,22519,1144),
	(231,8,3,17,5007,65,'Lahr/Schwarzwald, Stadt',77933,69,43721,21330,22391,626),
	(232,9,3,61,0,0,'Amberg',92224,50,43715,21192,22523,872),
	(233,8,2,26,96,96,'Weinheim, Stadt',69469,58,43627,21153,22474,751),
	(234,10,0,45,114,114,'Homburg, Kreisstadt',66424,82,43569,21316,22253,527),
	(235,7,1,33,6,6,'Bad Kreuznach, Stadt',55545,46,43485,20584,22901,943),
	(236,6,4,34,8,8,'Oberursel (Taunus), Stadt',61440,45,43425,20785,22640,957),
	(237,3,2,41,11,11,'Lehrte, Stadt',31275,127,43339,21362,21977,341),
	(238,8,2,15,5003,9,'Bruchsal, Stadt',76646,93,43184,21501,21683,464),
	(239,6,4,38,11,11,'Rodgau, Stadt',63110,65,43132,21245,21887,663),
	(240,5,1,58,26,26,'Monheim am Rhein, Stadt',40789,23,43065,21188,21877,1868),
	(241,7,3,13,0,0,'Landau in der Pfalz, Stadt',76829,82,42994,20596,22398,518),
	(242,16,0,56,0,0,'Eisenach, Stadt',99817,103,42847,20904,21943,413),
	(243,8,1,18,5002,79,'Bietigheim-Bissingen, Stadt',74321,31,42791,20868,21923,1368),
	(244,8,4,16,5003,36,'Rottenburg am Neckar, Stadt',72108,142,42443,21378,21065,298),
	(245,1,0,56,39,39,'Pinneberg, Stadt',25421,21,42314,20593,21721,1964),
	(246,9,1,74,115,115,'Dachau, GKSt',85221,34,42117,20379,21738,1205),
	(247,9,3,63,0,0,'Weiden i.d.OPf.',92637,70,42058,19934,22124,596),
	(248,5,1,66,16,16,'Nettetal, Stadt',41334,83,42041,20562,21479,501),
	(249,9,7,62,0,0,'Kaufbeuren',87600,40,41881,20027,21854,1046),
	(250,3,3,53,31,31,'Seevetal',21218,105,41860,20668,21192,398),
	(251,5,1,62,16,16,'Kaarst, Stadt',41564,37,41841,20131,21710,1119),
	(252,14,5,22,5109,180,'Freiberg, Stadt',9599,48,41701,20532,21169,868),
	(253,5,7,66,44,44,'Lemgo, Stadt',32657,100,41619,20329,21290,413),
	(254,3,1,51,9,9,'Gifhorn, Stadt',38518,104,41616,20605,21011,397),
	(255,12,0,65,256,256,'Oranienburg, Stadt',16515,161,41590,20544,21046,257),
	(256,3,1,53,5,5,'Goslar, Stadt',38640,92,41455,19956,21499,448),
	(257,5,5,54,12,12,'Borken, Stadt',46325,152,41216,20320,20896,270),
	(258,9,4,63,0,0,'Coburg',96450,48,41177,19613,21564,853),
	(259,12,0,60,52,52,'Eberswalde, Stadt',16225,93,41175,20147,21028,440),
	(260,3,2,41,21,21,'Wunstorf, Stadt',31515,125,41134,20010,21124,327),
	(261,9,7,64,0,0,'Memmingen',87700,70,41085,19908,21177,586),
	(262,5,3,70,16,16,'Heinsberg, Stadt',52525,92,40991,20100,20891,445),
	(263,5,3,82,24,24,'Königswinter, Stadt',53639,76,40868,19788,21080,536),
	(264,7,3,17,0,0,'Pirmasens, Stadt',66953,61,40808,19891,20917,665),
	(265,14,6,25,20,20,'Bautzen, Stadt',2625,66,40740,19581,21159,612),
	(266,3,4,52,1,1,'Aurich, Stadt',26603,197,40491,19647,20844,205),
	(267,9,5,61,0,0,'Ansbach',91522,99,40420,19174,21246,405),
	(268,8,1,16,5005,49,'Nürtingen, Stadt',72622,46,40345,19772,20573,860),
	(269,6,4,38,2,2,'Dreieich, Stadt',63303,53,40336,19687,20649,757),
	(270,5,7,58,24,24,'Löhne, Stadt',32584,59,40313,19578,20735,678),
	(271,3,2,41,9,9,'Laatzen, Stadt',30880,34,40273,19299,20974,1182),
	(272,12,0,63,80,80,'Falkensee, Stadt',14612,43,40179,19662,20517,928),
	(273,8,1,16,5001,33,'Kirchheim unter Teck, Stadt',73230,40,39786,19340,20446,983),
	(274,10,0,41,519,519,'Völklingen, Stadt',66333,67,39784,19347,20437,593),
	(275,5,3,82,60,60,'Siegburg, Stadt',53721,23,39654,19234,20420,1692),
	(276,6,4,31,2,2,'Bensheim, Stadt',64625,57,39583,19384,20199,684),
	(277,3,3,59,10,10,'Buxtehude, Stadt',21614,76,39542,19923,19619,517),
	(278,16,0,54,0,0,'Suhl, Stadt',98527,102,39526,19519,20007,385),
	(279,5,1,58,24,24,'Mettmann, Stadt',40822,42,39374,19029,20345,926),
	(280,8,1,19,5003,67,'Schorndorf, Stadt',73614,56,39372,19126,20246,693),
	(281,5,3,70,20,20,'Hückelhoven, Stadt',41836,61,39201,19163,20038,640),
	(282,14,6,28,110,110,'Freital, Stadt',1705,40,39200,19269,19931,967),
	(283,9,3,73,147,147,'Neumarkt i.d.OPf., GKSt',92318,79,39195,18844,20351,496),
	(284,14,6,28,5229,270,'Pirna, Stadt',1796,53,39030,18854,20176,736),
	(285,5,5,54,4,4,'Ahaus, Stadt',48683,151,38879,19445,19434,257),
	(286,9,5,65,0,0,'Schwabach',91126,40,38751,18614,20137,949),
	(287,5,1,70,20,20,'Kamp-Lintfort, Stadt',47475,63,38724,18794,19930,613),
	(288,8,2,15,17,17,'Ettlingen, Stadt',76275,56,38614,18572,20042,681),
	(289,3,3,53,5,5,'Buchholz in der Nordheide, Stadt',21244,74,38517,18521,19996,516),
	(290,6,4,36,7,7,'Hofheim am Taunus, Kreisstadt',65719,57,38265,18676,19589,667),
	(291,14,6,25,240,240,'Hoyerswerda, Stadt',2977,95,38218,18480,19738,402),
	(292,5,5,70,52,52,'Warendorf, Stadt',48231,176,38201,18604,19597,216),
	(293,15,0,85,135,135,'Halberstadt, Stadt',38820,82,38169,18439,19730,464),
	(294,5,5,62,16,16,'Haltern am See, Stadt',45721,158,37961,18577,19384,240),
	(295,6,4,35,19,19,'Maintal, Stadt',63477,32,37790,18470,19320,1166),
	(296,5,1,70,44,44,'Voerde (Niederrhein), Stadt',46562,53,37668,18310,19358,704),
	(297,5,3,34,36,36,'Würselen, Stadt',52146,34,37654,18164,19490,1095),
	(298,5,9,62,16,16,'Hemer, Stadt',58675,67,37479,18653,18826,555),
	(299,5,3,82,44,44,'Niederkassel, Stadt',53859,35,37402,18513,18889,1045),
	(300,10,0,45,117,117,'St. Ingbert, Stadt',66386,49,37361,17820,19541,748),
	(301,10,0,44,115,115,'Saarlouis, Kreisstadt',66740,43,37328,18158,19170,863),
	(302,9,1,79,123,123,'Germering, GKSt',82110,21,37283,17803,19480,1725),
	(303,8,1,16,78,78,'Leinfelden-Echterdingen, Stadt',70771,29,37074,18024,19050,1240),
	(304,8,1,27,5009,76,'Schwäbisch Hall, Stadt',74523,104,36799,17528,19271,353),
	(305,5,5,70,8,8,'Beckum, Stadt',59269,111,36764,18103,18661,330),
	(306,5,5,58,12,12,'Coesfeld, Stadt',48653,141,36474,17776,18698,259),
	(307,12,0,60,20,20,'Bernau bei Berlin, Stadt',16321,103,36154,17799,18355,349),
	(308,16,0,64,46,46,'Mühlhausen/Thüringen, Stadt',99974,86,36100,17953,18147,418),
	(309,5,1,66,12,12,'Kempen, Stadt',47906,68,36040,17540,18500,524),
	(310,8,1,16,80,80,'Ostfildern, Stadt',73760,22,35932,17558,18374,1575),
	(311,5,5,66,12,12,'Greven, Stadt',48268,140,35887,17611,18276,256),
	(312,5,5,62,8,8,'Datteln, Stadt',45711,66,35757,17424,18333,541),
	(313,6,4,38,9,9,'Neu-Isenburg, Stadt',63263,24,35701,17203,18498,1469),
	(314,5,3,78,32,32,'Wermelskirchen, Stadt',42929,74,35611,17319,18292,476),
	(315,5,5,66,8,8,'Emsdetten, Stadt',48282,71,35604,17354,18250,495),
	(316,8,2,26,5008,85,'Sinsheim, Stadt',74889,127,35566,17481,18085,280),
	(317,15,0,90,5006,535,'Stendal, Stadt',39576,82,35521,17122,18399,432),
	(318,16,0,77,1,1,'Altenburg, Stadt',4600,45,35447,17071,18376,777),
	(319,6,4,38,6,6,'Langen (Hessen), Stadt',63225,29,35430,17268,18162,1217),
	(320,8,1,19,5001,8,'Backnang, Stadt',71522,39,35415,17568,17847,899),
	(321,5,7,70,32,32,'Porta Westfalica, Stadt',32457,105,35348,17377,17971,336),
	(322,5,7,66,40,40,'Lage, Stadt',32791,76,35267,17113,18154,464),
	(323,5,3,62,40,40,'Wesseling, Stadt',50389,23,35144,17082,18062,1504),
	(324,3,4,54,41,41,'Papenburg, Stadt',26871,118,35073,17489,17584,296),
	(325,3,4,54,35,35,'Meppen, Stadt',49716,188,34773,17368,17405,184),
	(326,8,3,17,57,57,'Kehl, Stadt',77694,75,34657,16863,17794,462),
	(327,8,3,27,5006,50,'Tuttlingen, Stadt',78532,90,34590,16879,17711,382),
	(328,12,0,73,532,532,'Schwedt/Oder, Stadt',16303,203,34586,17100,17486,170),
	(329,9,1,77,117,117,'Erding, St',85435,54,34410,16595,17815,630),
	(330,14,6,27,230,230,'Riesa, Stadt',1589,58,34324,16658,17666,583),
	(331,15,0,88,5006,220,'Merseburg, Stadt',6217,41,34313,16405,17908,834),
	(332,15,0,89,305,305,'Schönebeck (Elbe), Stadt',39218,85,34305,16612,17693,400),
	(333,3,3,60,25,25,'Uelzen, Stadt',29525,135,34302,16459,17843,253),
	(334,3,4,57,13,13,'Leer (Ostfriesland), Stadt',26789,70,34288,16931,17357,488),
	(335,7,3,20,0,0,'Zweibrücken, Stadt',66482,70,34109,16790,17319,483),
	(336,5,5,66,84,84,'Steinfurt, Stadt',48565,111,34085,16891,17194,306),
	(337,9,1,79,121,121,'Fürstenfeldbruck, GKSt',82256,32,34069,16760,17309,1047),
	(338,5,1,54,16,16,'Goch, Stadt',47574,115,34036,16818,17218,295),
	(339,3,3,53,40,40,'Winsen (Luhe), Stadt',21423,109,34034,16814,17220,311),
	(340,8,4,17,5002,2,'Balingen, Stadt',72336,90,33933,16575,17358,376),
	(341,6,4,33,8,8,'Mörfelden-Walldorf, Stadt',64546,44,33867,17313,16554,767),
	(342,15,0,85,370,370,'Wernigerode, Stadt',38855,165,33821,16110,17711,205),
	(343,5,1,54,12,12,'Geldern, Stadt',47608,96,33786,16689,17097,349),
	(344,12,0,61,260,260,'Königs Wusterhausen, Stadt',15711,95,33762,16472,17290,352),
	(345,3,2,41,2,2,'Barsinghausen, Stadt',30890,102,33667,16348,17319,328),
	(346,14,6,27,210,210,'Radebeul, Stadt',1445,26,33466,16217,17249,1284),
	(347,6,5,33,9,9,'Limburg a.d. Lahn, Kreisstadt',65549,45,33423,16018,17405,740),
	(348,6,4,38,1,1,'Dietzenbach, Kreisstadt',63128,21,33224,16597,16627,1533),
	(349,3,2,51,37,37,'Stuhr',28816,81,33151,16195,16956,406),
	(350,5,3,58,24,24,'Jülich, Stadt',52428,90,33133,16299,16834,367),
	(351,5,1,62,20,20,'Korschenbroich, Stadt',41352,55,33116,16161,16955,599),
	(352,8,1,27,5002,14,'Crailsheim, Stadt',74564,109,33043,16340,16703,303),
	(353,3,2,41,15,15,'Seelze, Stadt',30926,54,32683,15993,16690,605),
	(354,6,4,31,20,20,'Viernheim, Stadt',68519,48,32596,15780,16816,673),
	(355,1,0,61,46,46,'Itzehoe, Stadt',25524,28,32583,15669,16914,1162),
	(356,12,0,67,144,144,'Fürstenwalde/Spree, Stadt',15517,70,32576,16032,16544,462),
	(357,3,4,53,4,4,'Cloppenburg, Stadt',49661,70,32458,15952,16506,460),
	(358,8,4,26,5003,21,'Biberach an der Riß, Stadt',88400,72,32424,15728,16696,449),
	(359,1,0,56,50,50,'Wedel, Stadt',22880,33,32221,15638,16583,953),
	(360,8,3,36,5004,69,'Rheinfelden (Baden), Stadt',79618,62,32211,15755,16456,513),
	(361,3,2,56,22,22,'Nienburg (Weser), Stadt',31582,64,32152,15750,16402,499),
	(362,3,4,59,19,19,'Georgsmarienhütte, Stadt',49124,55,32130,15636,16494,580),
	(363,5,9,74,52,52,'Werl, Stadt',59457,76,31782,15858,15924,416),
	(364,12,0,67,120,120,'Eisenhüttenstadt, Stadt',15890,63,31689,15938,15751,500),
	(365,5,9,54,12,12,'Gevelsberg, Stadt',58285,26,31651,15262,16389,1204),
	(366,5,1,70,32,32,'Rheinberg, Stadt',47495,75,31648,15455,16193,421),
	(367,6,4,40,3,3,'Bad Vilbel, Stadt',61118,25,31634,15291,16343,1233),
	(368,12,0,68,320,320,'Neuruppin, Stadt',16816,303,31574,15630,15944,104),
	(369,9,2,71,119,119,'Deggendorf, GKSt',94469,77,31536,15170,16366,409),
	(370,5,7,62,20,20,'Höxter, Stadt',37671,157,31415,15389,16026,199),
	(371,8,1,15,5003,21,'Herrenberg, Stadt',71083,65,31324,15449,15875,477),
	(372,3,4,60,9,9,'Vechta, Stadt',49377,87,31250,15390,15860,356),
	(373,5,9,58,32,32,'Meschede, Stadt',59872,218,31219,15408,15811,143),
	(374,6,4,31,13,13,'Lampertheim, Stadt',68623,72,31199,15254,15945,432),
	(375,5,3,82,28,28,'Lohmar, Stadt',53797,65,31150,15331,15819,475),
	(376,8,1,18,46,46,'Kornwestheim, Stadt',70806,14,31098,15281,15817,2123),
	(377,6,4,40,2,2,'Bad Nauheim, Stadt',61231,32,31084,14463,16621,955),
	(378,5,9,70,24,24,'Kreuztal, Stadt',57223,70,31081,15385,15696,438),
	(379,3,4,59,14,14,'Bramsche, Stadt',49565,183,31033,17053,13980,169),
	(380,3,4,58,5,5,'Ganderkesee',27777,138,30896,15103,15793,223),
	(381,1,0,62,1,1,'Ahrensburg, Stadt',22926,35,30858,14606,16252,874),
	(382,5,9,54,8,8,'Ennepetal, Stadt',58256,57,30778,14954,15824,536),
	(383,7,1,34,45,45,'Idar-Oberstein, Stadt',55743,91,30759,14969,15790,336),
	(384,8,3,35,63,63,'Radolfzell am Bodensee, Stadt',78315,58,30620,14801,15819,523),
	(385,10,0,42,113,113,'Merzig, Kreisstadt',66663,108,30518,14884,15634,280),
	(386,5,5,62,28,28,'Oer-Erkenschwick, Stadt',45739,38,30499,14868,15631,788),
	(387,9,4,74,126,126,'Forchheim, GKSt',91301,44,30452,14607,15845,685),
	(388,3,2,51,47,47,'Weyhe',28844,60,30376,14932,15444,504),
	(389,3,3,56,7,7,'Osterholz-Scharmbeck, Stadt',27711,146,30275,14787,15488,206),
	(390,15,0,89,5002,30,'Bernburg (Saale), Stadt',6406,55,30201,14721,15480,548),
	(391,13,0,53,31,31,'Güstrow, Stadt',18273,70,30151,14506,15645,426),
	(392,15,0,87,370,370,'Sangerhausen, Stadt',6526,207,30140,14758,15382,145),
	(393,5,7,74,20,20,'Delbrück, Stadt',33129,157,30096,15148,14948,191),
	(394,5,1,66,28,28,'Tönisvorst, Stadt',47918,44,30084,14600,15484,679),
	(395,3,3,61,1,1,'Achim, Stadt',28832,68,30040,14722,15318,442),
	(396,5,9,78,40,40,'Werne, Stadt',59368,76,29994,14529,15465,394),
	(397,6,6,32,2,2,'Bad Hersfeld, Kreisstadt',36251,73,29971,14391,15580,406),
	(398,3,2,41,3,3,'Burgdorf, Stadt',31303,112,29951,14413,15538,267),
	(399,8,3,36,91,91,'Weil am Rhein, Stadt',79576,19,29851,14454,15397,1533),
	(400,5,5,62,36,36,'Waltrop, Stadt',45731,46,29837,14573,15264,635),
	(401,15,0,84,5010,590,'Zeitz, Stadt',6712,74,29765,14134,15631,397),
	(402,3,1,55,11,11,'Northeim, Stadt',37154,145,29657,14387,15270,204),
	(403,5,1,54,8,8,'Emmerich am Rhein, Stadt',46446,80,29652,14586,15066,370),
	(404,7,1,37,3,3,'Andernach, Stadt',56626,53,29589,14468,15121,556),
	(405,8,2,16,5002,7,'Bühl, Stadt',77815,73,29479,14425,15054,403),
	(406,5,5,70,28,28,'Oelde, Stadt',59302,102,29456,14573,14883,287),
	(407,3,2,41,17,17,'Springe, Stadt',31832,159,29356,14289,15067,184),
	(408,15,0,89,5010,310,'Staßfurt, Stadt',39418,146,29277,14291,14986,200),
	(409,1,0,53,32,32,'Geesthacht, Stadt',21502,33,29243,14216,15027,881),
	(410,5,1,58,8,8,'Haan, Stadt',42781,24,29156,13867,15289,1204),
	(411,5,3,70,40,40,'Wegberg, Stadt',41844,84,29130,14473,14657,345),
	(412,3,2,41,19,19,'Wedemark',30900,173,29108,14187,14921,168),
	(413,8,2,16,15,15,'Gaggenau, Stadt',76571,65,29081,14096,14985,447),
	(414,9,7,71,130,130,'Friedberg, St',86316,81,29054,14155,14899,358),
	(415,5,9,54,24,24,'Schwelm, Stadt',58332,20,29012,13894,15118,1415),
	(416,15,0,89,15,15,'Aschersleben, Stadt',6449,147,28930,13939,14991,197),
	(417,6,4,39,15,15,'Taunusstein, Stadt',65232,67,28900,14035,14865,431),
	(418,5,9,58,44,44,'Sundern (Sauerland), Stadt',59846,192,28884,14355,14529,150),
	(419,8,1,18,5008,73,'Vaihingen an der Enz, Stadt',71665,73,28853,14362,14491,393),
	(420,5,7,54,32,32,'Rietberg, Stadt',33397,110,28824,14502,14322,261),
	(421,14,6,26,610,610,'Zittau, Stadt',2763,66,28638,13758,14880,429),
	(422,15,0,84,5008,550,'Weißenfels, Stadt',6667,24,28635,14045,14590,1157),
	(423,15,0,82,180,180,'Köthen (Anhalt), Stadt',6366,78,28576,13729,14847,364),
	(424,8,2,15,5002,7,'Bretten, Stadt',75015,71,28439,14066,14373,400),
	(425,15,0,84,355,355,'Naumburg (Saale), Stadt',6618,76,28259,13593,14666,372),
	(426,5,1,54,32,32,'Kevelaer, Stadt',47623,100,28251,13794,14457,281),
	(427,5,9,54,32,32,'Wetter (Ruhr), Stadt',58300,31,28221,13774,14447,897),
	(428,1,0,58,135,135,'Rendsburg, Stadt',24768,23,28192,13692,14500,1188),
	(429,9,1,85,149,149,'Neuburg a.d.Donau, GKSt',86633,81,28173,14012,14161,347),
	(430,5,3,70,12,12,'Geilenkirchen, Stadt',52511,83,28083,13836,14247,337),
	(431,5,3,34,8,8,'Baesweiler, Stadt',52499,27,28000,13785,14215,1008),
	(432,6,4,40,8,8,'Friedberg (Hessen), Kreisstadt',61169,50,27922,13878,14044,557),
	(433,9,1,81,130,130,'Landsberg am Lech, GKSt',86899,57,27895,14188,13707,482),
	(434,9,3,76,161,161,'Schwandorf, GKSt',92421,123,27804,13719,14085,225),
	(435,5,1,70,12,12,'Hamminkeln, Stadt',46499,164,27774,13683,14091,169),
	(436,14,6,27,140,140,'Meißen, Stadt',1662,30,27693,13264,14429,896),
	(437,6,6,33,3,3,'Baunatal, Stadt',34225,38,27681,13480,14201,723),
	(438,5,1,70,28,28,'Neukirchen-Vluyn, Stadt',47506,43,27627,13307,14320,635),
	(439,6,4,36,8,8,'Kelkheim (Taunus), Stadt',65779,30,27537,13341,14196,898),
	(440,8,1,19,5006,85,'Winnenden, Stadt',71364,28,27504,13559,13945,981),
	(441,5,3,78,16,16,'Leichlingen (Rheinland), Stadt',42799,37,27476,13153,14323,736),
	(442,7,1,31,7,7,'Bad Neuenahr-Ahrweiler, Stadt',53474,63,27464,12728,14736,433),
	(443,3,4,51,2,2,'Bad Zwischenahn',26160,129,27437,13248,14189,211),
	(444,5,9,74,44,44,'Warstein, Stadt',59581,157,27429,13627,13802,174),
	(445,9,7,72,163,163,'Königsbrunn, St',86343,18,27313,13441,13872,1484),
	(446,8,4,36,5007,81,'Wangen im Allgäu, Stadt',88239,101,27282,13193,14089,269),
	(447,5,9,66,20,20,'Lennestadt, Stadt',57368,135,27238,13715,13523,202),
	(448,5,3,66,28,28,'Mechernich, Stadt',53894,136,27230,13584,13646,200),
	(449,8,2,26,41,41,'Leimen, Stadt',69181,20,27145,13249,13896,1315),
	(450,5,9,78,32,32,'Selm, Stadt',59379,60,27123,13396,13727,450),
	(451,5,3,78,28,28,'Rösrath, Stadt',51503,38,27102,13221,13881,698),
	(452,5,3,82,48,48,'Rheinbach, Stadt',53359,69,27098,13496,13602,389),
	(453,3,2,57,31,31,'Rinteln, Stadt',31737,109,27004,13270,13734,248),
	(454,5,3,78,24,24,'Overath, Stadt',51491,68,26999,13234,13765,392),
	(455,3,4,61,7,7,'Nordenham, Stadt',26954,87,26978,13273,13705,309),
	(456,8,1,17,5004,24,'Geislingen an der Steige, Stadt',73312,75,26922,13184,13738,355),
	(457,16,0,73,5050,77,'Saalfeld/Saale, Stadt',7318,44,26912,12990,13922,602),
	(458,1,0,60,39,39,'Henstedt-Ulzburg',24558,39,26847,13335,13512,680),
	(459,3,3,61,12,12,'Verden (Aller), Stadt',27283,71,26846,12853,13993,375),
	(460,9,4,77,128,128,'Kulmbach, GKSt',95326,92,26842,12785,14057,289),
	(461,12,0,66,304,304,'Senftenberg, Stadt',1968,126,26821,13043,13778,211),
	(462,5,1,58,12,12,'Heiligenhaus, Stadt',42579,27,26818,13120,13698,976),
	(463,3,1,55,4,4,'Einbeck, Stadt',37574,165,26724,12989,13735,161),
	(464,8,3,16,5003,11,'Emmendingen, Stadt',79312,33,26697,12943,13754,790),
	(465,5,9,62,52,52,'Plettenberg, Stadt',58840,96,26665,13106,13559,277),
	(466,8,1,25,5008,65,'Neckarsulm, Stadt',74172,24,26641,13233,13408,1068),
	(467,6,4,38,8,8,'Mühlheim am Main, Stadt',63165,20,26588,13007,13581,1286),
	(468,9,1,84,149,149,'Unterschleißheim, St',85716,14,26542,13256,13286,1778),
	(469,14,7,30,70,70,'Delitzsch, Stadt',4509,83,26532,13026,13506,317),
	(470,5,9,58,12,12,'Brilon, Stadt',59929,229,26499,12986,13513,116),
	(471,8,1,19,91,91,'Weinstadt, Stadt',71384,31,26444,12913,13531,834),
	(472,10,0,46,117,117,'St. Wendel, Kreisstadt',66606,113,26342,12861,13481,232),
	(473,12,0,64,472,472,'Strausberg, Stadt',15344,67,26221,12823,13398,387),
	(474,6,4,32,8,8,'Griesheim, Stadt',64347,21,26161,12942,13219,1214),
	(475,6,4,38,12,12,'Rödermark, Stadt',63322,29,26114,12848,13266,871),
	(476,5,7,54,36,36,'Schloß Holte-Stukenbrock, Stadt',33758,67,26109,12840,13269,387),
	(477,9,5,74,138,138,'Lauf a.d.Pegnitz, St',91207,59,26090,12579,13511,436),
	(478,5,7,70,28,28,'Petershagen, Stadt',32469,211,26027,12862,13165,123),
	(479,16,0,70,29,29,'Ilmenau, Stadt',98693,62,25979,13144,12835,415),
	(480,9,1,80,117,117,'Garmisch-Partenkirchen, M',82467,205,25953,11984,13969,126),
	(481,8,2,26,5010,98,'Wiesloch, Stadt',69168,30,25952,12701,13251,858),
	(482,3,4,60,6,6,'Lohne (Oldenburg), Stadt',49393,90,25910,12964,12946,285),
	(483,12,0,65,136,136,'Hennigsdorf, Stadt',16761,31,25900,12544,13356,828),
	(484,5,7,70,20,20,'Lübbecke, Stadt',32312,65,25885,12493,13392,398),
	(485,1,0,62,60,60,'Reinbek, Stadt',21465,31,25874,12619,13255,828),
	(486,9,5,73,134,134,'Zirndorf, St',90513,28,25847,13098,12749,898),
	(487,12,0,72,17,17,'Blankenfelde-Mahlow',15827,54,25818,13081,12737,470),
	(488,8,3,25,5003,49,'Rottweil, Stadt',78628,71,25739,12503,13236,359),
	(489,8,2,37,5003,40,'Horb am Neckar, Stadt',72160,119,25721,12847,12874,215),
	(490,5,3,74,48,48,'Wiehl, Stadt',51674,53,25709,12478,13231,483),
	(491,8,4,25,5005,33,'Ehingen (Donau), Stadt',89584,178,25702,12717,12985,144),
	(492,14,5,24,5114,180,'Limbach-Oberfrohna, Stadt',9212,50,25610,12347,13263,510),
	(493,5,9,58,40,40,'Schmallenberg, Stadt',57392,303,25533,12709,12824,84),
	(494,12,0,63,252,252,'Rathenow, Stadt',14712,112,25515,12386,13129,227),
	(495,8,2,36,5004,40,'Mühlacker, Stadt',75417,54,25512,12655,12857,470),
	(496,5,9,54,28,28,'Sprockhövel, Stadt',45549,47,25511,12359,13152,534),
	(497,5,9,66,24,24,'Olpe, Stadt',57462,85,25496,12509,12987,297),
	(498,6,4,36,5,5,'Hattersheim am Main, Stadt',65795,15,25493,12537,12956,1612),
	(499,6,4,31,11,11,'Heppenheim (Bergstraße), Kreisstadt',64646,52,25276,12286,12990,485),
	(500,5,7,70,8,8,'Espelkamp, Stadt',32339,84,25240,12432,12808,300),
	(501,16,0,70,5050,4,'Arnstadt, Stadt',99310,55,25090,12101,12989,454),
	(502,5,3,82,8,8,'Bad Honnef, Stadt',53604,48,25085,11779,13306,519),
	(503,3,4,52,19,19,'Norden, Stadt',26506,106,25044,11961,13083,236),
	(504,5,7,54,44,44,'Verl',33415,71,24968,12762,12206,350),
	(505,6,4,40,5,5,'Butzbach, Stadt',35510,106,24967,12468,12499,234),
	(506,8,3,17,5001,1,'Achern, Stadt',77855,65,24947,12157,12790,382),
	(507,9,1,79,142,142,'Olching',82140,29,24861,12097,12764,831),
	(508,5,3,70,28,28,'Übach-Palenberg, Stadt',52531,26,24837,12380,12457,951),
	(509,5,7,74,36,36,'Salzkotten, Stadt',33154,109,24813,12164,12649,226),
	(510,5,9,54,20,20,'Herdecke, Stadt',58313,22,24794,11819,12975,1107),
	(511,5,3,62,4,4,'Bedburg, Stadt',50181,80,24782,12343,12439,309),
	(512,5,9,66,4,4,'Attendorn, Stadt',57439,97,24780,12285,12495,253),
	(513,8,1,36,5003,19,'Ellwangen (Jagst), Stadt',73479,127,24749,12230,12519,194),
	(514,12,0,71,372,372,'Spremberg, Stadt',3130,180,24718,12443,12275,137),
	(515,14,5,24,80,80,'Glauchau, Stadt',8371,51,24684,12014,12670,479),
	(516,9,7,76,116,116,'Lindau (Bodensee), GKSt',88131,33,24681,11723,12958,747),
	(517,3,4,55,26,26,'Varel, Stadt',26316,113,24663,11945,12718,217),
	(518,15,0,87,5005,130,'Eisleben, Lutherstadt',6295,119,24586,11937,12649,205),
	(519,8,2,25,5005,58,'Mosbach, Stadt',74821,62,24585,12093,12492,395),
	(520,6,4,32,18,18,'Pfungstadt, Stadt',64319,42,24569,12054,12515,578),
	(521,6,4,34,2,2,'Friedrichsdorf, Stadt',61381,30,24546,12043,12503,814),
	(522,8,1,18,11,11,'Ditzingen, Stadt',71254,30,24535,12145,12390,807),
	(523,3,1,52,16,16,'Hann. Münden, Stadt',34346,121,24505,11887,12618,202),
	(524,9,5,76,143,143,'Roth, St',91154,96,24499,11995,12504,254),
	(525,3,2,51,41,41,'Syke, Stadt',28857,127,24401,11941,12460,191),
	(526,15,0,86,15,15,'Burg, Stadt',39288,164,24362,11989,12373,149),
	(527,5,3,82,32,32,'Meckenheim, Stadt',53340,34,24282,11932,12350,698),
	(528,14,7,29,260,260,'Markkleeberg, Stadt',4416,31,24254,11650,12604,774),
	(529,5,9,70,32,32,'Netphen, Stadt',57250,137,24234,12046,12188,176),
	(530,6,4,32,23,23,'Weiterstadt, Stadt',64331,34,24234,11961,12273,704),
	(531,1,0,62,4,4,'Bad Oldesloe, Stadt',23843,52,24204,11664,12540,460),
	(532,5,5,58,24,24,'Lüdinghausen, Stadt',59348,140,24196,11749,12447,172),
	(533,12,0,65,144,144,'Hohen Neuendorf, Stadt',16540,48,24139,11731,12408,502),
	(534,7,3,39,5,5,'Bingen am Rhein, Stadt',55411,37,24134,11698,12436,640),
	(535,6,4,38,10,10,'Obertshausen, Stadt',63179,13,24131,11822,12309,1772),
	(536,3,1,54,10,10,'Helmstedt, Stadt',38350,46,24108,11675,12433,513),
	(537,5,7,54,16,16,'Harsewinkel, Stadt',33428,100,24101,12003,12098,240),
	(538,9,1,86,143,143,'Pfaffenhofen a.d.Ilm, St',85276,92,24089,11811,12278,260),
	(539,1,0,59,75,75,'Schleswig, Stadt',24837,24,24061,11458,12603,990),
	(540,7,3,39,30,30,'Ingelheim am Rhein, Stadt',55218,49,24050,11727,12323,482),
	(541,16,0,73,76,76,'Rudolstadt, Stadt',7407,55,24033,11649,12384,434),
	(542,3,3,58,22,22,'Walsrode, Stadt',29664,270,24012,11775,12237,89),
	(543,12,0,72,240,240,'Ludwigsfelde, Stadt',14974,109,23992,11916,12076,219),
	(544,9,1,83,148,148,'Waldkraiburg, St',84478,21,23931,11771,12160,1110),
	(545,6,6,35,15,15,'Korbach, Kreisstadt',34497,123,23900,11454,12446,193),
	(546,3,4,59,33,33,'Wallenhorst',49134,47,23788,11719,12069,504),
	(547,8,1,28,131,131,'Wertheim, Stadt',97877,138,23750,11639,12111,171),
	(548,8,4,36,5005,82,'Weingarten, Stadt',88250,12,23750,11662,12088,1952),
	(549,8,2,37,5002,28,'Freudenstadt, Stadt',72250,87,23697,11262,12435,271),
	(550,3,1,56,11,11,'Osterode am Harz, Stadt',37520,102,23675,11490,12185,231),
	(551,6,5,32,6,6,'Dillenburg, Stadt',35683,83,23637,11574,12063,282),
	(552,5,7,62,36,36,'Warburg, Stadt',34414,168,23611,11685,11926,140),
	(553,8,2,15,109,109,'Stutensee, Stadt',76297,45,23580,11704,11876,516),
	(554,16,0,65,67,67,'Sondershausen, Stadt',99706,200,23483,11494,11989,117),
	(555,5,3,74,52,52,'Wipperfürth, Stadt',51688,118,23317,11536,11781,197),
	(556,9,1,73,126,126,'Geretsried, St',82538,24,23300,11424,11876,948),
	(557,8,1,18,81,81,'Remseck am Neckar, Stadt',71686,22,23282,11531,11751,1020),
	(558,8,2,35,5006,85,'Calw, Stadt',75365,59,23275,11648,11627,389),
	(559,6,4,33,6,6,'Groß-Gerau, Stadt',64521,54,23239,11317,11922,427),
	(560,16,0,71,1,1,'Apolda, Stadt',99510,46,23179,11187,11992,502),
	(561,3,2,41,14,14,'Ronnenberg, Stadt',30952,37,23109,11305,11804,612),
	(562,6,4,39,8,8,'Idstein, Stadt',65510,79,23076,11258,11818,290),
	(563,9,1,88,139,139,'Starnberg, St',82319,61,23057,10830,12227,373),
	(564,12,0,69,656,656,'Werder (Havel), Stadt',14542,116,23004,11319,11685,198),
	(565,3,4,54,18,18,'Haren (Ems), Stadt',49733,208,22996,11627,11369,110),
	(566,5,3,82,4,4,'Alfter',53347,34,22895,11162,11733,658),
	(567,3,2,41,8,8,'Isernhagen',30916,59,22882,11093,11789,383),
	(568,14,5,24,300,300,'Werdau, Stadt',8412,65,22877,11081,11796,349),
	(569,8,3,37,5007,126,'Waldshut-Tiengen, Stadt',79761,77,22876,11070,11806,293),
	(570,9,5,72,132,132,'Herzogenaurach, St',91074,47,22875,11454,11421,480),
	(571,3,2,41,16,16,'Sehnde, Stadt',31319,103,22862,11493,11369,221),
	(572,5,3,74,36,36,'Radevormwald, Stadt',42477,53,22843,10949,11894,425),
	(573,1,0,58,43,43,'Eckernförde, Stadt',24340,18,22755,11181,11574,1237),
	(574,8,1,26,5005,66,'Öhringen, Stadt',74613,67,22745,11221,11524,336),
	(575,5,1,62,12,12,'Jüchen',41363,71,22685,11211,11474,316),
	(576,5,5,54,68,68,'Vreden, Stadt',48691,135,22641,11566,11075,167),
	(577,8,2,35,5007,46,'Nagold, Stadt',72202,63,22605,11070,11535,358),
	(578,16,0,72,18,18,'Sonneberg, Stadt',96515,45,22529,10962,11567,496),
	(579,8,1,28,5001,7,'Bad Mergentheim, Stadt',97980,129,22511,10595,11916,173),
	(580,3,4,57,14,14,'Moormerland',26802,122,22456,11039,11417,184),
	(581,5,1,54,44,44,'Rees, Stadt',46459,109,22432,11214,11218,205),
	(582,9,7,75,152,152,'Senden, St',89250,25,22376,10999,11377,887),
	(583,3,2,57,35,35,'Stadthagen, Stadt',31655,60,22344,10547,11797,371),
	(584,5,5,66,40,40,'Lengerich, Stadt',49525,90,22315,10954,11361,246),
	(585,9,1,84,148,148,'Unterhaching',82008,10,22258,10583,11675,2146),
	(586,1,0,54,56,56,'Husum, Stadt',25813,25,22216,10557,11659,861),
	(587,5,3,74,20,20,'Lindlar',51789,85,22203,10978,11225,258),
	(588,16,0,76,5052,22,'Greiz, Stadt',7973,53,22150,10587,11563,411),
	(589,5,9,78,12,12,'Fröndenberg/Ruhr, Stadt',58730,56,22135,10876,11259,394),
	(590,10,0,45,112,112,'Blieskastel, Stadt',66440,108,22098,10913,11185,204),
	(591,14,5,21,20,20,'Annaberg-Buchholz, Stadt',9456,27,22079,10555,11524,797),
	(592,3,1,53,2,2,'Bad Harzburg, Stadt',38667,65,22037,10157,11880,337),
	(593,8,4,36,5004,55,'Leutkirch im Allgäu, Stadt',88299,174,21988,10953,11035,126),
	(594,8,4,15,5002,50,'Metzingen, Stadt',72555,34,21945,10500,11445,635),
	(595,3,4,51,7,7,'Westerstede, Stadt',26655,179,21943,10765,11178,122),
	(596,12,0,69,616,616,'Teltow, Stadt',14513,21,21904,10624,11280,1017),
	(597,9,1,75,132,132,'Vaterstetten',85591,34,21856,10732,11124,641),
	(598,8,2,26,84,84,'Schwetzingen, Stadt',68723,21,21834,10557,11277,1009),
	(599,3,1,52,7,7,'Duderstadt, Stadt',37115,95,21833,10742,11091,228),
	(600,3,3,57,39,39,'Rotenburg (Wümme), Stadt',27356,99,21830,10709,11121,221),
	(601,3,3,58,21,21,'Soltau, Stadt',29614,203,21777,10661,11116,107),
	(602,6,4,40,12,12,'Karben, Stadt',61184,43,21756,10911,10845,495),
	(603,8,4,35,5007,59,'Überlingen, Stadt',88662,58,21699,9977,11722,370),
	(604,6,4,36,1,1,'Bad Soden am Taunus, Stadt',65812,12,21657,10325,11332,1726),
	(605,9,1,90,157,157,'Weilheim i.OB, St',82362,55,21652,10442,11210,390),
	(606,14,6,27,10,10,'Coswig, Stadt',1640,25,21600,10432,11168,836),
	(607,13,0,55,50,50,'Neustrelitz, Stadt',17235,138,21537,10450,11087,156),
	(608,5,1,70,52,52,'Xanten, Stadt',46509,72,21536,10468,11068,297),
	(609,9,7,72,184,184,'Neusäß, St',86356,25,21534,10436,11098,854),
	(610,5,7,74,16,16,'Büren, Stadt',33142,170,21531,10821,10710,126),
	(611,12,0,60,269,269,'Wandlitz',16348,162,21530,10836,10694,132),
	(612,6,4,35,10,10,'Gelnhausen, Barbarossast., Krst.',63571,45,21496,10382,11114,476),
	(613,5,1,58,36,36,'Wülfrath, Stadt',42489,32,21420,10367,11053,664),
	(614,6,4,33,11,11,'Riedstadt, Stadt',64560,73,21413,10586,10827,290),
	(615,8,3,25,5005,53,'Schramberg, Stadt',78713,80,21402,10500,10902,265),
	(616,6,4,32,10,10,'Groß-Umstadt, Stadt',64823,86,21373,10687,10686,246),
	(617,8,1,25,5004,26,'Eppingen, Stadt',75031,88,21362,10532,10830,241),
	(618,6,4,40,4,4,'Büdingen, Stadt',63654,122,21309,10516,10793,173),
	(619,15,0,85,235,235,'Quedlinburg, Stadt',6484,78,21203,10093,11110,271),
	(620,3,4,51,4,4,'Edewecht',26188,113,21193,10457,10736,187),
	(621,5,3,62,16,16,'Elsdorf',50189,66,21172,10520,10652,320),
	(622,13,0,56,72,72,'Waren (Müritz), Stadt',17192,158,21164,10099,11065,134),
	(623,14,5,24,5104,30,'Crimmitschau, Stadt',8451,61,21164,10234,10930,347),
	(624,6,5,34,18,18,'Stadtallendorf, Stadt',35260,78,21146,10523,10623,270),
	(625,8,3,26,5001,12,'Donaueschingen, Stadt',78166,104,21128,10409,10719,202),
	(626,8,2,26,5004,32,'Hockenheim, Stadt',68766,34,21108,10375,10733,606),
	(627,5,9,58,24,24,'Marsberg, Stadt',34431,182,21076,10627,10449,116),
	(628,5,7,54,12,12,'Halle (Westf.), Stadt',33790,69,21058,10193,10865,304),
	(629,5,9,62,36,36,'Meinerzhagen, Stadt',58540,115,21049,10428,10621,183),
	(630,5,7,54,48,48,'Versmold, Stadt',33775,85,21032,10395,10637,246),
	(631,5,9,70,44,44,'Wilnsdorf',57234,72,20991,10337,10654,291),
	(632,12,0,71,76,76,'Forst (Lausitz), Stadt',3149,109,20971,10355,10616,191),
	(633,10,0,44,111,111,'Dillingen/ Saar, Stadt',66763,22,20954,10186,10768,949),
	(634,14,7,29,50,50,'Borna, Stadt',4552,62,20920,10169,10751,335),
	(635,9,7,71,113,113,'Aichach, St',86551,92,20885,10175,10710,225),
	(636,3,4,62,19,19,'Wittmund, Stadt',26409,210,20884,10285,10599,99),
	(637,9,7,80,139,139,'Sonthofen, St',87527,46,20881,9892,10989,448),
	(638,3,2,52,3,3,'Bad Pyrmont, Stadt',31812,61,20861,9562,11299,337),
	(639,9,6,75,141,141,'Kitzingen, GKSt',97318,47,20845,9909,10936,444),
	(640,9,1,89,154,154,'Traunreut, St',83301,45,20821,10111,10710,462),
	(641,6,5,32,12,12,'Herborn, Stadt',35745,63,20813,10113,10700,326),
	(642,3,4,55,15,15,'Schortens, Stadt',26419,68,20801,10236,10565,303),
	(643,9,6,72,114,114,'Bad Kissingen, GKSt',97688,69,20791,9358,11433,297),
	(644,6,4,36,3,3,'Eschborn, Stadt',65760,12,20789,10129,10660,1714),
	(645,3,4,51,5,5,'Rastede',26180,123,20763,10102,10661,169),
	(646,1,0,51,44,44,'Heide, Stadt',25746,31,20747,9897,10850,649),
	(647,8,3,16,5006,56,'Waldkirch, Stadt',79183,48,20742,9986,10756,428),
	(648,16,0,66,5050,42,'Meiningen, Stadt',98617,41,20731,10064,10667,501),
	(649,5,5,54,56,56,'Stadtlohn, Stadt',48703,79,20718,10347,10371,262),
	(650,5,9,74,20,20,'Geseke, Stadt',59590,97,20713,10277,10436,213),
	(651,7,3,34,7,7,'Germersheim, Stadt',76726,21,20706,10003,10703,954),
	(652,5,5,58,44,44,'Senden',48308,109,20704,10172,10532,189),
	(653,3,3,53,26,26,'Neu Wulmstorf',21629,56,20697,10247,10450,368),
	(654,5,3,82,40,40,'Neunkirchen-Seelscheid',53819,50,20672,10278,10394,408),
	(655,9,4,78,139,139,'Lichtenfels, St',96215,122,20655,10088,10567,169),
	(656,12,0,72,232,232,'Luckenwalde, Stadt',14943,46,20637,9938,10699,444),
	(657,6,4,35,6,6,'Bruchköbel, Stadt',63486,29,20627,10063,10564,695),
	(658,8,1,25,5002,6,'Bad Rappenau, Stadt',74906,73,20594,10015,10579,280),
	(659,8,2,15,106,106,'Waghäusel, Stadt',68753,42,20588,10166,10422,481),
	(660,8,2,15,108,108,'Rheinstetten, Stadt',76287,32,20573,9940,10633,637),
	(661,3,4,53,7,7,'Friesoythe, Stadt',26169,247,20572,10296,10276,83),
	(662,5,3,82,76,76,'Windeck',51570,107,20565,10099,10466,192),
	(663,9,7,72,147,147,'Gersthofen, St',86368,33,20564,9996,10568,606),
	(664,1,0,56,41,41,'Quickborn, Stadt',25451,43,20556,10020,10536,476),
	(665,3,2,57,9,9,'Bückeburg, Stadt',31675,68,20534,9869,10665,298),
	(666,3,1,53,12,12,'Seesen, Stadt',38723,102,20530,9915,10615,201),
	(667,14,5,23,5125,340,'Reichenbach im Vogtland, Stadt',8468,29,20449,9678,10771,688),
	(668,7,3,32,25,25,'Haßloch',67454,39,20441,10153,10288,512),
	(669,3,2,41,4,4,'Burgwedel, Stadt',30938,151,20432,9727,10705,134),
	(670,3,2,54,2,2,'Alfeld (Leine), Stadt',31061,72,20340,9815,10525,279),
	(671,14,5,22,5105,80,'Döbeln, Stadt',4720,32,20337,9792,10545,622),
	(672,5,3,82,72,72,'Wachtberg',53343,49,20253,9820,10433,408),
	(673,3,2,41,18,18,'Uetze',31311,140,20247,10020,10227,144),
	(674,6,4,38,13,13,'Seligenstadt, Stadt',63500,30,20234,9823,10411,656),
	(675,16,0,66,63,63,'Schmalkalden, Kurort, Stadt',98574,98,20231,10141,10090,206),
	(676,6,4,36,4,4,'Flörsheim am Main, Stadt',65439,22,20220,9808,10412,881),
	(677,14,5,23,20,20,'Auerbach/Vogtl., Stadt',8209,55,20220,9653,10567,365),
	(678,3,2,55,23,23,'Holzminden, Stadt',37603,88,20210,9823,10387,229),
	(679,8,1,17,5003,19,'Eislingen/ Fils, Stadt',73054,16,20208,9902,10306,1231),
	(680,12,0,73,452,452,'Prenzlau, Stadt',17291,142,20173,9932,10241,142),
	(681,5,5,58,32,32,'Nottuln',48301,85,20118,9942,10176,235),
	(682,5,7,58,8,8,'Enger, Stadt',32130,41,20090,9920,10170,488),
	(683,5,3,74,8,8,'Engelskirchen',51766,63,20046,9805,10241,318),
	(684,8,4,16,5002,25,'Mössingen, Stadt',72116,50,20043,9836,10207,400),
	(685,5,3,66,44,44,'Zülpich, Stadt',53909,101,20027,9792,10235,198),
	(686,10,0,41,515,515,'Püttlingen, Stadt',66346,23,20021,9609,10412,836),
	(687,6,6,36,3,3,'Eschwege, Kreisstadt',37269,63,20018,9539,10479,316),
	(688,16,0,68,51,51,'Sömmerda, Stadt',99610,80,20005,9807,10198,248),
	(689,5,9,70,4,4,'Bad Berleburg, Stadt',57319,275,19993,9877,10116,73),
	(690,5,7,58,16,16,'Hiddenhausen',32120,23,19986,9667,10319,838),
	(691,8,3,17,5009,89,'Oberkirch, Stadt',77704,69,19986,9901,10085,289),
	(692,3,3,56,9,9,'Schwanewede',28790,132,19971,9932,10039,151),
	(693,5,9,66,28,28,'Wenden',57482,72,19952,9937,10015,275),
	(694,5,5,70,20,20,'Ennigerloh, Stadt',59320,125,19949,9975,9974,159),
	(695,3,4,57,22,22,'Westoverledingen',26810,112,19915,9862,10053,178),
	(696,9,1,84,136,136,'Ottobrunn',85521,5,19909,9591,10318,3807),
	(697,14,7,30,5311,310,'Torgau, Stadt',4860,90,19894,9837,10057,220),
	(698,5,5,66,16,16,'Hörstel, Stadt',48477,107,19893,9938,9955,185),
	(699,8,4,36,5002,9,'Bad Waldsee, Stadt',88339,108,19867,9539,10328,183),
	(700,1,0,60,44,44,'Kaltenkirchen, Stadt',24568,23,19865,9734,10131,860),
	(701,5,7,54,40,40,'Steinhagen',33803,56,19859,9585,10274,353),
	(702,10,0,44,112,112,'Lebach, Stadt',66822,64,19801,10329,9472,309),
	(703,6,4,35,21,21,'Nidderau, Stadt',61130,46,19800,9782,10018,424),
	(704,9,1,88,120,120,'Gauting',82131,50,19792,9480,10312,393),
	(705,9,3,71,151,151,'Sulzbach-Rosenberg, St',92237,53,19781,9558,10223,372),
	(706,5,3,74,4,4,'Bergneustadt, Stadt',51702,37,19771,9781,9990,522),
	(707,5,3,78,12,12,'Kürten',51515,67,19767,9821,9946,293),
	(708,16,0,61,115,115,'Leinefelde-Worbis, Stadt',37327,96,19761,9899,9862,205),
	(709,8,4,26,5005,70,'Laupheim, Stadt',88471,61,19725,9832,9893,319),
	(710,5,3,74,40,40,'Reichshof',51580,114,19708,9853,9855,172),
	(711,1,0,55,4,4,'Bad Schwartau, Stadt',23611,18,19683,9212,10471,1070),
	(712,12,0,71,160,160,'Guben, Stadt',3172,43,19661,9442,10219,449),
	(713,15,0,81,455,455,'Salzwedel, Hansestadt',29410,116,19645,9625,10020,168),
	(714,10,0,41,513,513,'Heusweiler',66265,39,19619,9488,10131,491),
	(715,14,6,26,5242,600,'Weißwasser/O.L., Stadt',2943,63,19615,9708,9907,310),
	(716,12,0,69,304,304,'Kleinmachnow',14532,11,19589,9517,10072,1641),
	(717,9,7,74,135,135,'Günzburg, GKSt',89312,55,19556,9458,10098,353),
	(718,9,1,79,145,145,'Puchheim',82178,12,19549,9417,10132,1598),
	(719,5,7,58,36,36,'Vlotho, Stadt',32602,76,19500,9451,10049,253),
	(720,5,3,82,16,16,'Eitorf',53783,69,19488,9654,9834,279),
	(721,8,1,35,5001,16,'Giengen an der Brenz, Stadt',89537,44,19488,9679,9809,442),
	(722,5,5,66,68,68,'Ochtrup, Stadt',48607,105,19437,9746,9691,184),
	(723,7,3,38,25,25,'Schifferstadt, Stadt',67105,28,19437,9598,9839,693),
	(724,5,3,74,44,44,'Waldbröl, Stadt',51545,63,19432,9397,10035,307),
	(725,5,5,54,48,48,'Rhede, Stadt',46414,78,19424,9740,9684,247),
	(726,9,1,79,126,126,'Gröbenzell',82194,6,19379,9472,9907,3047),
	(727,6,5,32,11,11,'Haiger, Stadt',35708,106,19350,9578,9772,181),
	(728,5,5,70,44,44,'Telgte, Stadt',48291,90,19204,9353,9851,212),
	(729,9,1,84,123,123,'Haar',85540,12,19202,9127,10075,1489),
	(730,12,0,60,181,181,'Panketal',16341,25,19179,9500,9679,743),
	(731,15,0,83,5007,415,'Oschersleben (Bode), Stadt',39387,158,19173,9347,9826,121),
	(732,8,4,17,5004,31,'Hechingen, Stadt',72379,66,19168,9395,9773,289),
	(733,5,1,66,24,24,'Schwalmtal',41366,48,19129,9335,9794,398),
	(734,3,2,52,7,7,'Hessisch Oldendorf, Stadt',31840,120,19112,9414,9698,159),
	(735,5,7,62,4,4,'Bad Driburg, Stadt',33014,115,19100,9217,9883,166),
	(736,3,4,52,23,23,'Südbrookmerland',26624,96,19062,9458,9604,197),
	(737,3,4,58,14,14,'Wildeshausen, Stadt',27793,89,19042,9340,9702,213),
	(738,15,0,83,270,270,'Haldensleben, Stadt',39340,137,19018,9312,9706,138),
	(739,5,9,62,60,60,'Werdohl, Stadt',58791,33,19005,9324,9681,570),
	(740,9,7,79,194,194,'Nördlingen, GKSt',86720,68,18990,9177,9813,279),
	(741,9,1,78,145,145,'Neufahrn b.Freising',85375,45,18973,9726,9247,417),
	(742,8,1,18,19,19,'Gerlingen, Stadt',70839,17,18952,9332,9620,1114),
	(743,8,1,15,50,50,'Weil der Stadt, Stadt',71263,43,18942,9356,9586,439),
	(744,8,3,36,5007,81,'Schopfheim, Stadt',79650,67,18910,9159,9751,278),
	(745,14,7,29,160,160,'Grimma, Stadt',4668,76,18905,9166,9739,248),
	(746,3,3,58,19,19,'Schneverdingen, Stadt',29640,234,18897,9358,9539,81),
	(747,6,6,35,11,11,'Frankenberg (Eder), Stadt',35066,124,18894,9224,9670,151),
	(748,7,3,32,2,2,'Bad Dürkheim, Stadt',67098,102,18848,9003,9845,184),
	(749,8,1,25,5001,5,'Bad Friedrichshall, Stadt',74177,24,18837,9403,9434,763),
	(750,3,3,57,8,8,'Bremervörde, Stadt',27432,150,18815,9346,9469,125),
	(751,9,1,89,155,155,'Traunstein, GKSt',83278,48,18780,8831,9949,387),
	(752,9,6,71,111,111,'Alzenau, St',63755,59,18777,9411,9366,317),
	(753,5,3,78,8,8,'Burscheid, Stadt',51399,27,18771,9349,9422,686),
	(754,5,9,62,4,4,'Altena, Stadt',58762,44,18768,9064,9704,424),
	(755,7,1,37,68,68,'Mayen, Stadt',56727,58,18748,9152,9596,323),
	(756,5,3,66,4,4,'Bad Münstereifel, Stadt',53902,150,18737,9266,9471,124),
	(757,12,0,70,424,424,'Wittenberge, Stadt',19322,50,18710,9002,9708,371),
	(758,14,5,21,550,550,'Schwarzenberg/Erzgeb., Stadt',8340,46,18687,8979,9708,403),
	(759,13,0,60,56,56,'Parchim, Stadt',19370,106,18670,9116,9554,175),
	(760,5,9,78,8,8,'Bönen',59199,38,18630,9020,9610,490),
	(761,6,6,34,22,22,'Schwalmstadt, Stadt',34613,84,18630,9247,9383,220),
	(762,3,2,41,7,7,'Hemmingen, Stadt',30966,31,18606,8916,9690,589),
	(763,8,4,35,5006,57,'Tettnang, Stadt',88069,71,18571,9330,9241,261),
	(764,8,4,15,59,59,'Pfullingen, Stadt',72793,30,18564,8981,9583,616),
	(765,8,1,18,80,80,'Korntal-Münchingen, Stadt',70825,20,18561,9060,9501,896),
	(766,3,2,54,28,28,'Sarstedt, Stadt',31157,42,18551,9128,9423,432),
	(767,3,3,52,30,30,'Langen, Stadt',27607,121,18502,9042,9460,152),
	(768,1,0,53,90,90,'Mölln, Stadt',23879,25,18492,8802,9690,738),
	(769,1,0,56,44,44,'Schenefeld, Stadt',22869,9,18408,9003,9405,1843),
	(770,5,9,70,16,16,'Freudenberg, Stadt',57258,54,18392,8936,9456,338),
	(771,10,0,44,120,120,'Wadgassen',66787,25,18340,8939,9401,707),
	(772,14,6,25,480,480,'Radeberg, Stadt',1454,29,18338,8940,9398,617),
	(773,8,2,25,14,14,'Buchen (Odenwald), Stadt',74722,138,18337,9084,9253,132),
	(774,8,3,15,5012,74,'Müllheim, Stadt',79379,57,18321,8775,9546,316),
	(775,3,3,56,5,5,'Lilienthal',28865,72,18297,8902,9395,254),
	(776,9,7,73,125,125,'Dillingen a.d.Donau, GKSt',89407,75,18254,8965,9289,242),
	(777,10,0,45,111,111,'Bexbach, Stadt',66450,31,18248,8864,9384,587),
	(778,6,6,33,26,26,'Vellmar, Stadt',34246,13,18230,8660,9570,1305),
	(779,9,1,74,126,126,'Karlsfeld',85757,15,18223,9045,9178,1168),
	(780,6,4,38,5,5,'Heusenstamm, Stadt',63150,19,18219,8974,9245,957),
	(781,5,3,82,64,64,'Swisttal',53913,62,18199,9044,9155,292),
	(782,9,7,77,151,151,'Marktoberdorf, St',87616,95,18188,8935,9253,191),
	(783,9,1,71,112,112,'Burghausen, St',84489,19,18178,8860,9318,919),
	(784,9,7,79,131,131,'Donauwörth, GKSt',86609,77,18166,8886,9280,236),
	(785,16,0,64,3,3,'Bad Langensalza, Stadt',99947,123,18150,8843,9307,147),
	(786,9,1,87,117,117,'Bad Aibling, St',83043,41,18125,8642,9483,438),
	(787,6,5,31,14,14,'Pohlheim, Stadt',35415,38,18100,8840,9260,476),
	(788,9,2,79,112,112,'Dingolfing, St',84130,44,18094,9051,9043,411),
	(789,7,1,41,75,75,'Lahnstein, Stadt',56112,37,17980,8708,9272,479),
	(790,7,2,35,5003,68,'Konz, Stadt',54329,44,17893,8768,9125,402),
	(791,8,2,15,101,101,'Pfinztal',76327,31,17868,8714,9154,575),
	(792,9,1,73,147,147,'Wolfratshausen, St',82515,9,17850,8606,9244,1955),
	(793,5,3,58,28,28,'Kreuzau',52372,41,17834,8655,9179,427),
	(794,5,7,66,32,32,'Horn-Bad Meinberg, Stadt',32805,90,17795,8702,9093,197),
	(795,9,1,83,128,128,'Mühldorf a.Inn, St',84453,29,17792,8607,9185,605),
	(796,9,1,87,150,150,'Kolbermoor, St',83059,19,17792,8702,9090,897),
	(797,7,2,31,134,134,'Wittlich, Stadt',54516,49,17786,8690,9096,358),
	(798,10,0,44,118,118,'Schwalbach',66773,27,17786,8536,9250,652),
	(799,7,3,31,3,3,'Alzey, Stadt',55232,35,17732,8623,9109,504),
	(800,5,9,66,12,12,'Finnentrop',57413,104,17706,8966,8740,170),
	(801,9,1,84,145,145,'Taufkirchen',82024,22,17693,8528,9165,804),
	(802,14,7,30,270,270,'Schkeuditz, Stadt',4435,80,17692,8872,8820,219),
	(803,6,4,40,16,16,'Nidda, Stadt',63667,118,17684,8719,8965,149),
	(804,3,2,52,2,2,'Bad Münder am Deister, Stadt',31848,107,17668,8615,9053,164),
	(805,9,1,73,112,112,'Bad Tölz, St',83646,30,17635,8273,9362,573),
	(806,1,0,56,49,49,'Uetersen, Stadt',25436,11,17630,8586,9044,1542),
	(807,12,0,72,477,477,'Zossen, Stadt',15806,179,17590,8783,8807,98),
	(808,6,4,34,6,6,'Kronberg im Taunus, Stadt',61476,18,17562,8099,9463,943),
	(809,8,4,37,5005,100,'Bad Saulgau, Stadt',88348,97,17535,8347,9188,180),
	(810,14,5,21,30,30,'Aue, Stadt',8280,20,17533,8291,9242,837),
	(811,10,0,43,112,112,'Illingen',66557,36,17529,8710,8819,486),
	(812,9,5,77,177,177,'Weißenburg i.Bay., GKSt',91781,97,17519,8416,9103,180),
	(813,8,1,18,76,76,'Sachsenheim, Stadt',74343,57,17517,8742,8775,302),
	(814,12,0,62,140,140,'Finsterwalde, Stadt',3238,76,17517,8429,9088,228),
	(815,6,4,39,3,3,'Eltville am Rhein, Stadt',65343,46,17508,8500,9008,374),
	(816,7,1,31,77,77,'Sinzig, Stadt',53489,41,17490,8528,8962,426),
	(817,10,0,41,518,518,'Sulzbach/ Saar, Stadt',66280,16,17489,8535,8954,1085),
	(818,9,1,78,143,143,'Moosburg a.d.Isar, St',85368,43,17487,8651,8836,399),
	(819,9,4,76,145,145,'Kronach, St',96317,66,17437,8458,8979,260),
	(820,6,6,35,3,3,'Bad Wildungen, Stadt',34537,120,17420,8160,9260,145),
	(821,9,1,72,114,114,'Bad Reichenhall, GKSt',83435,39,17402,7943,9459,441),
	(822,9,4,79,136,136,'Marktredwitz, GKSt',95615,49,17385,8155,9230,351),
	(823,5,9,62,28,28,'Kierspe, Stadt',58566,71,17376,8603,8773,243),
	(824,10,0,43,111,111,'Eppelborn',66571,47,17360,8485,8875,369),
	(825,9,1,88,121,121,'Gilching',82205,31,17331,8478,8853,550),
	(826,5,3,74,32,32,'Nümbrecht',51588,71,17325,8366,8959,241),
	(827,7,3,34,501,501,'Wörth am Rhein, Stadt',76744,131,17293,8404,8889,131),
	(828,12,0,66,176,176,'Lauchhammer, Stadt',1979,88,17276,8538,8738,195),
	(829,3,4,57,18,18,'Rhauderfehn',26817,102,17274,8461,8813,168),
	(830,5,9,78,16,16,'Holzwickede',59439,22,17264,8395,8869,772),
	(831,8,1,15,41,41,'Renningen, Stadt',71272,31,17259,8463,8796,554),
	(832,1,0,55,12,12,'Eutin, Stadt',23701,41,17184,8184,9000,415),
	(833,5,3,70,36,36,'Wassenberg, Stadt',41849,42,17183,8527,8656,405),
	(834,14,6,25,5216,250,'Kamenz, Stadt',1917,53,17171,8749,8422,323),
	(835,5,5,54,16,16,'Gescher, Stadt',48712,80,17144,8589,8555,212),
	(836,7,1,37,203,203,'Bendorf, Stadt',56170,24,17130,8423,8707,712),
	(837,6,4,32,19,19,'Reinheim, Stadt',64354,27,17089,8441,8648,617),
	(838,5,7,62,16,16,'Brakel, Stadt',33034,173,17067,8456,8611,98),
	(839,9,5,73,122,122,'Oberasbach, St',90522,12,17026,8204,8822,1408),
	(840,9,3,72,116,116,'Cham, St',93413,80,17013,8307,8706,211),
	(841,14,7,29,410,410,'Wurzen, Stadt',4808,68,16959,8156,8803,247),
	(842,12,0,66,196,196,'Lübbenau/Spreewald, Stadt',3222,138,16936,8297,8639,122),
	(843,5,9,62,12,12,'Halver, Stadt',58553,77,16934,8345,8589,219),
	(844,6,4,36,6,6,'Hochheim am Main, Stadt',65239,19,16874,8109,8765,868),
	(845,14,6,27,60,60,'Großenhain, Stadt',1558,77,16870,8273,8597,218),
	(846,1,0,55,40,40,'Stockelsdorf',23617,56,16832,8248,8584,297),
	(847,6,4,35,25,25,'Schlüchtern, Stadt',36381,113,16827,8343,8484,149),
	(848,10,0,44,117,117,'Schmelz',66839,58,16810,8216,8594,287),
	(849,8,3,37,5005,96,'Bad Säckingen, Stadt',79713,25,16808,8014,8794,663),
	(850,14,7,30,110,110,'Eilenburg, Stadt',4838,46,16777,8194,8583,358),
	(851,5,7,66,56,56,'Oerlinghausen, Stadt',33813,32,16771,8103,8668,513),
	(852,16,0,61,45,45,'Heilbad Heiligenstadt, Stadt',37308,61,16765,8239,8526,272),
	(853,12,0,64,336,336,'Neuenhagen bei Berlin',15366,19,16755,8299,8456,854),
	(854,6,5,35,1,1,'Alsfeld, Stadt',36304,129,16742,8215,8527,129),
	(855,8,3,15,5001,6,'Bad Krozingen, Stadt',79189,35,16728,7838,8890,469),
	(856,15,0,85,5010,330,'Thale, Stadt',6502,102,16728,8236,8492,163),
	(857,12,0,64,227,227,'Hoppegarten',15366,31,16684,8283,8401,523),
	(858,1,0,55,32,32,'Neustadt in Holstein, Stadt',23730,19,16647,8548,8099,843),
	(859,14,6,26,5220,290,'Löbau, Stadt',2708,78,16639,7952,8687,211),
	(860,8,3,35,5006,79,'Stockach, Stadt',78333,69,16618,8084,8534,238),
	(861,6,4,37,11,11,'Michelstadt, Stadt',64720,86,16614,8195,8419,191),
	(862,10,0,43,116,116,'Schiffweiler',66578,21,16578,8082,8496,778),
	(863,10,0,42,116,116,'Wadern, Stadt',66687,110,16558,8099,8459,149),
	(864,1,0,56,18,18,'Halstenbek',25469,12,16552,8098,8454,1316),
	(865,3,2,51,12,12,'Diepholz, Stadt',49356,104,16541,8152,8389,158),
	(866,12,0,63,208,208,'Nauen, Stadt',14641,266,16523,8164,8359,62),
	(867,10,0,42,112,112,'Losheim am See',66679,96,16510,8257,8253,171),
	(868,12,0,73,572,572,'Templin, Stadt',17268,377,16504,8096,8408,44),
	(869,9,7,75,129,129,'Illertissen, St',89257,36,16489,8103,8386,453),
	(870,9,7,72,125,125,'Bobingen, St',86399,50,16451,8039,8412,327),
	(871,3,3,58,16,16,'Munster, Stadt',29633,193,16428,8810,7618,85),
	(872,3,4,60,2,2,'Damme, Stadt',49401,112,16424,8139,8285,146),
	(873,8,4,37,5006,104,'Sigmaringen, Stadt',72488,92,16380,8297,8083,176),
	(874,14,6,28,160,160,'Heidenau, Stadt',1809,11,16379,8055,8324,1480),
	(875,9,6,71,122,122,'Großostheim, M',63762,44,16363,8173,8190,369),
	(876,16,0,76,5054,87,'Zeulenroda-Triebes, Stadt',7937,68,16344,8011,8333,240),
	(877,6,6,31,17,17,'Künzell',36093,30,16343,7860,8483,540),
	(878,5,3,66,40,40,'Weilerswist',53919,57,16309,8123,8186,285),
	(879,14,5,24,5118,190,'Meerane, Stadt',8393,19,16287,7791,8496,824),
	(880,9,2,75,154,154,'Vilshofen an der Donau, St',94474,86,16286,7942,8344,189),
	(881,6,6,35,2,2,'Bad Arolsen, Stadt',34454,126,16271,7956,8315,129),
	(882,5,7,66,16,16,'Blomberg, Stadt',32825,99,16269,8049,8220,164),
	(883,1,0,62,18,18,'Glinde, Stadt',21509,11,16263,7894,8369,1449),
	(884,6,5,34,11,11,'Kirchhain, Stadt',35274,90,16233,7976,8257,179),
	(885,5,7,70,12,12,'Hille',32479,102,16230,8060,8170,158),
	(886,5,7,66,48,48,'Leopoldshöhe',33818,36,16216,8011,8205,439),
	(887,5,7,58,20,20,'Kirchlengern',32278,33,16195,7905,8290,479),
	(888,9,1,90,141,141,'Penzberg, St',82377,25,16176,7786,8390,629),
	(889,9,5,77,136,136,'Gunzenhausen, St',91710,82,16176,7685,8491,196),
	(890,3,3,52,32,32,'Loxstedt',27612,156,16152,7971,8181,103),
	(891,7,1,31,70,70,'Remagen, Stadt',53424,33,16134,7898,8236,487),
	(892,3,1,57,7,7,'Vechelde',38159,75,16086,7907,8179,212),
	(893,13,0,57,5725,74,'Ribnitz-Damgarten, Stadt',18311,122,16086,7760,8326,132),
	(894,5,7,54,20,20,'Herzebrock-Clarholz',33442,79,16067,8156,7911,203),
	(895,6,4,32,2,2,'Babenhausen, Stadt',64832,66,16062,7932,8130,240),
	(896,6,6,31,15,15,'Hünfeld, Konrad-Zuse-Stadt',36088,119,16047,7875,8172,134),
	(897,9,4,79,152,152,'Selb, GKSt',95100,62,16038,7640,8398,257),
	(898,9,1,85,158,158,'Schrobenhausen, St',86529,75,16023,7770,8253,213),
	(899,5,7,74,24,24,'Hövelhof',33161,70,16021,8048,7973,226),
	(900,9,1,87,122,122,'Bruckmühl, M',83052,50,16020,8000,8020,319),
	(901,5,1,66,4,4,'Brüggen',41379,61,16011,7821,8190,261),
	(902,3,4,58,13,13,'Wardenburg',26203,118,16003,7837,8166,135),
	(903,8,1,16,5009,71,'Wendlingen am Neckar, Stadt',73240,12,15999,7748,8251,1317),
	(904,6,4,33,5,5,'Ginsheim-Gustavsburg',65462,13,15978,7833,8145,1146),
	(905,6,4,32,22,22,'Seeheim-Jugenheim',64342,28,15953,7703,8250,570),
	(906,16,0,63,5051,3,'Bad Salzungen, Stadt',36433,39,15944,7743,8201,408),
	(907,9,4,73,151,151,'Neustadt b.Coburg, GKSt',96465,61,15934,7815,8119,257),
	(908,14,5,24,120,120,'Hohenstein-Ernstthal, Stadt',9337,18,15930,7765,8165,869),
	(909,3,1,54,13,13,'Königslutter am Elm, Stadt',38154,130,15909,7766,8143,122),
	(910,3,2,51,7,7,'Bassum, Stadt',27211,168,15899,7886,8013,94),
	(911,9,1,72,118,118,'Freilassing, St',83395,14,15889,7694,8195,1072),
	(912,7,1,40,501,501,'Boppard, Stadt',56154,75,15884,7615,8269,212),
	(913,14,5,22,150,150,'Frankenberg/Sa., Stadt',9669,65,15878,7847,8031,242),
	(914,1,0,60,5,5,'Bad Segeberg, Stadt',23795,18,15874,7377,8497,841),
	(915,9,6,77,155,155,'Lohr a.Main, St',97816,90,15863,7928,7935,175),
	(916,1,0,57,62,62,'Preetz, Stadt',24211,14,15860,7533,8327,1101),
	(917,6,6,33,13,13,'Hofgeismar, Stadt',34369,86,15846,7593,8253,183),
	(918,5,3,74,16,16,'Hückeswagen, Stadt',42499,50,15832,7717,8115,314),
	(919,15,0,82,340,340,'Sandersdorf-Brehna, Stadt',6792,81,15830,7721,8109,194),
	(920,9,5,76,151,151,'Wendelstein, M',90530,50,15799,7712,8087,310),
	(921,6,4,34,5,5,'Königstein im Taunus, Stadt',61462,25,15797,7568,8229,630),
	(922,5,7,70,40,40,'Rahden, Stadt',32369,137,15795,7833,7962,115),
	(923,5,3,78,20,20,'Odenthal',51519,39,15789,7710,8079,395),
	(924,8,2,15,96,96,'Karlsbad',76307,38,15789,7683,8106,415),
	(925,3,4,58,10,10,'Hude (Oldenb)',27798,124,15785,7874,7911,127),
	(926,8,1,18,5004,78,'Freiberg am Neckar, Stadt',71691,13,15782,7678,8104,1201),
	(927,5,9,74,16,16,'Erwitte, Stadt',59597,89,15771,7722,8049,177),
	(928,3,4,61,2,2,'Brake (Unterweser), Stadt',26919,38,15739,7739,8000,412),
	(929,8,2,37,4,4,'Baiersbronn',72270,189,15730,7640,8090,83),
	(930,5,9,70,20,20,'Hilchenbach, Stadt',57271,80,15727,7806,7921,194),
	(931,14,5,22,5119,360,'Mittweida, Stadt',9648,41,15726,7613,8113,381),
	(932,3,4,57,21,21,'Weener, Stadt',26826,81,15711,7777,7934,193),
	(933,3,4,59,3,3,'Bad Essen',49152,103,15706,7700,8006,152),
	(934,15,0,86,40,40,'Genthin, Stadt',39307,224,15706,7778,7928,70),
	(935,9,6,73,114,114,'Bad Neustadt a.d.Saale, St',97616,36,15668,7617,8051,425),
	(936,5,1,66,8,8,'Grefrath',47929,30,15665,7686,7979,506),
	(937,8,2,15,102,102,'Eggenstein-Leopoldshafen',76344,26,15636,7617,8019,599),
	(938,6,4,31,5,5,'Bürstadt, Stadt',68642,34,15630,7663,7967,454),
	(939,3,4,56,1,1,'Bad Bentheim, Stadt',48455,100,15605,7690,7915,156),
	(940,1,0,55,35,35,'Ratekau',23626,59,15599,7576,8023,262),
	(941,5,3,34,28,28,'Simmerath',52152,111,15592,7839,7753,140),
	(942,8,1,18,5005,49,'Marbach am Neckar, Stadt',71672,18,15556,7722,7834,861),
	(943,14,5,21,530,530,'Schneeberg, Stadt',8289,23,15552,7503,8049,666),
	(944,10,0,44,114,114,'Rehlingen-Siersburg',66780,61,15549,7631,7918,254),
	(945,9,2,73,137,137,'Kelheim, St',93309,76,15471,7600,7871,202),
	(946,14,7,30,230,230,'Oschatz, Stadt',4758,55,15465,7538,7927,280),
	(947,5,1,54,52,52,'Straelen, Stadt',47638,74,15460,7692,7768,209),
	(948,9,1,84,119,119,'Garching b.München, St',85748,28,15451,7907,7544,548),
	(949,8,4,25,141,141,'Blaustein',89134,55,15441,7667,7774,278),
	(950,12,0,68,468,468,'Wittstock/Dosse, Stadt',16909,417,15407,7639,7768,37),
	(951,10,0,42,111,111,'Beckingen',66701,51,15403,7545,7858,298),
	(952,5,1,66,20,20,'Niederkrüchten',41372,67,15390,7563,7827,229),
	(953,6,6,36,16,16,'Witzenhausen, Stadt',37213,126,15382,7589,7793,121),
	(954,9,5,74,112,112,'Altdorf b.Nürnberg, St',90518,48,15382,7511,7871,316),
	(955,3,3,61,9,9,'Oyten',28876,63,15379,7559,7820,242),
	(956,12,0,64,428,428,'Rüdersdorf bei Berlin',15562,70,15344,7735,7609,219),
	(957,8,1,17,5002,18,'Ebersbach an der Fils, Stadt',73061,26,15330,7589,7741,584),
	(958,9,1,82,120,120,'Holzkirchen, M',83607,48,15329,7500,7829,318),
	(959,5,5,70,16,16,'Drensteinfurt, Stadt',48317,106,15314,7522,7792,144),
	(960,8,1,19,93,93,'Kernen im Remstal',71394,15,15314,7469,7845,1018),
	(961,8,3,27,5005,49,'Trossingen, Stadt',78647,24,15309,7416,7893,633),
	(962,8,1,25,5003,13,'Brackenheim, Stadt',74336,45,15279,7606,7673,334),
	(963,1,0,54,168,168,'Sylt',25980,57,15277,7326,7951,267),
	(964,6,4,32,4,4,'Dieburg, Stadt',64807,23,15238,7795,7443,660),
	(965,5,9,58,36,36,'Olsberg, Stadt',59939,117,15223,7585,7638,129),
	(966,9,1,84,130,130,'Ismaning',85737,40,15221,7376,7845,379),
	(967,3,4,51,8,8,'Wiefelstede',26215,106,15166,7581,7585,143),
	(968,5,7,74,8,8,'Bad Lippspringe, Stadt',33175,50,15165,7290,7875,298),
	(969,1,0,62,6,6,'Bargteheide, Stadt',22941,15,15136,7207,7929,956),
	(970,6,4,32,16,16,'Ober-Ramstadt, Stadt',64372,41,15087,7458,7629,360),
	(971,14,7,29,270,270,'Markranstädt, Stadt',4420,58,15081,7395,7686,259),
	(972,8,2,26,5001,13,'Eberbach, Stadt',69412,81,15058,7138,7920,186),
	(973,5,7,58,32,32,'Spenge, Stadt',32139,40,15047,7297,7750,374),
	(974,9,3,75,190,190,'Regenstauf, M',93128,99,15030,7408,7622,151),
	(975,10,0,41,517,517,'Riegelsberg',66292,14,15011,7112,7899,1021),
	(976,5,3,82,36,36,'Much',53804,78,14990,7460,7530,192),
	(977,10,0,43,115,115,'Ottweiler, Stadt',66564,45,14982,7252,7730,329),
	(978,5,5,58,4,4,'Ascheberg',59387,106,14947,7400,7547,141),
	(979,1,0,53,116,116,'Schwarzenbek, Stadt',21493,11,14933,7244,7689,1292),
	(980,9,6,77,148,148,'Karlstadt, St',97753,98,14919,7433,7486,152),
	(981,8,2,26,82,82,'Schriesheim, Stadt',69198,31,14907,7258,7649,471),
	(982,15,0,85,5002,55,'Blankenburg (Harz), Stadt',38889,45,14895,7218,7677,329),
	(983,9,2,75,141,141,'Pocking, St',94060,68,14884,7157,7727,216),
	(984,8,2,15,97,97,'Kraichtal, Stadt',76703,80,14883,7380,7503,185),
	(985,8,1,26,5003,46,'Künzelsau, Stadt',74653,75,14877,7282,7595,198),
	(986,3,1,55,12,12,'Uslar, Stadt',37170,113,14876,7225,7651,131),
	(987,6,4,34,7,7,'Neu-Anspach, Stadt',61267,36,14869,7380,7489,411),
	(988,6,4,33,10,10,'Raunheim, Stadt',65479,12,14764,7373,7391,1171),
	(989,9,7,72,202,202,'Stadtbergen, St',86391,11,14740,7071,7669,1283),
	(990,8,2,26,95,95,'Walldorf, Stadt',69190,19,14708,7323,7385,739),
	(991,8,2,26,18,18,'Eppelheim, Stadt',69214,5,14706,7239,7467,2580),
	(992,6,4,35,9,9,'Freigericht',63579,33,14704,7215,7489,440),
	(993,6,4,36,11,11,'Schwalbach am Taunus, Stadt',65824,6,14694,6854,7840,2271),
	(994,6,6,31,20,20,'Petersberg',36100,35,14692,7072,7620,414),
	(995,5,7,66,36,36,'Kalletal',32689,112,14689,7210,7479,131),
	(996,8,1,28,139,139,'Lauda-Königshofen, Stadt',97922,94,14684,7290,7394,155),
	(997,6,4,35,12,12,'Gründau',63584,67,14663,7241,7422,217),
	(998,3,3,56,8,8,'Ritterhude',27721,32,14654,7282,7372,446),
	(999,15,0,82,430,430,'Zerbst/Anhalt, Stadt',39261,78,14652,6988,7664,187),
	(1000,3,3,61,6,6,'Langwedel, Flecken',27299,76,14628,7207,7421,192),
	(1001,3,2,41,6,6,'Gehrden, Stadt',30989,43,14588,7014,7574,338),
	(1002,15,0,88,205,205,'Leuna, Stadt',6237,87,14552,7207,7345,166),
	(1003,3,1,53,5402,4,'Clausthal-Zellerfeld, Bergstadt',38678,33,14536,8401,6135,428),
	(1004,8,2,15,46,46,'Malsch',76316,51,14518,7149,7369,283),
	(1005,5,9,70,28,28,'Bad Laasphe, Stadt',57334,135,14510,7211,7299,107),
	(1006,6,4,39,11,11,'Niedernhausen',65527,35,14501,7126,7375,411),
	(1007,8,4,15,5003,53,'Münsingen, Stadt',72525,116,14497,7089,7408,125),
	(1008,12,0,73,8,8,'Angermünde, Stadt',16278,322,14492,7096,7396,45),
	(1009,5,9,70,8,8,'Burbach',57299,79,14486,7230,7256,182),
	(1010,8,3,25,5002,45,'Oberndorf am Neckar, Stadt',78727,55,14484,7146,7338,259),
	(1011,8,1,18,50,50,'Markgröningen, Stadt',71706,28,14457,7258,7199,513),
	(1012,6,6,34,5,5,'Fritzlar, Dom- und Kaiserstadt',34560,88,14454,7092,7362,163),
	(1013,8,4,36,49,49,'Isny im Allgäu, Stadt',88316,85,14443,6925,7518,169),
	(1014,8,2,26,76,76,'Sandhausen',69207,14,14433,6985,7448,992),
	(1015,15,0,87,5004,220,'Hettstedt, Stadt',6333,20,14427,7011,7416,698),
	(1016,8,2,16,5004,17,'Gernsbach, Stadt',76593,82,14398,7059,7339,175),
	(1017,8,3,15,5002,15,'Breisach am Rhein, Stadt',79206,54,14364,7171,7193,263),
	(1018,8,4,25,5008,72,'Langenau, Stadt',89129,75,14358,7254,7104,191),
	(1019,8,4,36,10,10,'Bad Wurzach, Stadt',88410,182,14350,7324,7026,79),
	(1020,14,7,30,300,300,'Taucha, Stadt',4425,33,14338,6850,7488,433),
	(1021,6,4,38,4,4,'Hainburg',63512,15,14326,7054,7272,898),
	(1022,3,4,59,12,12,'Bissendorf',49143,96,14295,7056,7239,148),
	(1023,8,2,26,105,105,'Edingen-Neckarhausen',68535,12,14293,6898,7395,1187),
	(1024,5,7,62,8,8,'Beverungen, Stadt',37688,97,14279,7028,7251,146),
	(1025,6,6,34,9,9,'Homberg (Efze), Kreisstadt',34576,99,14271,6969,7302,143),
	(1026,5,5,70,36,36,'Sassenberg, Stadt',48336,78,14266,7131,7135,183),
	(1027,9,7,77,129,129,'Füssen, St',87629,43,14247,6738,7509,328),
	(1028,9,7,80,124,124,'Immenstadt i.Allgäu, St',87509,81,14247,6808,7439,175),
	(1029,8,2,26,9,9,'Brühl',68782,10,14213,6789,7424,1395),
	(1030,6,4,32,15,15,'Münster',64839,20,14209,7080,7129,684),
	(1031,15,0,91,145,145,'Jessen (Elster), Stadt',6917,313,14206,7112,7094,45),
	(1032,6,5,33,3,3,'Bad Camberg, Stadt',65520,54,14182,7013,7169,260),
	(1033,12,0,61,316,316,'Lübben (Spreewald), Stadt',15907,119,14179,6933,7246,118),
	(1034,5,3,58,32,32,'Langerwehe',52379,41,14172,7082,7090,342),
	(1035,8,1,16,5006,56,'Plochingen, Stadt',73207,10,14115,6978,7137,1325),
	(1036,12,0,69,604,604,'Stahnsdorf',14532,49,14112,6980,7132,287),
	(1037,3,4,59,20,20,'Hagen am Teutoburger Wald',49170,34,14099,6950,7149,409),
	(1038,5,5,54,44,44,'Reken',48734,78,14088,7257,6831,179),
	(1039,5,3,58,48,48,'Niederzier',52382,63,14085,6923,7162,222),
	(1040,13,0,61,5120,4,'Bergen auf Rügen, Stadt',18528,41,14080,6766,7314,337),
	(1041,3,2,41,20,20,'Wennigsen (Deister)',30974,53,14076,6785,7291,262),
	(1042,5,3,58,4,4,'Aldenhoven',52457,44,14062,7074,6988,319),
	(1043,12,0,65,356,356,'Zehdenick, Stadt',16792,221,14033,7045,6988,63),
	(1044,9,7,78,173,173,'Mindelheim, St',87719,56,14031,6890,7141,249),
	(1045,3,3,52,50,50,'Schiffdorf',27619,113,14018,6925,7093,123),
	(1046,3,1,56,9,9,'Herzberg am Harz, Stadt',37412,71,14016,6811,7205,195),
	(1047,9,7,78,116,116,'Bad Wörishofen, St',86825,57,14001,6334,7667,242),
	(1048,9,1,84,146,146,'Neubiberg',85579,5,13998,7977,6021,2426),
	(1049,8,1,25,5011,110,'Obersulm',74182,31,13997,7008,6989,450),
	(1050,9,2,73,147,147,'Mainburg, St',84048,61,13994,7023,6971,227),
	(1051,8,3,36,105,105,'Grenzach-Wyhlen',79639,17,13980,6755,7225,807),
	(1052,9,5,72,121,121,'Eckental, M',90542,29,13976,6856,7120,470),
	(1053,6,5,35,11,11,'Lauterbach (Hessen), Kreisstadt',36341,102,13975,6723,7252,137),
	(1054,8,1,19,44,44,'Murrhardt, Stadt',71540,71,13968,6817,7151,196),
	(1055,14,6,28,260,260,'Neustadt i. Sa., Stadt',1844,83,13954,6884,7070,168),
	(1056,5,1,54,24,24,'Kalkar, Stadt',47546,88,13950,6841,7109,158),
	(1057,3,2,41,13,13,'Pattensen, Stadt',30982,67,13946,6846,7100,208),
	(1058,8,2,26,5005,56,'Neckargemünd, Stadt',69151,26,13943,6847,7096,533),
	(1059,3,4,58,9,9,'Hatten',26209,103,13932,6913,7019,135),
	(1060,5,7,70,44,44,'Stemwede',32351,166,13917,7037,6880,84),
	(1061,6,6,32,3,3,'Bebra, Stadt',36179,93,13907,6829,7078,149),
	(1062,3,4,55,7,7,'Jever, Stadt',26441,42,13904,6672,7232,330),
	(1063,6,5,31,6,6,'Grünberg, Stadt',35305,89,13896,6769,7127,156),
	(1064,12,0,65,225,225,'Mühlenbecker Land',16567,52,13888,6927,6961,265),
	(1065,9,5,73,127,127,'Stein, St',90547,19,13863,6570,7293,711),
	(1066,5,5,66,60,60,'Neuenkirchen',48485,48,13858,6936,6922,287),
	(1067,6,4,32,14,14,'Mühltal',64367,25,13858,6785,7073,547),
	(1068,6,4,32,11,11,'Groß-Zimmern',64846,21,13835,6940,6895,651),
	(1069,9,1,76,123,123,'Eichstätt, GKSt',85072,47,13835,6544,7291,290),
	(1070,12,0,64,380,380,'Petershagen/Eggersdorf',15370,17,13823,6862,6961,785),
	(1071,10,0,41,516,516,'Quierschied',66287,20,13797,6671,7126,682),
	(1072,6,6,33,17,17,'Lohfelden',34253,16,13784,6655,7129,832),
	(1073,10,0,43,117,117,'Spiesen-Elversberg',66583,11,13776,6624,7152,1208),
	(1074,3,2,54,5,5,'Bad Salzdetfurth, Stadt',31162,67,13773,6708,7065,205),
	(1075,5,9,58,48,48,'Winterberg, Stadt',59955,147,13770,6759,7011,93),
	(1076,5,9,70,36,36,'Neunkirchen',57290,39,13764,6863,6901,348),
	(1077,5,1,70,36,36,'Schermbeck',46514,110,13746,6781,6965,124),
	(1078,5,3,74,24,24,'Marienheide',51709,54,13745,6725,7020,250),
	(1079,8,1,17,5010,51,'Uhingen, Stadt',73066,24,13721,6808,6913,553),
	(1080,5,5,66,48,48,'Lotte',49504,37,13720,6769,6951,364),
	(1081,3,4,59,8,8,'Belm',49191,46,13717,6739,6978,294),
	(1082,3,4,58,7,7,'Großenkneten',26197,176,13712,6916,6796,78),
	(1083,9,1,77,115,115,'Dorfen, St',84405,99,13708,6911,6797,138),
	(1084,1,0,53,100,100,'Ratzeburg, Stadt',23909,30,13699,6398,7301,452),
	(1085,1,0,60,4,4,'Bad Bramstedt, Stadt',24576,24,13686,6663,7023,567),
	(1086,6,5,32,1,1,'Aßlar, Stadt',35614,43,13675,6669,7006,314),
	(1087,1,0,56,43,43,'Rellingen',25462,13,13673,6630,7043,1037),
	(1088,14,6,28,410,410,'Wilsdruff, Stadt',1723,81,13671,6876,6795,167),
	(1089,6,6,32,18,18,'Rotenburg a. d. Fulda, Stadt',36199,79,13666,6677,6989,171),
	(1090,9,4,72,175,175,'Pegnitz, St',91257,100,13656,6655,7001,137),
	(1091,5,1,70,16,16,'Hünxe',46569,106,13645,6588,7057,128),
	(1092,1,0,57,91,91,'Schwentinental, Stadt',24223,17,13638,6550,7088,765),
	(1093,5,3,58,36,36,'Linnich, Stadt',52441,65,13632,7046,6586,208),
	(1094,6,4,35,2,2,'Bad Soden-Salmünster, Stadt',63628,58,13575,6801,6774,232),
	(1095,6,4,33,3,3,'Büttelborn',64572,30,13564,6688,6876,452),
	(1096,8,3,16,5001,9,'Denzlingen',79211,16,13520,6514,7006,798),
	(1097,5,7,74,12,12,'Borchen',33178,77,13508,6630,6878,175),
	(1098,3,3,53,29,29,'Rosengarten',21224,63,13505,6629,6876,212),
	(1099,5,7,70,16,16,'Hüllhorst',32609,44,13429,6675,6754,300),
	(1100,6,6,34,14,14,'Melsungen, Stadt',34212,63,13427,6462,6965,213),
	(1101,5,3,66,36,36,'Schleiden, Stadt',53937,121,13425,6501,6924,110),
	(1102,6,5,32,21,21,'Solms, Stadt',35606,34,13422,6542,6880,394),
	(1103,10,0,44,116,116,'Saarwellingen',66793,41,13421,6533,6888,322),
	(1104,8,1,19,90,90,'Remshalden',73630,15,13396,6593,6803,884),
	(1105,3,1,52,4,4,'Bovenden, Flecken',37120,63,13395,6544,6851,210),
	(1106,8,4,35,35,35,'Meckenbeuren',88074,31,13389,6768,6621,420),
	(1107,9,6,71,130,130,'Hösbach, M',63768,30,13385,6636,6749,437),
	(1108,3,3,57,5408,57,'Zeven, Stadt',27404,73,13373,6699,6674,181),
	(1109,14,5,21,5116,390,'Marienberg, Stadt',9496,105,13367,6630,6737,126),
	(1110,6,4,33,7,7,'Kelsterbach, Stadt',65451,15,13363,6654,6709,869),
	(1111,6,4,35,17,17,'Langenselbold, Stadt',63505,26,13358,6468,6890,509),
	(1112,6,5,31,11,11,'Lich, Stadt',35423,77,13356,6514,6842,172),
	(1113,9,4,73,159,159,'Rödental, St',96472,49,13351,6562,6789,267),
	(1114,6,4,37,6,6,'Erbach, Kreisstadt',64711,61,13345,6363,6982,217),
	(1115,3,4,52,6,6,'Großefehn',26629,127,13344,6601,6743,105),
	(1116,9,6,74,147,147,'Haßfurt, St',97437,52,13311,6511,6800,253),
	(1117,3,4,52,25,25,'Wiesmoor, Stadt',26639,82,13299,6460,6839,160),
	(1118,9,7,71,5705,146,'Mering, M',86415,26,13297,6524,6773,496),
	(1119,5,5,70,40,40,'Sendenhorst, Stadt',48324,96,13296,6504,6792,138),
	(1120,6,5,34,4,4,'Biedenkopf, Stadt',35216,90,13271,6470,6801,147),
	(1121,5,7,62,32,32,'Steinheim, Stadt',32839,75,13270,6550,6720,175),
	(1122,9,7,75,164,164,'Weißenhorn, St',89264,53,13266,6574,6692,247),
	(1123,9,5,74,123,123,'Feucht, M',90537,9,13260,6731,6529,1353),
	(1124,6,4,36,2,2,'Eppstein, Stadt',65817,24,13254,6558,6696,547),
	(1125,9,7,72,200,200,'Schwabmünchen, St',86830,55,13253,6470,6783,239),
	(1126,13,0,59,2,2,'Anklam, Stadt',17389,41,13234,6386,6848,318),
	(1127,3,4,53,11,11,'Löningen, Stadt',49624,143,13231,6684,6547,92),
	(1128,1,0,51,11,11,'Brunsbüttel, Stadt',25541,65,13228,6541,6687,203),
	(1129,6,4,34,11,11,'Usingen, Stadt',61250,55,13225,6433,6792,237),
	(1130,8,4,25,39,39,'Erbach, Stadt',89155,63,13217,6647,6570,209),
	(1131,5,1,54,4,4,'Bedburg-Hau',47551,61,13212,6716,6496,216),
	(1132,6,4,33,14,14,'Trebur',65468,50,13211,6545,6666,263),
	(1133,3,3,53,5406,35,'Tostedt',21255,48,13209,6269,6940,274),
	(1134,8,3,26,52,52,'St. Georgen im Schwarzwald, Stadt',78112,59,13208,6422,6786,221),
	(1135,9,5,76,127,127,'Hilpoltstein, St',91161,89,13206,6708,6498,147),
	(1136,6,5,33,17,17,'Weilburg, Stadt',35781,57,13181,6522,6659,229),
	(1137,9,5,72,135,135,'Höchstadt a.d.Aisch, St',91315,70,13178,6480,6698,186),
	(1138,9,3,75,165,165,'Lappersdorf, M',93138,31,13175,6379,6796,416),
	(1139,9,1,75,135,135,'Poing',85586,12,13147,6487,6660,1018),
	(1140,8,1,28,5004,115,'Tauberbischofsheim, Stadt',97941,69,13136,6447,6689,189),
	(1141,12,0,60,5,5,'Ahrensfelde',16356,57,13114,6588,6526,227),
	(1142,9,1,78,120,120,'Eching',85386,37,13104,6602,6502,351),
	(1143,3,4,53,8,8,'Garrel',49681,113,13083,6740,6343,115),
	(1144,12,0,61,433,433,'Schönefeld',12529,81,13060,6516,6544,160),
	(1145,9,7,75,162,162,'Vöhringen, St',89269,23,13056,6383,6673,551),
	(1146,8,1,35,20,20,'Herbrechtingen, Stadt',89542,58,13039,6405,6634,222),
	(1147,5,1,62,28,28,'Rommerskirchen',41569,60,13037,6497,6540,217),
	(1148,7,3,32,24,24,'Grünstadt, Stadt',67269,18,13029,6247,6782,720),
	(1149,3,4,59,13,13,'Bohmte',49163,110,13024,6517,6507,118),
	(1150,8,1,18,3,3,'Asperg, Stadt',71679,5,13024,6447,6577,2246),
	(1151,8,4,37,5004,88,'Pfullendorf, Stadt',88630,90,13023,6656,6367,144),
	(1152,3,3,51,4,4,'Bergen, Stadt',29303,163,13013,6462,6551,79),
	(1153,5,7,70,36,36,'Preußisch Oldendorf, Stadt',32361,68,12997,6355,6642,189),
	(1154,6,4,31,16,16,'Lorsch, Stadt',64653,25,12991,6363,6628,515),
	(1155,5,5,54,64,64,'Velen',46342,70,12976,6527,6449,184),
	(1156,1,0,55,46,46,'Fehmarn, Stadt',23769,185,12972,6255,6717,70),
	(1157,16,0,75,85,85,'Pößneck, Stadt',7381,24,12972,6167,6805,531),
	(1158,6,5,31,3,3,'Buseck',35418,38,12971,6372,6599,335),
	(1159,12,0,64,44,44,'Bad Freienwalde (Oder), Stadt',16259,131,12964,6368,6596,99),
	(1160,8,3,26,3,3,'Bad Dürrheim, Stadt',78073,62,12960,6000,6960,209),
	(1161,6,4,35,7,7,'Erlensee',63526,18,12945,6470,6475,696),
	(1162,3,1,57,5,5,'Lengede',38268,34,12921,6407,6514,378),
	(1163,1,0,56,48,48,'Tornesch, Stadt',25437,20,12918,6351,6567,627),
	(1164,6,6,34,1,1,'Borken (Hessen), Stadt',34582,82,12914,6349,6565,157),
	(1165,3,4,53,13,13,'Saterland',26683,123,12904,6443,6461,104),
	(1166,8,4,35,5003,34,'Markdorf, Stadt',88677,40,12899,6204,6695,315),
	(1167,15,0,81,135,135,'Gardelegen, Hansestadt',39638,151,12892,6346,6546,85),
	(1168,3,3,51,24,24,'Winsen (Aller)',29308,155,12874,6272,6602,83),
	(1169,9,1,79,134,134,'Maisach',82216,53,12867,6360,6507,241),
	(1170,3,4,54,19,19,'Haselünne, Stadt',49740,159,12861,6506,6355,81),
	(1171,8,3,37,116,116,'Wehr, Stadt',79664,35,12861,6181,6680,360),
	(1172,1,0,57,57,57,'Plön, Stadt',24306,36,12856,8368,4488,350),
	(1173,8,2,15,84,84,'Ubstadt-Weiher',76698,36,12850,6411,6439,352),
	(1174,6,6,33,28,28,'Wolfhagen, Stadt',34466,111,12849,6250,6599,115),
	(1175,8,2,15,64,64,'Östringen, Stadt',76684,53,12844,6452,6392,241),
	(1176,10,0,46,118,118,'Tholey',66636,57,12842,6282,6560,223),
	(1177,5,1,70,4,4,'Alpen',46519,59,12836,6305,6531,216),
	(1178,3,3,57,41,41,'Scheeßel',27383,149,12834,6457,6377,86),
	(1179,9,2,77,116,116,'Eggenfelden, St',84307,44,12827,6168,6659,289),
	(1180,14,5,24,5128,160,'Lichtenstein/Sa., Stadt',9350,15,12817,6117,6700,828),
	(1181,3,1,58,6,6,'Cremlingen',38162,59,12816,6281,6535,216),
	(1182,9,1,84,120,120,'Gräfelfing',82166,9,12809,6161,6648,1337),
	(1183,3,4,59,5401,30,'Quakenbrück, Stadt',49610,17,12806,6349,6457,713),
	(1184,12,0,64,136,136,'Fredersdorf-Vogelsdorf',15370,16,12805,6362,6443,781),
	(1185,9,5,77,173,173,'Treuchtlingen, St',91757,103,12793,6304,6489,124),
	(1186,9,1,84,134,134,'Oberhaching',82041,26,12784,6324,6460,480),
	(1187,7,2,32,18,18,'Bitburg, Stadt',54634,47,12772,6034,6738,269),
	(1188,9,1,75,122,122,'Grafing b.München, St',85567,29,12761,6168,6593,431),
	(1189,9,2,73,152,152,'Neustadt a.d.Donau, St',93333,93,12760,6415,6345,136),
	(1190,3,4,60,3,3,'Dinklage, Stadt',49413,72,12755,6441,6314,176),
	(1191,8,1,15,5004,24,'Holzgerlingen, Stadt',71088,13,12753,6292,6461,953),
	(1192,8,2,26,103,103,'St. Leon-Rot',68789,25,12752,6340,6412,499),
	(1193,8,2,26,37,37,'Ketsch',68775,16,12747,6212,6535,772),
	(1194,5,1,54,28,28,'Kerken',47647,58,12746,6267,6479,220),
	(1195,12,0,72,169,169,'Jüterbog, Stadt',14913,175,12740,6216,6524,73),
	(1196,5,9,74,12,12,'Ense',59469,51,12738,6405,6333,249),
	(1197,12,0,70,316,316,'Pritzwalk, Stadt',16928,165,12737,6235,6502,77),
	(1198,3,2,51,40,40,'Sulingen, Stadt',27232,110,12716,6260,6456,115),
	(1199,8,3,17,31,31,'Friesenheim',77948,46,12700,6268,6432,273),
	(1200,3,4,52,14,14,'Krummhörn',26736,159,12693,6257,6436,80),
	(1201,9,2,71,146,146,'Plattling, St',94447,35,12673,6254,6419,353),
	(1202,9,3,75,174,174,'Neutraubling, St',93073,9,12669,6214,6455,1299),
	(1203,5,5,70,48,48,'Wadersloh',59329,117,12667,6323,6344,108),
	(1204,6,6,36,6,6,'Hessisch Lichtenau, Stadt',37235,105,12666,6270,6396,120),
	(1205,9,2,73,111,111,'Abensberg, St',93326,60,12659,6360,6299,210),
	(1206,6,5,31,8,8,'Hungen, Stadt',35410,86,12652,6308,6344,146),
	(1207,7,3,38,19,19,'Mutterstadt',67112,20,12650,6123,6527,617),
	(1208,3,2,54,26,26,'Nordstemmen',31171,60,12639,6200,6439,210),
	(1209,6,6,33,15,15,'Kaufungen',34260,26,12621,6066,6555,483),
	(1210,9,1,71,111,111,'Altötting, St',84503,23,12599,5880,6719,546),
	(1211,9,2,79,122,122,'Landau a.d.Isar, St',94405,84,12585,6159,6426,149),
	(1212,5,3,34,20,20,'Monschau, Stadt',52156,94,12577,6284,6293,133),
	(1213,9,1,90,139,139,'Peißenberg, M',82380,32,12552,6064,6488,384),
	(1214,6,4,33,2,2,'Bischofsheim',65474,9,12535,6138,6397,1390),
	(1215,9,7,74,150,150,'Krumbach (Schwaben), St',86381,44,12531,6090,6441,281),
	(1216,15,0,86,5004,140,'Möckern, Stadt',39291,422,12498,6381,6117,30),
	(1217,5,9,74,48,48,'Welver',59514,85,12490,6171,6319,146),
	(1218,3,4,53,1,1,'Barßel',26676,84,12486,6266,6220,148),
	(1219,8,2,15,5001,100,'Bad Schönborn',76669,24,12483,6116,6367,518),
	(1220,8,4,17,13,13,'Burladingen, Stadt',72393,123,12470,6105,6365,101),
	(1221,15,0,91,5002,60,'Coswig (Anhalt), Stadt',6869,249,12464,6169,6295,50),
	(1222,3,4,52,12,12,'Ihlow',26632,123,12459,6234,6225,101),
	(1223,6,5,31,18,18,'Wettenberg',35435,42,12455,6090,6365,290),
	(1224,12,0,70,296,296,'Perleberg, Stadt',19348,137,12450,6010,6440,90),
	(1225,7,1,43,5004,48,'Montabaur, Stadt',56410,33,12447,5919,6528,370),
	(1226,3,2,51,42,42,'Twistringen, Stadt',27239,114,12430,6228,6202,109),
	(1227,10,0,42,114,114,'Mettlach',66693,78,12420,6099,6321,159),
	(1228,8,1,27,5006,25,'Gaildorf, Stadt',74405,62,12417,6191,6226,198),
	(1229,3,1,53,7,7,'Langelsheim, Stadt',38685,48,12412,6130,6282,255),
	(1230,8,4,15,5005,78,'Bad Urach, Stadt',72574,55,12412,6085,6327,224),
	(1231,10,0,41,514,514,'Kleinblittersdorf',66271,27,12409,5992,6417,455),
	(1232,8,2,15,5006,66,'Philippsburg, Stadt',76661,50,12406,6188,6218,245),
	(1233,8,2,15,110,110,'Waldbronn',76337,11,12402,6124,6278,1093),
	(1234,3,1,57,1,1,'Edemissen',31234,103,12395,6075,6320,120),
	(1235,6,4,35,29,29,'Wächtersbach, Stadt',63607,50,12395,6008,6387,244),
	(1236,1,0,62,9,9,'Barsbüttel',22885,24,12368,6063,6305,501),
	(1237,9,3,76,119,119,'Burglengenfeld, St',93133,93,12364,6009,6355,133),
	(1238,3,3,59,5403,23,'Harsefeld, Flecken',21698,51,12352,6044,6308,238),
	(1239,5,9,66,16,16,'Kirchhundem',57399,147,12336,6273,6063,83),
	(1240,13,0,54,69,69,'Ludwigslust, Stadt',19288,78,12336,5927,6409,158),
	(1241,8,2,26,12,12,'Dossenheim',69221,14,12333,5896,6437,871),
	(1242,9,5,74,132,132,'Hersbruck, St',91217,22,12321,5973,6348,538),
	(1243,8,3,27,5004,46,'Spaichingen, Stadt',78549,18,12318,5987,6331,666),
	(1244,8,1,16,72,72,'Wernau (Neckar), Stadt',73249,10,12316,6050,6266,1130),
	(1245,5,9,74,24,24,'Lippetal',59510,126,12307,6155,6152,97),
	(1246,5,7,74,40,40,'Bad Wünnenberg, Stadt',33181,161,12290,6153,6137,76),
	(1247,8,1,18,5002,71,'Tamm',71732,8,12282,6084,6198,1399),
	(1248,3,1,54,19,19,'Schöningen, Stadt',38364,35,12270,6055,6215,347),
	(1249,8,3,25,5006,57,'Sulz am Neckar, Stadt',72172,87,12253,6008,6245,140),
	(1250,8,1,36,5002,10,'Bopfingen, Stadt',73441,76,12244,6045,6199,159),
	(1251,9,1,84,131,131,'Kirchheim b.München',85551,15,12240,6109,6131,789),
	(1252,5,5,58,36,36,'Olfen, Stadt',59399,52,12236,5989,6247,233),
	(1253,14,6,25,5207,40,'Bischofswerda, Stadt',1877,46,12235,5873,6362,264),
	(1254,6,5,34,10,10,'Gladenbach, Stadt',35075,72,12223,5961,6262,169),
	(1255,5,7,66,28,28,'Extertal',32699,92,12222,6064,6158,132),
	(1256,8,2,26,5003,31,'Hemsbach, Stadt',69502,12,12210,6062,6148,949),
	(1257,9,1,80,124,124,'Murnau a.Staffelsee, M',82418,38,12198,5859,6339,321),
	(1258,9,1,87,182,182,'Wasserburg a.Inn, St',83512,18,12198,6095,6103,649),
	(1259,9,5,75,153,153,'Neustadt a.d.Aisch, St',91413,61,12196,5840,6356,199),
	(1260,8,3,17,5002,26,'Ettenheim, Stadt',77955,48,12191,5914,6277,249),
	(1261,6,5,33,7,7,'Hadamar, Stadt',65589,40,12184,5972,6212,297),
	(1262,9,5,71,145,145,'Feuchtwangen, St',91555,137,12173,6024,6149,89),
	(1263,6,5,31,12,12,'Linden, Stadt',35440,22,12159,5928,6231,534),
	(1264,5,5,66,56,56,'Mettingen',49497,40,12158,5907,6251,299),
	(1265,5,9,66,8,8,'Drolshagen, Stadt',57489,67,12158,6020,6138,181),
	(1266,8,2,16,5003,9,'Durmersheim',76448,26,12158,6027,6131,465),
	(1267,15,0,83,565,565,'Wolmirstedt, Stadt',39326,54,12153,5897,6256,224),
	(1268,5,9,62,48,48,'Neuenrade, Stadt',58809,54,12145,6086,6059,224),
	(1269,9,6,71,143,143,'Mömbris, M',63776,35,12128,6038,6090,338),
	(1270,6,4,40,23,23,'Rosbach v. d. Höhe, Stadt',61191,45,12123,6096,6027,267),
	(1271,3,3,61,8,8,'Ottersberg, Flecken',28870,99,12122,5926,6196,122),
	(1272,6,4,32,20,20,'Roßdorf',64380,20,12117,5988,6129,588),
	(1273,14,5,24,200,200,'Mülsen',8132,49,12115,5983,6132,244),
	(1274,9,7,77,5748,121,'Buchloe, St',86807,36,12113,5880,6233,335),
	(1275,12,0,67,440,440,'Schöneiche bei Berlin',15566,16,12111,5982,6129,728),
	(1276,8,1,26,11,11,'Bretzfeld',74626,64,12101,6054,6047,187),
	(1277,13,0,52,18,18,'Demmin, Hansestadt',17109,81,12090,5720,6370,148),
	(1278,14,5,21,450,450,'Oelsnitz/Erzgeb., Stadt',9376,26,12083,5872,6211,460),
	(1279,1,0,58,92,92,'Kronshagen',24119,5,12080,5627,6453,2258),
	(1280,15,0,88,65,65,'Braunsbedra, Stadt',6242,74,12077,6097,5980,163),
	(1281,8,1,15,5002,15,'Gärtringen',71116,20,12076,5888,6188,598),
	(1282,16,0,77,43,43,'Schmölln, Stadt',4626,41,12068,5854,6214,290),
	(1283,9,2,75,126,126,'Hauzenberg, St',94051,82,12054,5969,6085,146),
	(1284,9,1,90,148,148,'Schongau, St',86956,21,12033,5901,6132,564),
	(1285,8,1,18,5007,70,'Steinheim an der Murr, Stadt',71711,23,12011,5972,6039,518),
	(1286,5,9,74,56,56,'Wickede (Ruhr)',58739,25,12009,5784,6225,476),
	(1287,16,0,69,24,24,'Hildburghausen, Stadt',98646,72,12004,5919,6085,165),
	(1288,6,4,35,26,26,'Schöneck',61137,21,11996,5972,6024,558),
	(1289,15,0,88,305,305,'Querfurt, Stadt',6268,155,11994,5843,6151,77),
	(1290,5,9,62,8,8,'Balve, Stadt',58802,74,11985,5935,6050,160),
	(1291,3,1,52,21,21,'Rosdorf',37124,66,11980,5954,6026,180),
	(1292,12,0,69,17,17,'Beelitz, Stadt',14547,180,11980,6091,5889,67),
	(1293,13,0,59,5922,101,'Wolgast, Stadt',17438,19,11970,5866,6104,623),
	(1294,8,2,15,105,105,'Linkenheim-Hochstetten',76351,23,11954,5884,6070,507),
	(1295,8,3,15,76,76,'Neuenburg am Rhein, Stadt',79395,44,11948,5943,6005,271),
	(1296,8,3,35,5005,100,'Rielasingen-Worblingen',78239,18,11936,5813,6123,643),
	(1297,3,3,59,13,13,'Drochtersen',21706,126,11929,6037,5892,94),
	(1298,6,5,31,9,9,'Langgöns',35428,52,11925,5863,6062,227),
	(1299,8,2,36,46,46,'Niefern-Öschelbronn',75223,22,11918,5697,6221,541),
	(1300,6,4,40,1,1,'Altenstadt',63674,30,11912,5875,6037,396),
	(1301,8,4,25,5002,20,'Blaubeuren, Stadt',89143,79,11905,5835,6070,150),
	(1302,5,1,54,20,20,'Issum',47661,54,11898,5748,6150,218),
	(1303,9,1,79,118,118,'Eichenau',82223,6,11893,5733,6160,1701),
	(1304,14,5,21,5133,590,'Stollberg/Erzgeb., Stadt',9366,38,11891,5737,6154,306),
	(1305,9,5,74,152,152,'Röthenbach a.d.Pegnitz, St',90552,14,11873,5663,6210,832),
	(1306,3,2,54,20,20,'Harsum',31177,49,11862,5869,5993,238),
	(1307,13,0,54,43,43,'Hagenow, Stadt',19230,67,11854,5820,6034,176),
	(1308,3,1,51,40,40,'Wittingen, Stadt',29378,225,11848,5961,5887,53),
	(1309,3,1,57,3,3,'Ilsede',31241,28,11831,5772,6059,416),
	(1310,5,3,66,24,24,'Kall',53925,66,11827,5879,5948,179),
	(1311,8,2,36,71,71,'Remchingen',75196,24,11799,5869,5930,490),
	(1312,6,5,34,7,7,'Dautphetal',35232,72,11796,5814,5982,164),
	(1313,9,2,77,138,138,'Pfarrkirchen, St',84347,52,11794,5668,6126,225),
	(1314,9,5,75,112,112,'Bad Windsheim, St',91438,78,11794,5694,6100,151),
	(1315,12,0,65,332,332,'Velten, Stadt',16727,23,11789,5845,5944,505),
	(1316,6,6,33,9,9,'Fuldatal',34233,33,11785,5822,5963,350),
	(1317,9,2,76,138,138,'Regen, St',94209,65,11784,5978,5806,181),
	(1318,6,4,39,12,12,'Oestrich-Winkel, Stadt',65375,59,11783,5791,5992,198),
	(1319,8,3,15,5017,113,'Titisee-Neustadt, Stadt',79822,89,11762,5771,5991,131),
	(1320,8,1,35,15,15,'Gerstetten',89547,92,11757,5776,5981,127),
	(1321,5,5,58,20,20,'Havixbeck',48329,53,11747,5623,6124,222),
	(1322,3,4,55,27,27,'Zetel',26340,81,11745,5770,5975,145),
	(1323,16,0,66,92,92,'Zella-Mehlis, Stadt',98544,28,11743,5754,5989,418),
	(1324,10,0,44,119,119,'Überherrn',66802,34,11736,5657,6079,342),
	(1325,8,2,25,5001,109,'Walldürn, Stadt',74731,105,11724,5829,5895,111),
	(1326,1,0,55,44,44,'Scharbeutz',23683,52,11723,5622,6101,224),
	(1327,8,4,16,48,48,'Ammerbuch',72119,48,11720,5826,5894,244),
	(1328,9,2,74,126,126,'Ergolding, M',84030,37,11720,5695,6025,315),
	(1329,8,3,16,5003,43,'Teningen',79331,40,11713,5812,5901,291),
	(1330,9,2,71,141,141,'Osterhofen, St',94486,111,11707,5628,6079,105),
	(1331,12,0,69,397,397,'Michendorf',14552,68,11699,5791,5908,171),
	(1332,5,5,66,72,72,'Recke',49509,53,11697,5813,5884,218),
	(1333,5,3,70,8,8,'Gangelt',52538,48,11692,5722,5970,240),
	(1334,3,3,59,28,28,'Jork',21635,62,11691,5891,5800,188),
	(1335,8,1,18,5001,7,'Besigheim, Stadt',74354,16,11681,5730,5951,694),
	(1336,9,1,90,140,140,'Peiting, M',86971,75,11678,6155,5523,155),
	(1337,9,4,71,145,145,'Hirschaid, M',96114,40,11669,5727,5942,285),
	(1338,12,0,67,124,124,'Erkner, Stadt',15537,16,11641,5554,6087,702),
	(1339,14,5,22,5102,60,'Burgstädt, Stadt',9217,25,11634,5544,6090,450),
	(1340,8,2,15,5004,99,'Graben-Neudorf',76676,28,11621,5758,5863,404),
	(1341,5,9,74,8,8,'Bad Sassendorf',59505,63,11619,5511,6108,183),
	(1342,9,1,89,157,157,'Trostberg, St',83308,51,11610,5619,5991,225),
	(1343,8,2,26,28,28,'Heddesheim',68542,14,11597,5581,6016,788),
	(1344,6,4,39,4,4,'Geisenheim, Stadt',65366,40,11595,5662,5933,287),
	(1345,1,0,53,129,129,'Wentorf bei Hamburg',21465,6,11592,5488,6104,1687),
	(1346,9,6,72,127,127,'Hammelburg, St',97762,128,11592,5777,5815,90),
	(1347,8,3,15,5005,47,'Gundelfingen',79194,14,11591,5552,6039,812),
	(1348,3,1,54,14,14,'Lehre',38165,71,11590,5842,5748,162),
	(1349,3,4,56,5403,21,'Schüttorf, Stadt',48465,11,11574,5721,5853,1030),
	(1350,8,1,25,5014,102,'Weinsberg, Stadt',74189,22,11569,5740,5829,521),
	(1351,9,1,75,127,127,'Markt Schwaben, M',85570,10,11568,5680,5888,1065),
	(1352,5,5,58,8,8,'Billerbeck, Stadt',48727,91,11547,5698,5849,127),
	(1353,1,0,61,29,29,'Glückstadt, Stadt',25348,22,11542,5776,5766,507),
	(1354,14,5,23,5122,300,'Oelsnitz/Vogtl., Stadt',8606,53,11524,5600,5924,215),
	(1355,8,2,26,38,38,'Ladenburg, Stadt',68526,19,11523,5543,5980,606),
	(1356,3,4,59,4,4,'Bad Iburg, Stadt',49186,36,11519,5528,5991,316),
	(1357,9,2,74,184,184,'Vilsbiburg, St',84137,68,11517,5663,5854,167),
	(1358,5,9,74,32,32,'Möhnesee',59519,123,11486,5772,5714,93),
	(1359,3,3,58,8,8,'Bad Fallingbostel, Stadt',29683,63,11485,5556,5929,181),
	(1360,9,3,72,153,153,'Roding, St',93426,113,11476,5678,5798,101),
	(1361,3,4,57,20,20,'Uplengen',26670,148,11469,5732,5737,77),
	(1362,5,7,54,52,52,'Werther (Westf.), Stadt',33824,35,11455,5601,5854,324),
	(1363,9,5,71,136,136,'Dinkelsbühl, GKSt',91550,75,11443,5555,5888,152),
	(1364,8,1,19,61,61,'Rudersberg',73635,39,11436,5668,5768,290),
	(1365,1,0,59,120,120,'Harrislee',24955,18,11420,5581,5839,604),
	(1366,10,0,45,116,116,'Mandelbachtal',66399,57,11413,5540,5873,198),
	(1367,3,4,56,25,25,'Wietmarschen',49835,118,11389,5759,5630,96),
	(1368,16,0,77,32,32,'Meuselwitz, Stadt',4610,53,11385,5515,5870,213),
	(1369,8,1,16,47,47,'Neuhausen auf den Fildern',73765,12,11384,5543,5841,913),
	(1370,3,4,53,5,5,'Emstek',49685,108,11379,5868,5511,105),
	(1371,13,0,62,43,43,'Pasewalk, Stadt',17309,54,11376,5493,5883,207),
	(1372,3,4,54,14,14,'Geeste',49744,133,11368,5828,5540,85),
	(1373,5,9,58,8,8,'Bestwig',59909,69,11366,5506,5860,164),
	(1374,9,1,75,115,115,'Ebersberg, St',85560,40,11366,5537,5829,278),
	(1375,9,1,87,165,165,'Raubling',83064,44,11363,5540,5823,257),
	(1376,3,2,52,1,1,'Aerzen, Flecken',31855,105,11347,5558,5789,108),
	(1377,9,1,86,137,137,'Manching, M',85077,35,11326,5580,5746,319),
	(1378,1,0,53,83,83,'Lauenburg/ Elbe, Stadt',21481,9,11318,5601,5717,1186),
	(1379,13,0,51,4,4,'Bad Doberan, Stadt',18209,32,11280,5403,5877,344),
	(1380,9,1,84,135,135,'Oberschleißheim',85764,30,11279,5689,5590,372),
	(1381,14,5,21,5140,710,'Zwönitz, Stadt',8297,52,11278,5545,5733,213),
	(1382,5,9,62,56,56,'Schalksmühle',58579,38,11272,5579,5693,295),
	(1383,8,3,17,153,153,'Rheinau, Stadt',77866,73,11260,5590,5670,153),
	(1384,3,1,56,2,2,'Bad Lauterberg im Harz, Stadt',37431,41,11257,5315,5942,271),
	(1385,6,6,31,6,6,'Eichenzell',36124,56,11254,5542,5712,201),
	(1386,5,5,66,92,92,'Westerkappeln',49492,85,11249,5578,5671,131),
	(1387,15,0,86,55,55,'Gommern, Stadt',39245,159,11249,5510,5739,70),
	(1388,9,6,79,170,170,'Ochsenfurt, St',97199,63,11248,5459,5789,177),
	(1389,5,5,54,32,32,'Isselburg, Stadt',46419,42,11236,5646,5590,263),
	(1390,8,1,18,5006,67,'Schwieberdingen',71701,14,11230,5704,5526,755),
	(1391,9,5,74,117,117,'Burgthann',90559,39,11228,5558,5670,286),
	(1392,8,2,16,5007,49,'Sinzheim',76547,28,11225,5422,5803,394),
	(1393,12,0,69,20,20,'Belzig, Stadt',14806,234,11225,5447,5778,48),
	(1394,9,2,74,113,113,'Altdorf, M',84032,23,11201,5447,5754,487),
	(1395,9,2,74,128,128,'Essenbach, M',84051,83,11196,5677,5519,134),
	(1396,9,2,73,116,116,'Bad Abbach, M',93077,55,11189,5432,5757,202),
	(1397,6,4,35,23,23,'Rodenbach',63517,16,11177,5450,5727,668),
	(1398,5,3,74,28,28,'Morsbach',51597,55,11160,5538,5622,199),
	(1399,3,1,52,9,9,'Friedland',37133,75,11151,5336,5815,147),
	(1400,3,4,59,21,21,'Hasbergen',49205,21,11149,5440,5709,513),
	(1401,9,7,76,117,117,'Lindenberg i.Allgäu, St',88161,11,11148,5400,5748,941),
	(1402,15,0,90,415,415,'Osterburg (Altmark), Hansestadt',39606,229,11139,5495,5644,48),
	(1403,9,1,82,125,125,'Miesbach, St',83714,32,11136,5352,5784,343),
	(1404,8,3,17,5003,34,'Gengenbach, Stadt',77723,61,11130,5345,5785,180),
	(1405,12,0,69,306,306,'Kloster Lehnin',14797,199,11129,5587,5542,56),
	(1406,9,1,76,126,126,'Gaimersheim, M',85080,28,11127,5515,5612,394),
	(1407,14,5,24,320,320,'Wilkau-Haßlau, Stadt',8112,12,11127,5305,5822,875),
	(1408,8,4,35,5005,52,'Salem',88682,62,11121,5525,5596,177),
	(1409,9,7,71,142,142,'Kissing',86438,23,11114,5489,5625,480),
	(1410,8,1,36,42,42,'Lorch, Stadt',73547,34,11097,5528,5569,324),
	(1411,9,7,72,177,177,'Meitingen, M',86405,29,11097,5453,5644,371),
	(1412,16,0,74,5052,18,'Eisenberg, Stadt',7607,24,11087,5342,5745,446),
	(1413,8,4,15,19,19,'Eningen unter Achalm',72800,23,11071,5389,5682,478),
	(1414,8,2,26,62,62,'Oftersheim',68723,12,11068,5327,5741,866),
	(1415,8,1,19,5005,84,'Welzheim, Stadt',73642,37,11059,5412,5647,291),
	(1416,3,3,53,32,32,'Stelle',21435,38,11053,5452,5601,286),
	(1417,9,5,71,193,193,'Rothenburg ob der Tauber, GKSt',91541,41,11053,5286,5767,265),
	(1418,8,1,25,5013,86,'Schwaigern, Stadt',74193,49,11051,5511,5540,223),
	(1419,9,1,86,162,162,'Wolnzach, M',85283,91,11047,5489,5558,121),
	(1420,9,1,84,122,122,'Grünwald',82031,7,11033,5051,5982,1446),
	(1421,14,7,29,140,140,'Frohburg, Stadt',4654,108,11024,5556,5468,102),
	(1422,5,7,74,28,28,'Lichtenau, Stadt',33165,192,11021,5630,5391,57),
	(1423,8,2,35,5001,6,'Altensteig, Stadt',72213,53,11016,5439,5577,207),
	(1424,3,4,51,1,1,'Apen',26689,76,11015,5487,5528,143),
	(1425,3,1,51,25,25,'Sassenburg',38524,88,11009,5511,5498,125),
	(1426,15,0,88,5001,20,'Bad Dürrenberg, Stadt',6231,19,11009,5379,5630,575),
	(1427,6,5,32,3,3,'Braunfels, Stadt',35619,47,10997,5289,5708,233),
	(1428,5,5,54,40,40,'Raesfeld',46348,57,10991,5566,5425,190),
	(1429,5,3,58,52,52,'Nörvenich',52388,66,10988,5578,5410,166),
	(1430,6,6,31,18,18,'Neuhof',36119,90,10975,5488,5487,122),
	(1431,6,5,35,16,16,'Schotten, Stadt',63679,133,10955,5518,5437,82),
	(1432,6,4,31,21,21,'Wald-Michelbach',69483,74,10948,5456,5492,147),
	(1433,7,1,31,90,90,'Grafschaft',53501,57,10943,5503,5440,190),
	(1434,9,4,75,154,154,'Münchberg, St',95213,68,10933,5239,5694,159),
	(1435,8,4,25,5007,71,'Laichingen, Stadt',89150,69,10920,5430,5490,156),
	(1436,6,4,35,28,28,'Steinau an der Straße, Stadt',36396,104,10918,5480,5438,104),
	(1437,10,0,41,511,511,'Friedrichsthal, Stadt',66299,9,10903,5298,5605,1202),
	(1438,5,5,58,40,40,'Rosendahl',48720,94,10898,5600,5298,116),
	(1439,10,0,46,112,112,'Marpingen',66646,39,10880,5385,5495,274),
	(1440,9,6,77,157,157,'Marktheidenfeld, St',97828,35,10865,5258,5607,304),
	(1441,1,0,55,28,28,'Malente',23714,69,10848,5149,5699,157),
	(1442,7,2,31,502,502,'Morbach',54497,122,10843,5456,5387,89),
	(1443,8,1,25,5006,56,'Lauffen am Neckar, Stadt',74348,22,10837,5298,5539,479),
	(1444,8,1,17,5006,15,'Donzdorf, Stadt',73072,39,10824,5394,5430,272),
	(1445,7,1,37,5008,216,'Mülheim-Kärlich, Stadt',56218,16,10823,5245,5578,664),
	(1446,8,1,19,5006,42,'Leutenbach',71397,14,10823,5258,5565,735),
	(1447,12,0,63,36,36,'Brieselang',14656,44,10823,5472,5351,244),
	(1448,7,3,38,17,17,'Limburgerhof',67117,9,10817,5138,5679,1202),
	(1449,1,0,59,183,183,'Handewitt',24983,77,10816,5406,5410,139),
	(1450,13,0,58,34,34,'Grevesmühlen, Stadt',23936,52,10809,5244,5565,207),
	(1451,3,1,53,13,13,'Vienenburg, Stadt',38690,71,10792,5206,5586,152),
	(1452,8,1,25,58,58,'Leingarten',74211,23,10784,5263,5521,459),
	(1453,12,0,65,96,96,'Glienicke/Nordbahn',16548,4,10774,5259,5515,2342),
	(1454,6,4,39,2,2,'Bad Schwalbach, Kreisstadt',65307,40,10772,5205,5567,267),
	(1455,8,2,36,72,72,'Straubenhardt',75334,33,10762,5346,5416,325),
	(1456,8,4,17,25,25,'Haigerloch, Stadt',72401,76,10754,5363,5391,141),
	(1457,16,0,67,72,72,'Waltershausen, Stadt',99880,30,10754,5257,5497,349),
	(1458,15,0,88,330,330,'Schkopau',6258,90,10750,5378,5372,119),
	(1459,6,4,36,9,9,'Kriftel',65830,6,10742,5307,5435,1589),
	(1460,9,7,73,144,144,'Lauingen (Donau), St',89415,44,10736,5182,5554,242),
	(1461,9,6,77,131,131,'Gemünden a.Main, St',97737,75,10717,5255,5462,143),
	(1462,5,3,58,44,44,'Nideggen, Stadt',52385,65,10716,5269,5447,165),
	(1463,5,3,82,52,52,'Ruppichteroth',53809,61,10713,5208,5505,173),
	(1464,14,5,22,50,50,'Brand-Erbisdorf, Stadt',9618,46,10711,5197,5514,232),
	(1465,7,1,41,5003,29,'Diez, Stadt',65582,12,10708,5392,5316,863),
	(1466,12,0,65,251,251,'Oberkrämer',16727,103,10706,5448,5258,104),
	(1467,8,2,26,60,60,'Nußloch',69226,13,10703,5210,5493,788),
	(1468,3,2,52,5,5,'Emmerthal',31860,114,10702,5205,5497,93),
	(1469,3,2,54,8,8,'Bockenem, Stadt',31167,109,10702,5269,5433,98),
	(1470,6,5,32,14,14,'Hüttenberg',35625,40,10700,5218,5482,263),
	(1471,5,9,74,36,36,'Rüthen, Stadt',59602,158,10684,5236,5448,68),
	(1472,14,6,28,50,50,'Bannewitz',1728,25,10682,5265,5417,414),
	(1473,6,4,38,3,3,'Egelsbach',63329,14,10679,5276,5403,721),
	(1474,6,6,34,3,3,'Felsberg, Stadt',34587,83,10660,5176,5484,128),
	(1475,6,4,31,7,7,'Fürth',64658,38,10657,5243,5414,277),
	(1476,5,5,70,32,32,'Ostbevern',48346,89,10649,5145,5504,119),
	(1477,3,4,57,17,17,'Ostrhauderfehn',26842,51,10635,5314,5321,209),
	(1478,13,0,54,13,13,'Boizenburg/ Elbe, Stadt',19258,47,10627,5297,5330,225),
	(1479,8,1,18,51,51,'Möglingen',71696,9,10578,5265,5313,1065),
	(1480,5,5,58,28,28,'Nordkirchen',59394,52,10577,5515,5062,202),
	(1481,7,3,38,5,5,'Böhl-Iggelheim',67459,32,10552,5172,5380,321),
	(1482,5,9,74,4,4,'Anröchte',59609,73,10548,5228,5320,143),
	(1483,6,5,31,16,16,'Reiskirchen',35447,44,10546,5218,5328,234),
	(1484,8,2,35,5008,79,'Bad Wildbad, Stadt',75323,105,10544,5116,5428,100),
	(1485,13,0,57,36,36,'Grimmen, Stadt',18507,50,10536,5084,5452,210),
	(1486,6,6,33,20,20,'Niestetal',34266,22,10528,5032,5496,475),
	(1487,7,3,37,5004,38,'Herxheim bei Landau/ Pfalz',76863,29,10519,5158,5361,361),
	(1488,8,2,36,4,4,'Birkenfeld',75217,19,10515,5174,5341,552),
	(1489,3,4,62,5,5,'Friedeburg',26446,163,10513,5158,5355,64),
	(1490,8,1,16,15,15,'Denkendorf',73770,13,10509,5194,5315,805),
	(1491,6,5,32,9,9,'Eschenburg',35713,45,10502,5358,5144,229),
	(1492,8,4,17,5005,44,'Meßstetten, Stadt',72469,76,10502,5279,5223,137),
	(1493,9,4,78,165,165,'Bad Staffelstein, St',96231,99,10499,5100,5399,106),
	(1494,5,7,66,52,52,'Lügde, Stadt',32676,88,10494,5214,5280,118),
	(1495,9,1,71,113,113,'Burgkirchen a.d.Alz',84508,46,10483,5183,5300,227),
	(1496,9,1,84,138,138,'Planegg',82152,10,10480,4999,5481,981),
	(1497,13,0,61,35,35,'Sassnitz, Stadt',18546,47,10474,5143,5331,222),
	(1498,14,5,21,5138,690,'Zschopau, Stadt',9405,22,10474,5117,5357,458),
	(1499,3,1,55,1,1,'Bad Gandersheim, Stadt',37581,90,10469,4971,5498,116),
	(1500,9,3,76,141,141,'Maxhütte-Haidhof, St',93142,34,10466,5178,5288,302),
	(1501,10,0,43,113,113,'Merchweiler',66589,12,10465,5088,5377,819),
	(1502,3,2,57,5403,6,'Bad Nenndorf, Stadt',31542,23,10460,4783,5677,451),
	(1503,5,1,54,64,64,'Weeze',47652,79,10454,5454,5000,132),
	(1504,9,6,78,193,193,'Werneck, M',97440,73,10451,5222,5229,142),
	(1505,3,2,56,25,25,'Rehburg-Loccum, Stadt',31547,99,10446,5195,5251,105),
	(1506,9,2,72,151,151,'Waldkirchen, St',94065,80,10446,5111,5335,131),
	(1507,12,0,66,112,112,'Großräschen, Stadt',1983,81,10428,5297,5131,128),
	(1508,8,2,15,5005,59,'Oberderdingen',75038,33,10427,5137,5290,311),
	(1509,9,5,73,120,120,'Langenzenn, St',90579,46,10419,5062,5357,225),
	(1510,8,1,19,41,41,'Korb',71404,8,10401,5118,5283,1231),
	(1511,3,1,55,3,3,'Dassel, Stadt',37586,113,10392,5113,5279,92),
	(1512,3,3,61,5,5,'Kirchlinteln',27308,174,10389,5194,5195,60),
	(1513,12,0,72,340,340,'Rangsdorf',15834,33,10372,5134,5238,308),
	(1514,3,1,57,4,4,'Lahstedt',31246,43,10371,5130,5241,238),
	(1515,14,6,28,60,60,'Dippoldiswalde, Stadt',1744,63,10323,5057,5266,163),
	(1516,3,3,57,51,51,'Visselhövede, Stadt',27374,158,10309,5098,5211,65),
	(1517,8,4,26,5007,97,'Riedlingen, Stadt',88499,64,10296,4996,5300,158),
	(1518,9,1,87,162,162,'Prien a.Chiemsee, M',83209,20,10292,4752,5540,497),
	(1519,12,0,61,572,572,'Zeuthen',15738,12,10290,5060,5230,813),
	(1520,6,6,33,23,23,'Schauenburg',34270,30,10286,5099,5187,333),
	(1521,8,3,35,5002,28,'Gottmadingen',78244,23,10264,4999,5265,435),
	(1522,6,4,31,17,17,'Mörlenbach',69509,27,10254,5045,5209,377),
	(1523,5,3,70,24,24,'Selfkant',52538,42,10251,5169,5082,244),
	(1524,9,1,81,114,114,'Dießen am Ammersee, M',86911,82,10239,4784,5455,124),
	(1525,12,0,61,320,320,'Luckau, Stadt',15926,206,10231,5084,5147,50),
	(1526,8,1,15,42,42,'Rutesheim, Stadt',71277,16,10226,5045,5181,630),
	(1527,9,5,73,114,114,'Cadolzburg, M',90556,45,10224,5026,5198,225),
	(1528,8,3,26,5,5,'Blumberg, Stadt',78176,98,10216,5082,5134,104),
	(1529,14,6,27,310,310,'Weinböhla',1689,19,10214,5029,5185,537),
	(1530,3,4,59,22,22,'Hilter am Teutoburger Wald',49176,52,10206,5032,5174,194),
	(1531,5,5,66,4,4,'Altenberge',48341,62,10202,5065,5137,163),
	(1532,9,1,87,130,130,'Feldkirchen-Westerham',83620,53,10200,5096,5104,192),
	(1533,8,3,36,84,84,'Steinen',79585,46,10197,4985,5212,218),
	(1534,8,3,35,5001,22,'Engen, Stadt',78234,70,10188,4944,5244,144),
	(1535,12,0,60,198,198,'Schorfheide',16244,236,10172,5185,4987,43),
	(1536,12,0,69,590,590,'Schwielowsee',14548,58,10172,4973,5199,175),
	(1537,14,6,26,370,370,'Niesky, Stadt',2906,53,10168,4919,5249,190),
	(1538,3,3,55,1,1,'Adendorf',21365,16,10163,4947,5216,632),
	(1539,6,4,39,7,7,'Hünstetten',65510,50,10153,5043,5110,201),
	(1540,10,0,46,114,114,'Nohfelden',66625,100,10151,5085,5066,101),
	(1541,15,0,89,55,55,'Calbe (Saale), Stadt',39240,56,10139,4944,5195,179),
	(1542,1,0,58,34,34,'Büdelsdorf, Stadt',24782,6,10137,4924,5213,1627),
	(1543,7,1,32,5002,6,'Betzdorf, Stadt',57518,9,10135,4950,5185,1059),
	(1544,9,2,78,118,118,'Bogen, St',94327,49,10135,5070,5065,204),
	(1545,3,3,51,12,12,'Hambühren',29313,56,10133,4968,5165,179),
	(1546,12,0,62,224,224,'Herzberg (Elster), Stadt',4916,148,10130,5007,5123,68),
	(1547,13,0,62,59,59,'Ueckermünde, Stadt',17373,84,10127,5213,4914,120),
	(1548,6,4,33,9,9,'Nauheim',64569,13,10119,5045,5074,735),
	(1549,14,5,21,460,460,'Olbernhau, Stadt',9526,70,10100,4946,5154,143),
	(1550,10,0,45,115,115,'Kirkel',66459,31,10081,4914,5167,321),
	(1551,3,1,57,8,8,'Wendeburg',38176,59,10074,4990,5084,168),
	(1552,6,5,31,2,2,'Biebertal',35444,43,10054,4947,5107,229),
	(1553,9,1,88,124,124,'Herrsching a.Ammersee',82211,20,10053,4623,5430,481),
	(1554,8,1,36,5006,28,'Heubach, Stadt',73540,25,10043,4959,5084,389),
	(1555,12,0,62,24,24,'Bad Liebenwerda, Stadt',4924,138,10038,4923,5115,73),
	(1556,3,2,52,8,8,'Salzhemmendorf, Flecken',31020,94,10022,4925,5097,106),
	(1557,3,4,55,20,20,'Wangerland',26434,175,10020,4935,5085,57),
	(1558,6,5,31,10,10,'Laubach, Stadt',35321,97,10006,4914,5092,103),
	(1559,6,4,34,10,10,'Steinbach (Taunus), Stadt',61449,4,9988,4780,5208,2270),
	(1560,14,5,22,5108,140,'Flöha, Stadt',9557,18,9974,4763,5211,537),
	(1561,6,4,31,4,4,'Birkenau',69488,24,9973,4830,5143,406),
	(1562,9,3,71,136,136,'Kümmersbruck',92245,46,9972,4917,5055,215),
	(1563,1,0,58,5,5,'Altenholz',24161,19,9969,4842,5127,524),
	(1564,9,7,80,133,133,'Oberstdorf, M',87561,229,9968,4620,5348,43),
	(1565,9,6,79,202,202,'Veitshöchheim',97209,10,9967,4917,5050,926),
	(1566,5,1,54,40,40,'Kranenburg',47559,76,9963,4952,5011,130),
	(1567,8,4,37,5002,76,'Mengen, Stadt',88512,49,9960,4914,5046,200),
	(1568,9,1,86,5156,122,'Geisenfeld, St',85290,88,9947,5071,4876,113),
	(1569,7,3,38,4,4,'Bobenheim-Roxheim',67240,20,9941,4840,5101,485),
	(1570,8,2,35,80,80,'Wildberg, Stadt',72218,56,9941,4908,5033,175),
	(1571,8,3,16,5004,17,'Herbolzheim, Stadt',79336,35,9939,4895,5044,280),
	(1572,8,1,17,5006,49,'Süßen, Stadt',73079,12,9932,4929,5003,777),
	(1573,15,0,82,440,440,'Zörbig, Stadt',6780,113,9932,4935,4997,87),
	(1574,15,0,87,275,275,'Mansfeld, Stadt',6343,143,9931,4980,4951,69),
	(1575,9,6,76,122,122,'Erlenbach a.Main, St',63906,16,9920,4945,4975,607),
	(1576,14,6,25,430,430,'Ottendorf-Okrilla',1458,25,9920,4981,4939,383),
	(1577,9,7,80,112,112,'Altusried, M',87452,91,9919,4923,4996,108),
	(1578,6,5,33,8,8,'Hünfelden',65597,62,9918,4920,4998,158),
	(1579,9,1,72,111,111,'Ainring',83404,32,9918,4843,5075,301),
	(1580,5,7,58,28,28,'Rödinghausen',32289,36,9914,4932,4982,273),
	(1581,9,7,72,130,130,'Diedorf, M',86420,33,9910,4777,5133,298),
	(1582,9,1,87,177,177,'Stephanskirchen',83071,26,9908,4685,5223,374),
	(1583,12,0,61,540,540,'Wildau',15745,9,9906,4850,5056,1089),
	(1584,8,1,15,51,51,'Weil im Schönbuch',71093,26,9902,4886,5016,379),
	(1585,9,1,81,128,128,'Kaufering, M',86916,17,9880,4787,5093,559),
	(1586,6,5,31,13,13,'Lollar, Stadt',35457,21,9874,4868,5006,451),
	(1587,8,2,15,5003,103,'Karlsdorf-Neuthard',76689,14,9864,4925,4939,704),
	(1588,8,4,36,8,8,'Aulendorf, Stadt',88326,52,9858,4852,5006,188),
	(1589,3,4,54,10,10,'Emsbüren',48488,139,9856,5017,4839,71),
	(1590,6,4,35,18,18,'Linsengericht',63589,29,9853,4845,5008,330),
	(1591,8,2,15,90,90,'Weingarten (Baden)',76356,29,9846,4764,5082,335),
	(1592,6,5,35,15,15,'Schlitz, Stadt',36110,142,9833,4845,4988,69),
	(1593,9,2,76,148,148,'Zwiesel, St',94227,41,9829,4837,4992,239),
	(1594,6,4,40,24,24,'Wölfersheim',61200,43,9824,4870,4954,228),
	(1595,3,2,54,17,17,'Giesen',31180,33,9814,4803,5011,289),
	(1596,9,5,73,125,125,'Roßtal, M',90574,44,9806,4819,4987,221),
	(1597,3,4,59,5403,17,'Fürstenau, Stadt',49584,78,9804,4807,4997,125),
	(1598,14,5,22,460,460,'Penig, Stadt',9322,63,9798,4755,5043,155),
	(1599,5,3,58,40,40,'Merzenich',52399,37,9797,4757,5040,258),
	(1600,8,3,17,5,5,'Appenweier',77767,38,9794,4807,4987,258),
	(1601,9,2,77,145,145,'Simbach a.Inn, St',84359,47,9791,4663,5128,207),
	(1602,15,0,85,190,190,'Ilsenburg (Harz), Stadt',38871,63,9785,4813,4972,155),
	(1603,6,4,35,1,1,'Bad Orb, Stadt',63619,47,9779,4655,5124,205),
	(1604,8,1,16,81,81,'Aichtal, Stadt',72631,23,9778,4908,4870,414),
	(1605,9,1,73,135,135,'Lenggries',83661,242,9771,4715,5056,40),
	(1606,8,2,36,5002,76,'Königsbach-Stein',75203,33,9762,4796,4966,290),
	(1607,8,1,15,44,44,'Schönaich',71101,14,9755,4836,4919,689),
	(1608,1,0,56,2,2,'Barmstedt, Stadt',25355,17,9741,4730,5011,567),
	(1609,3,4,56,5402,14,'Neuenhaus, Stadt',49828,31,9740,4859,4881,311),
	(1610,9,6,71,121,121,'Goldbach, M',63773,10,9715,4733,4982,886),
	(1611,8,3,15,5003,64,'Kirchzarten',79199,21,9691,4588,5103,458),
	(1612,1,0,55,33,33,'Oldenburg in Holstein, Stadt',23758,39,9689,4632,5057,244),
	(1613,9,1,84,127,127,'Höhenkirchen-Siegertsbrunn',85635,15,9684,4815,4869,638),
	(1614,12,0,68,264,264,'Kyritz, Stadt',16866,156,9681,4714,4967,62),
	(1615,6,4,37,9,9,'Höchst i. Odw.',64739,30,9676,4807,4869,317),
	(1616,12,0,71,244,244,'Kolkwitz',3099,104,9664,4922,4742,93),
	(1617,1,0,59,45,45,'Kappeln, Stadt',24376,43,9663,4904,4759,223),
	(1618,6,5,35,13,13,'Mücke',35325,86,9660,4788,4872,112),
	(1619,6,4,33,4,4,'Gernsheim, Schöfferstadt',64579,40,9658,4813,4845,241),
	(1620,3,3,55,9,9,'Bleckede, Stadt',21354,140,9653,4666,4987,69),
	(1621,8,1,16,5009,35,'Köngen',73257,12,9648,4746,4902,771),
	(1622,3,4,54,54,54,'Twist',49767,105,9630,4870,4760,91),
	(1623,6,4,39,13,13,'Rüdesheim am Rhein, Stadt',65385,51,9624,4621,5003,187),
	(1624,14,5,21,370,370,'Lößnitz, Stadt',8294,30,9619,4645,4974,315),
	(1625,3,4,60,8,8,'Steinfeld (Oldenburg)',49439,59,9595,4874,4721,160),
	(1626,8,1,25,5009,69,'Neuenstadt am Kocher, Stadt',74196,41,9588,4828,4760,233),
	(1627,8,2,15,5006,107,'Oberhausen-Rheinhausen',68794,18,9584,4701,4883,506),
	(1628,5,7,66,4,4,'Augustdorf',32832,42,9568,4815,4753,227),
	(1629,14,7,29,70,70,'Brandis, Stadt',4821,34,9567,4705,4862,275),
	(1630,9,4,79,169,169,'Wunsiedel, St',95632,54,9566,4637,4929,174),
	(1631,8,2,26,63,63,'Plankstadt',68723,8,9542,4568,4974,1137),
	(1632,3,4,59,29,29,'Ostercappeln',49179,100,9537,4682,4855,95),
	(1633,3,3,54,5407,18,'Lüchow (Wendland), Stadt',29439,89,9533,4632,4901,107),
	(1634,10,0,44,121,121,'Wallerfangen',66798,42,9528,4661,4867,226),
	(1635,6,5,33,13,13,'Runkel, Stadt',65594,43,9500,4661,4839,217),
	(1636,8,1,16,5008,70,'Weilheim an der Teck, Stadt',73235,26,9497,4704,4793,358),
	(1637,9,1,84,147,147,'Unterföhring',85774,12,9497,4685,4812,743),
	(1638,8,2,26,107,107,'Hirschberg an der Bergstraße',69493,12,9494,4557,4937,769),
	(1639,9,4,75,162,162,'Rehau, St',95111,80,9476,4576,4900,118),
	(1640,14,6,25,310,310,'Lauta, Stadt',2991,41,9476,4672,4804,226),
	(1641,15,0,83,490,490,'Sülzetal',39171,103,9475,4728,4747,91),
	(1642,9,1,88,141,141,'Tutzing',82327,35,9473,4366,5107,266),
	(1643,9,1,75,124,124,'Kirchseeon, M',85614,17,9469,4676,4793,529),
	(1644,5,5,70,24,24,'Everswinkel',48351,68,9452,4688,4764,137),
	(1645,8,3,17,151,151,'Neuried',77743,57,9442,4610,4832,163),
	(1646,3,3,56,11,11,'Worpswede',27726,76,9427,4565,4862,124),
	(1647,7,3,33,5002,19,'Eisenberg (Pfalz), Stadt',67304,18,9420,4680,4740,503),
	(1648,13,0,62,5217,58,'Torgelow, Stadt',17358,49,9413,4695,4718,191),
	(1649,3,2,57,28,28,'Obernkirchen, Stadt',31683,32,9408,4665,4743,290),
	(1650,9,6,79,147,147,'Höchberg, M',97204,7,9399,4505,4894,1245),
	(1651,3,4,54,5409,57,'Werlte',49757,63,9397,4703,4694,147),
	(1652,6,4,34,12,12,'Wehrheim',61273,38,9392,4668,4724,245),
	(1653,8,4,15,5004,60,'Pliezhausen',72124,17,9384,4644,4740,542),
	(1654,8,1,19,5002,55,'Plüderhausen',73655,26,9377,4641,4736,359),
	(1655,5,5,66,64,64,'Nordwalde',48356,51,9375,4635,4740,183),
	(1656,8,2,35,5004,8,'Bad Liebenzell, Stadt',75378,33,9374,4496,4878,277),
	(1657,8,1,19,5006,68,'Schwaikheim',71409,9,9373,4597,4776,1017),
	(1658,6,4,37,1,1,'Bad König, Stadt',64732,46,9368,4526,4842,200),
	(1659,9,1,74,131,131,'Markt Indersdorf, M',85229,68,9364,4646,4718,137),
	(1660,3,1,57,2,2,'Hohenhameln',31249,69,9350,4741,4609,135),
	(1661,9,6,76,139,139,'Miltenberg, St',63897,60,9347,4616,4731,155),
	(1662,13,0,59,112,112,'Heringsdorf',17424,37,9346,4428,4918,249),
	(1663,5,9,54,4,4,'Breckerfeld, Stadt',58339,58,9344,4596,4748,159),
	(1664,5,7,74,4,4,'Altenbeken',33184,76,9341,4696,4645,123),
	(1665,3,3,57,16,16,'Gnarrenburg',27442,122,9340,4643,4697,76),
	(1666,15,0,90,5008,550,'Tangermünde, Stadt',39590,22,9336,4505,4831,424),
	(1667,1,0,62,90,90,'Ammersbek',22949,17,9335,4583,4752,527),
	(1668,8,1,15,5005,16,'Gäufelden',71126,20,9332,4683,4649,465),
	(1669,10,0,44,113,113,'Nalbach',66809,22,9320,4509,4811,416),
	(1670,3,1,52,11,11,'Gleichen',37130,128,9314,4616,4698,72),
	(1671,3,4,60,4,4,'Goldenstedt',49424,88,9314,4688,4626,105),
	(1672,12,0,72,426,426,'Trebbin, Stadt',14959,125,9311,4668,4643,74),
	(1673,3,4,60,10,10,'Visbek',49429,84,9310,4767,4543,111),
	(1674,8,4,15,14,14,'Dettingen an der Erms',72581,15,9304,4629,4675,588),
	(1675,8,4,17,5003,8,'Bisingen',72406,32,9304,4578,4726,283),
	(1676,6,5,32,8,8,'Ehringshausen',35630,45,9303,4575,4728,205),
	(1677,3,4,59,15,15,'Dissen am Teutoburger Wald, Stadt',49201,31,9291,4675,4616,291),
	(1678,7,1,43,5003,32,'Höhr-Grenzhausen, Stadt',56203,15,9291,4483,4808,585),
	(1679,8,3,26,5002,17,'Furtwangen im Schwarzwald, Stadt',78120,82,9289,4811,4478,112),
	(1680,6,4,35,27,27,'Sinntal',36391,111,9272,4666,4606,83),
	(1681,6,4,40,17,17,'Niddatal, Stadt',61194,40,9268,4555,4713,230),
	(1682,9,7,75,134,134,'Nersingen',89278,24,9258,4613,4645,381),
	(1683,9,7,74,121,121,'Burgau, St',89331,25,9254,4581,4673,357),
	(1684,1,0,54,5489,88,'Niebüll, Stadt',25899,30,9252,4443,4809,302),
	(1685,7,3,38,23,23,'Römerberg',67354,27,9251,4523,4728,332),
	(1686,15,0,84,130,130,'Elsteraue',6729,79,9244,4576,4668,116),
	(1687,5,5,66,88,88,'Tecklenburg, Stadt',49545,70,9225,4609,4616,131),
	(1688,12,0,62,92,92,'Doberlug-Kirchhain, Stadt',3253,148,9225,4549,4676,62),
	(1689,3,4,55,14,14,'Sande',26452,44,9224,4517,4707,206),
	(1690,1,0,60,92,92,'Wahlstedt, Stadt',23812,15,9211,4501,4710,585),
	(1691,5,3,70,32,32,'Waldfeucht',52525,30,9207,4584,4623,304),
	(1692,1,0,55,21,21,'Heiligenhafen, Stadt',23774,18,9196,4447,4749,502),
	(1693,8,3,16,5004,20,'Kenzingen, Stadt',79341,36,9196,4480,4716,249),
	(1694,6,5,34,21,21,'Wetter (Hessen), Stadt',35083,104,9194,4597,4597,88),
	(1695,6,4,32,1,1,'Alsbach-Hähnlein',64665,15,9187,4522,4665,582),
	(1696,9,7,75,139,139,'Elchingen',89275,24,9185,4483,4702,369),
	(1697,5,7,62,12,12,'Borgentreich, Stadt',34434,138,9182,4727,4455,66),
	(1698,3,4,59,5,5,'Bad Laer',49196,46,9181,4543,4638,196),
	(1699,7,1,41,5001,6,'Bad Ems, Stadt',56130,15,9179,4344,4835,598),
	(1700,9,6,75,5619,174,'Volkach, St',97332,60,9179,4592,4587,153),
	(1701,3,3,61,3,3,'Dörverden',27313,83,9177,4611,4566,110),
	(1702,9,1,72,134,134,'Teisendorf, M',83317,86,9162,4566,4596,106),
	(1703,15,0,91,20,20,'Bad Schmiedeberg, Stadt',6905,160,9162,4556,4606,57),
	(1704,5,9,58,16,16,'Eslohe (Sauerland)',59889,113,9157,4591,4566,81),
	(1705,3,4,61,4,4,'Elsfleth, Stadt',26931,115,9155,4673,4482,80),
	(1706,9,3,77,154,154,'Tirschenreuth, St',95643,103,9149,4377,4772,88),
	(1707,9,1,71,132,132,'Töging a.Inn, St',84513,13,9118,4364,4754,668),
	(1708,15,0,83,40,40,'Barleben',39179,29,9114,4523,4591,306),
	(1709,12,0,67,481,481,'Storkow (Mark), Stadt',15859,179,9111,4582,4529,51),
	(1710,6,4,40,19,19,'Ortenberg, Stadt',63683,54,9103,4468,4635,166),
	(1711,12,0,63,244,244,'Premnitz, Stadt',14727,45,9095,4393,4702,200),
	(1712,8,3,16,5005,12,'Endingen am Kaiserstuhl, Stadt',79346,26,9091,4440,4651,340),
	(1713,3,2,54,14,14,'Elze, Stadt',31008,47,9087,4428,4659,190),
	(1714,6,6,34,7,7,'Gudensberg, Stadt',34281,46,9076,4481,4595,195),
	(1715,8,3,17,141,141,'Willstätt',77731,55,9071,4509,4562,164),
	(1716,1,0,62,23,23,'Großhansdorf',22927,11,9070,4176,4894,810),
	(1717,9,5,71,165,165,'Heilsbronn, St',91560,62,9070,4424,4646,146),
	(1718,8,4,15,92,92,'Lichtenstein',72805,34,9050,4420,4630,264),
	(1719,6,4,38,7,7,'Mainhausen',63533,17,9049,4529,4520,505),
	(1720,6,5,33,18,18,'Weilmünster, Marktflecken',35789,77,9049,4418,4631,117),
	(1721,8,1,15,5001,1,'Aidlingen',71134,26,9046,4468,4578,341),
	(1722,9,3,72,126,126,'Furth im Wald, St',93437,67,9045,4474,4571,135),
	(1723,8,2,36,70,70,'Keltern',75210,29,9042,4374,4668,303),
	(1724,9,1,78,130,130,'Hallbergmoos',85399,35,9042,4678,4364,258),
	(1725,15,0,88,5012,365,'Teutschenthal',6179,53,9039,4479,4560,169),
	(1726,8,2,15,89,89,'Walzbachtal',75045,36,9033,4357,4676,246),
	(1727,15,0,88,150,150,'Kabelsketal',6184,50,9025,4568,4457,177),
	(1728,5,7,66,12,12,'Barntrup, Stadt',32683,59,9021,4393,4628,152),
	(1729,13,0,53,87,87,'Teterow, Stadt',17166,47,9012,4384,4628,191),
	(1730,5,3,58,60,60,'Vettweiß',52391,83,9007,4496,4511,108),
	(1731,5,5,54,60,60,'Südlohn',46354,45,9004,4462,4542,198),
	(1732,10,0,46,115,115,'Nonnweiler',66620,66,9001,4517,4484,135),
	(1733,16,0,65,3,3,'Bad Frankenhausen/Kyffhäuser, Stadt',6567,65,9000,4378,4622,137),
	(1734,6,4,32,21,21,'Schaafheim',64850,32,8977,4445,4532,279),
	(1735,15,0,84,235,235,'Hohenmölsen, Stadt',6679,63,8976,4359,4617,141),
	(1736,9,4,75,136,136,'Helmbrechts, St',95233,58,8975,4341,4634,153),
	(1737,14,5,22,230,230,'Hainichen, Stadt',9661,51,8972,4401,4571,174),
	(1738,7,3,39,5006,42,'Nieder-Olm, Stadt',55268,11,8967,4320,4647,798),
	(1739,9,1,77,139,139,'Taufkirchen (Vils)',84416,70,8962,4517,4445,128),
	(1740,8,2,26,5010,10,'Dielheim',69234,22,8958,4420,4538,395),
	(1741,14,5,24,5111,130,'Kirchberg, Stadt',8107,39,8953,4256,4697,226),
	(1742,15,0,88,5007,235,'Mücheln (Geiseltal), Stadt',6249,86,8945,4419,4526,103),
	(1743,5,7,66,60,60,'Schieder-Schwalenberg, Stadt',32816,60,8940,4376,4564,149),
	(1744,6,5,34,8,8,'Ebsdorfergrund',35085,72,8934,4405,4529,123),
	(1745,8,1,26,5005,69,'Pfedelbach',74629,41,8934,4429,4505,216),
	(1746,9,4,71,159,159,'Memmelsdorf',96117,26,8922,4420,4502,340),
	(1747,9,1,84,129,129,'Hohenbrunn',85662,16,8919,4387,4532,530),
	(1748,12,0,68,117,117,'Fehrbellin',16833,268,8917,4521,4396,33),
	(1749,12,0,63,273,273,'Schönwalde-Glien',14621,96,8910,4434,4476,92),
	(1750,1,0,55,42,42,'Timmendorfer Strand',23669,20,8906,4131,4775,443),
	(1751,9,3,71,113,113,'Auerbach i.d.OPf., St',91275,78,8904,4257,4647,114),
	(1752,12,0,66,320,320,'Vetschau/Spreewald, Stadt',3226,110,8903,4405,4498,81),
	(1753,3,1,53,8,8,'Liebenburg',38704,78,8887,4380,4507,113),
	(1754,9,7,80,143,143,'Waltenhofen',87448,59,8865,4401,4464,148),
	(1755,9,7,73,5718,182,'Wertingen, St',86637,51,8860,4385,4475,171),
	(1756,6,5,34,16,16,'Neustadt (Hessen), Stadt',35279,56,8853,4478,4375,156),
	(1757,9,1,75,139,139,'Zorneding',85604,23,8846,4358,4488,372),
	(1758,7,1,31,5003,6,'Bad Breisig, Stadt',53498,19,8836,4273,4563,443),
	(1759,9,3,75,175,175,'Nittendorf, M',93152,32,8836,4290,4546,268),
	(1760,9,6,76,121,121,'Elsenfeld, M',63820,24,8834,4377,4457,362),
	(1761,8,4,26,5006,87,'Ochsenhausen, Stadt',88416,59,8828,4377,4451,147),
	(1762,14,5,23,5107,120,'Falkenstein/Vogtl., Stadt',8223,31,8821,4149,4672,284),
	(1763,5,7,66,64,64,'Schlangen',33189,75,8819,4410,4409,116),
	(1764,12,0,62,124,124,'Elsterwerda, Stadt',4910,40,8817,4306,4511,217),
	(1765,6,4,34,9,9,'Schmitten',61389,35,8814,4389,4425,248),
	(1766,8,1,15,29,29,'Magstadt',71106,19,8804,4400,4404,460),
	(1767,9,1,76,139,139,'Kösching, M',85092,55,8796,4338,4458,158),
	(1768,12,0,69,454,454,'Nuthetal',14558,47,8796,4386,4410,185),
	(1769,6,4,31,3,3,'Biblis',68647,40,8787,4432,4355,217),
	(1770,7,1,32,5007,63,'Kirchen (Sieg), Stadt',57548,39,8781,4380,4401,222),
	(1771,6,4,37,13,13,'Reichelsheim (Odenwald)',64385,58,8777,4328,4449,151),
	(1772,14,7,29,430,430,'Zwenkau, Stadt',4442,46,8776,4287,4489,190),
	(1773,8,1,16,5005,20,'Frickenhausen',72636,11,8769,4370,4399,773),
	(1774,13,0,57,5726,9,'Barth, Stadt',18356,40,8768,4203,4565,215),
	(1775,12,0,64,29,29,'Altlandsberg, Stadt',15345,106,8757,4355,4402,82),
	(1776,8,3,15,5011,132,'March',79232,17,8752,4351,4401,492),
	(1777,6,4,36,10,10,'Liederbach am Taunus',65835,6,8731,4391,4340,1408),
	(1778,16,0,75,98,98,'Schleiz, Stadt',7907,83,8717,4255,4462,105),
	(1779,9,1,84,139,139,'Pullach i.Isartal',82049,7,8714,4147,4567,1178),
	(1780,3,4,52,7,7,'Großheide',26532,69,8712,4411,4301,126),
	(1781,12,0,61,332,332,'Mittenwalde, Stadt',15749,98,8710,4415,4295,88),
	(1782,3,3,52,5407,22,'Hemmoor, Stadt',21745,45,8694,4151,4543,193),
	(1783,5,3,58,16,16,'Hürtgenwald',52393,88,8685,4320,4365,99),
	(1784,8,1,35,32,32,'Steinheim am Albuch',89555,82,8676,4306,4370,105),
	(1785,5,7,54,4,4,'Borgholzhausen, Stadt',33829,55,8673,4251,4422,155),
	(1786,9,1,76,114,114,'Beilngries, St',92339,100,8673,4374,4299,87),
	(1787,12,0,66,52,52,'Calau, Stadt',3205,162,8666,4289,4377,53),
	(1788,6,6,33,8,8,'Fuldabrück',34277,17,8664,4253,4411,485),
	(1789,6,6,31,8,8,'Flieden',36103,49,8644,4304,4340,174),
	(1790,10,0,41,512,512,'Großrosseln',66352,25,8626,4081,4545,342),
	(1791,7,1,37,5004,69,'Mendig, Stadt',56743,23,8624,4235,4389,363),
	(1792,8,3,37,66,66,'Laufenburg (Baden), Stadt',79725,23,8623,4182,4441,366),
	(1793,6,4,40,7,7,'Florstadt, Stadt',61197,39,8621,4270,4351,218),
	(1794,3,3,60,5401,2,'Bad Bevensen, Stadt',29549,48,8620,3852,4768,179),
	(1795,6,4,31,19,19,'Rimbach',64668,23,8615,4222,4393,372),
	(1796,14,5,23,5134,430,'Treuen, Stadt',8233,43,8614,4189,4425,197),
	(1797,5,5,66,44,44,'Lienen',49536,73,8613,4334,4279,117),
	(1798,8,1,19,5002,76,'Urbach',73660,20,8612,4258,4354,415),
	(1799,9,2,72,120,120,'Grafenau, St',94481,63,8607,4270,4337,135),
	(1800,7,3,35,5005,22,'Landstuhl, Sickingenstadt, Stadt',66849,15,8599,4053,4546,561),
	(1801,9,6,76,145,145,'Obernburg a.Main, St',63785,24,8598,4269,4329,346),
	(1802,5,7,62,40,40,'Willebadessen, Stadt',34439,128,8590,4396,4194,67),
	(1803,5,1,70,40,40,'Sonsbeck',47665,55,8586,4150,4436,155),
	(1804,9,3,73,112,112,'Berching, St',92334,131,8580,4278,4302,65),
	(1805,12,0,68,353,353,'Rheinsberg, Stadt',16831,324,8579,4273,4306,26),
	(1806,12,0,63,56,56,'Dallgow-Döberitz',14624,65,8576,4343,4233,130),
	(1807,3,4,55,25,25,'Bockhorn',26345,77,8571,4264,4307,111),
	(1808,8,4,16,5001,15,'Gomaringen',72810,17,8570,4198,4372,495),
	(1809,14,6,28,5239,360,'Sebnitz, Stadt',1855,43,8568,4153,4415,195),
	(1810,6,6,31,11,11,'Großenlüder',36137,73,8567,4211,4356,116),
	(1811,14,7,29,5307,300,'Naunhof, Stadt',4683,39,8567,4215,4352,217),
	(1812,9,4,71,140,140,'Hallstadt, St',96103,14,8559,4168,4391,586),
	(1813,14,7,29,5301,10,'Bad Lausick, Stadt',4651,69,8553,4137,4416,123),
	(1814,8,2,35,65,65,'Schömberg',75328,37,8530,4244,4286,229),
	(1815,8,4,36,52,52,'Kißlegg',88353,92,8530,4226,4304,92),
	(1816,9,6,71,124,124,'Haibach',63808,7,8520,4121,4399,1158),
	(1817,9,3,73,126,126,'Freystadt, St',92342,80,8516,4360,4156,106),
	(1818,9,3,75,148,148,'Hemau, St',93155,122,8511,4320,4191,70),
	(1819,8,1,15,5006,48,'Waldenbuch, Stadt',71111,22,8510,4173,4337,375),
	(1820,9,7,79,5725,201,'Rain, St',86641,77,8507,4203,4304,110),
	(1821,8,1,25,5012,46,'Ilsfeld',74360,26,8500,4227,4273,321),
	(1822,1,0,62,61,61,'Reinfeld (Holstein), Stadt',23858,17,8499,4163,4336,490),
	(1823,14,5,22,5136,570,'Waldheim, Stadt',4736,23,8496,4273,4223,356),
	(1824,3,4,54,5408,49,'Spelle',48480,34,8489,4330,4159,248),
	(1825,7,3,39,9,9,'Budenheim',55257,10,8488,4200,4288,800),
	(1826,6,6,36,1,1,'Bad Sooden-Allendorf, Stadt',37242,73,8487,3998,4489,115),
	(1827,8,4,26,5002,14,'Bad Schussenried, Stadt',88427,55,8483,4195,4288,154),
	(1828,16,0,74,5014,41,'Hermsdorf, Stadt',7629,7,8479,4148,4331,1129),
	(1829,16,0,75,5050,73,'Neustadt an der Orla, Stadt',7806,30,8474,4146,4328,274),
	(1830,1,0,62,53,53,'Oststeinbek',22113,11,8466,4114,4352,745),
	(1831,9,1,71,117,117,'Garching a.d.Alz',84518,25,8463,4091,4372,327),
	(1832,7,3,34,5001,1,'Bellheim',76756,20,8461,4133,4328,414),
	(1833,9,2,75,124,124,'Bad Griesbach i.Rottal, St',94086,70,8448,4049,4399,120),
	(1834,15,0,82,5,5,'Aken (Elbe), Stadt',6385,59,8446,4115,4331,141),
	(1835,15,0,88,5002,25,'Bad Lauchstädt, Goethestadt',6246,68,8440,4170,4270,124),
	(1836,1,0,55,1,1,'Ahrensbök',23623,95,8437,4140,4297,88),
	(1837,14,5,23,5112,160,'Klingenthal, Stadt',8248,28,8432,4031,4401,294),
	(1838,9,1,71,125,125,'Neuötting, St',84524,36,8424,4010,4414,230),
	(1839,6,5,33,4,4,'Dornburg',65599,33,8413,4182,4231,253),
	(1840,5,5,54,24,24,'Heek',48619,69,8404,4252,4152,121),
	(1841,9,1,84,132,132,'Neuried',82061,9,8395,4105,4290,871),
	(1842,9,7,74,5730,143,'Ichenhausen, St',89335,34,8394,4176,4218,245),
	(1843,8,4,25,5004,31,'Dornstadt',89160,59,8393,4158,4235,142),
	(1844,10,0,46,111,111,'Freisen',66629,48,8393,4186,4207,175),
	(1845,6,4,36,12,12,'Sulzbach (Taunus)',65843,7,8391,4080,4311,1069),
	(1846,6,5,34,3,3,'Bad Endbach',35080,39,8382,4130,4252,210),
	(1847,7,3,34,5004,13,'Kandel, Stadt',76870,26,8379,4067,4312,315),
	(1848,3,2,55,8,8,'Delligsen, Flecken',31073,36,8371,4139,4232,232),
	(1849,9,5,74,157,157,'Schwarzenbruck',90592,22,8363,4116,4247,376),
	(1850,3,1,55,10,10,'Nörten-Hardenberg, Flecken',37176,54,8359,4120,4239,155),
	(1851,5,3,66,8,8,'Blankenheim',53945,148,8358,4137,4221,56),
	(1852,14,7,30,20,20,'Bad Düben, Stadt',4849,45,8356,4100,4256,184),
	(1853,5,3,66,20,20,'Hellenthal',53940,137,8351,4202,4149,61),
	(1854,8,4,37,5003,78,'Meßkirch, Stadt',88605,76,8351,4142,4209,110),
	(1855,9,3,76,149,149,'Nittenau, St',93149,93,8337,4128,4209,89),
	(1856,15,0,89,42,42,'Bördeland',39221,92,8336,4193,4143,90),
	(1857,7,1,37,5007,226,'Vallendar, Stadt',56179,13,8333,3879,4454,630),
	(1858,9,6,71,140,140,'Mainaschaff',63814,7,8332,4094,4238,1143),
	(1859,8,3,35,35,35,'Hilzingen',78247,53,8329,4072,4257,157),
	(1860,7,1,33,52,52,'Kirn, Stadt',55606,16,8324,4149,4175,504),
	(1861,6,4,35,3,3,'Biebergemünd',63599,78,8311,4128,4183,106),
	(1862,8,2,26,36,36,'Ilvesheim',68549,5,8311,4017,4294,1411),
	(1863,3,2,54,29,29,'Schellerten',31174,80,8307,4068,4239,104),
	(1864,5,7,66,24,24,'Dörentrup',32694,49,8304,4204,4100,167),
	(1865,15,0,88,5008,195,'Landsberg, Stadt',6188,63,8303,4183,4120,131),
	(1866,9,2,76,144,144,'Viechtach, St',94234,62,8295,4057,4238,133),
	(1867,8,1,19,5001,87,'Aspach',71546,35,8286,4099,4187,234),
	(1868,7,3,31,55,55,'Osthofen, Stadt',67574,18,8283,4045,4238,445),
	(1869,5,3,58,56,56,'Titz',52445,68,8274,4050,4224,121),
	(1870,5,1,54,56,56,'Uedem',47589,60,8260,4107,4153,135),
	(1871,8,1,16,5002,79,'Lenningen',73252,41,8259,4188,4071,199),
	(1872,3,4,53,6,6,'Essen (Oldenburg)',49632,98,8250,4367,3883,84),
	(1873,12,0,69,249,249,'Groß Kreutz (Havel)',14550,98,8248,4183,4065,83),
	(1874,3,1,51,5405,17,'Meinersen',38536,53,8247,4125,4122,153),
	(1875,8,3,36,14,14,'Efringen-Kirchen',79588,43,8247,4111,4136,189),
	(1876,8,2,26,5006,54,'Mühlhausen',69242,15,8238,4116,4122,538),
	(1877,6,5,32,15,15,'Lahnau',35633,23,8235,4069,4166,344),
	(1878,5,3,34,24,24,'Roetgen',52159,39,8225,4042,4183,211),
	(1879,5,5,54,52,52,'Schöppingen',48624,68,8224,4534,3690,120),
	(1880,14,7,29,60,60,'Borsdorf',4451,15,8224,3992,4232,528),
	(1881,1,0,57,5782,25,'Heikendorf',24226,14,8222,3855,4367,559),
	(1882,3,1,55,5,5,'Hardegsen, Stadt',37181,83,8222,4027,4195,98),
	(1883,14,6,27,150,150,'Moritzburg',1468,46,8219,4102,4117,177),
	(1884,7,2,33,5001,501,'Daun, Stadt',54550,48,8217,4039,4178,168),
	(1885,9,5,74,156,156,'Schwaig b.Nürnberg',90571,5,8214,3890,4324,1392),
	(1886,12,0,67,36,36,'Beeskow, Stadt',15848,77,8206,4006,4200,106),
	(1887,3,3,54,5406,4,'Dannenberg (Elbe), Stadt',29451,76,8204,4069,4135,107),
	(1888,7,1,32,5008,117,'Wissen, Stadt',57537,34,8204,4005,4199,235),
	(1889,8,1,18,21,21,'Großbottwar, Stadt',71723,25,8200,4133,4067,321),
	(1890,14,5,24,250,250,'Reinsdorf',8141,21,8200,4035,4165,387),
	(1891,9,3,75,208,208,'Wenzenbach',93173,29,8199,4166,4033,275),
	(1892,3,1,51,5406,16,'Meine',38527,38,8198,4070,4128,212),
	(1893,9,1,88,113,113,'Berg',82335,36,8180,3962,4218,223),
	(1894,8,4,16,23,23,'Kusterdingen',72127,24,8172,4048,4124,337),
	(1895,9,6,77,114,114,'Arnstein, St',97450,112,8167,4108,4059,73),
	(1896,3,3,51,13,13,'Hermannsburg',29320,118,8165,4039,4126,69),
	(1897,15,0,85,145,145,'Harzgerode, Stadt',6493,150,8159,4124,4035,54),
	(1898,3,1,52,26,26,'Staufenberg',34355,77,8157,3980,4177,105),
	(1899,14,7,29,170,170,'Groitzsch, Stadt',4539,70,8155,4017,4138,116),
	(1900,9,4,75,156,156,'Naila, St',95119,37,8148,3862,4286,220),
	(1901,8,1,25,5007,63,'Möckmühl, Stadt',74219,49,8147,4164,3983,164),
	(1902,6,5,31,17,17,'Staufenberg, Stadt',35460,28,8142,4016,4126,289),
	(1903,8,3,36,5001,45,'Kandern, Stadt',79400,62,8130,3898,4232,131),
	(1904,9,6,71,136,136,'Kleinostheim',63801,13,8130,4019,4111,585),
	(1905,13,0,52,5223,50,'Malchin, Stadt',17139,94,8128,3978,4150,86),
	(1906,5,5,54,28,28,'Heiden',46359,53,8124,4108,4016,152),
	(1907,9,6,71,114,114,'Karlstein a.Main',63791,12,8120,3976,4144,641),
	(1908,14,6,26,80,80,'Ebersbach/Sa., Stadt',2730,14,8108,3887,4221,545),
	(1909,9,1,82,119,119,'Hausham',83734,22,8105,3903,4202,364),
	(1910,9,5,76,113,113,'Allersberg, M',90584,59,8103,3999,4104,136),
	(1911,8,4,35,5001,29,'Kressbronn am Bodensee',88079,20,8100,3983,4117,396),
	(1912,6,5,33,14,14,'Selters (Taunus)',65618,40,8095,4089,4006,200),
	(1913,12,0,65,198,198,'Löwenberger Land',16775,244,8093,4099,3994,33),
	(1914,3,3,51,23,23,'Wietze',29323,62,8088,4002,4086,128),
	(1915,8,1,36,45,45,'Neresheim, Stadt',73450,118,8063,4061,4002,68),
	(1916,5,7,54,24,24,'Langenberg',33449,38,8060,4043,4017,210),
	(1917,8,3,17,5014,146,'Zell am Harmersbach, Stadt',77736,36,8045,3983,4062,221),
	(1918,9,3,76,147,147,'Neunburg vorm Wald, St',92431,110,8045,4049,3996,73),
	(1919,3,2,54,3,3,'Algermissen',31191,35,8030,3972,4058,225),
	(1920,8,2,37,5001,19,'Dornstetten, Stadt',72280,24,8026,3966,4060,332),
	(1921,3,2,54,32,32,'Söhlde',31185,57,8022,3982,4040,140),
	(1922,6,6,36,11,11,'Sontra, Stadt',36205,111,8017,4075,3942,72),
	(1923,9,5,74,155,155,'Schnaittach, M',91220,49,8012,3936,4076,162),
	(1924,8,2,16,8,8,'Bühlertal',77830,17,8011,3992,4019,453),
	(1925,8,1,15,5002,13,'Ehningen',71139,17,8005,3994,4011,450),
	(1926,6,6,33,1,1,'Ahnatal',34292,18,8004,3915,4089,444),
	(1927,9,4,76,146,146,'Küps, M',96328,35,8004,3968,4036,225),
	(1928,6,4,39,5,5,'Heidenrod',65321,95,7991,4023,3968,83),
	(1929,15,0,85,185,185,'Huy',38838,167,7990,3980,4010,48),
	(1930,9,4,74,154,154,'Neunkirchen a.Brand, M',91077,26,7982,3924,4058,302),
	(1931,6,5,33,6,6,'Elz',65604,16,7981,3871,4110,473),
	(1932,8,2,35,5002,7,'Althengstett',75382,19,7976,3971,4005,416),
	(1933,9,7,78,5757,186,'Ottobeuren, M',87724,56,7966,3947,4019,142),
	(1934,3,4,59,5402,10,'Bersenbrück, Stadt',49593,42,7964,3931,4033,187),
	(1935,3,4,60,7,7,'Neuenkirchen-Vörden',49434,90,7962,3987,3975,88),
	(1936,5,9,58,28,28,'Medebach, Stadt',59964,126,7961,3969,3992,63),
	(1937,8,4,35,5004,66,'Uhldingen-Mühlhofen',88690,15,7950,3891,4059,508),
	(1938,9,1,89,145,145,'Siegsdorf',83313,56,7948,3827,4121,139),
	(1939,12,0,60,280,280,'Werneuchen, Stadt',16356,116,7943,4007,3936,68),
	(1940,5,5,66,96,96,'Wettringen',48493,57,7926,4039,3887,138),
	(1941,14,5,22,250,250,'Hartha, Stadt',4746,54,7924,3839,4085,146),
	(1942,12,0,69,632,632,'Treuenbrietzen, Stadt',14929,211,7911,3889,4022,37),
	(1943,8,2,26,5006,65,'Rauenberg, Stadt',69231,11,7905,3925,3980,711),
	(1944,8,1,36,50,50,'Oberkochen, Stadt',73447,23,7904,3864,4040,335),
	(1945,9,6,78,174,174,'Schonungen',97453,81,7901,3976,3925,98),
	(1946,9,7,77,159,159,'Pfronten',87459,62,7898,3802,4096,127),
	(1947,1,0,61,5189,49,'Kellinghusen, Stadt',25548,18,7893,3844,4049,420),
	(1948,12,0,67,201,201,'Grünheide (Mark)',15537,125,7885,3882,4003,63),
	(1949,9,6,78,160,160,'Niederwerrn',97464,9,7879,3816,4063,806),
	(1950,8,1,18,60,60,'Oberstenfeld',71720,21,7867,3931,3936,373),
	(1951,9,7,80,119,119,'Dietmannsried, M',87463,53,7867,3898,3969,147),
	(1952,12,0,63,357,357,'Wustermark',14641,52,7856,3919,3937,149),
	(1953,5,1,54,60,60,'Wachtendonk',47669,48,7829,3897,3932,163),
	(1954,8,1,17,5003,42,'Salach',73084,8,7827,3843,3984,941),
	(1955,9,1,87,128,128,'Bad Endorf, M',83093,40,7826,3789,4037,195),
	(1956,8,1,16,5007,58,'Reichenbach an der Fils',73262,7,7817,3859,3958,1052),
	(1957,7,3,39,5007,43,'Nierstein',55283,19,7810,3816,3994,404),
	(1958,9,5,71,180,180,'Neuendettelsau',91564,33,7809,3591,4218,231),
	(1959,9,6,72,135,135,'Münnerstadt, St',97702,93,7803,3984,3819,84),
	(1960,9,5,72,131,131,'Heroldsberg, M',90562,11,7801,3766,4035,705),
	(1961,7,3,34,5006,25,'Rülzheim',76761,16,7796,3819,3977,468),
	(1962,12,0,67,544,544,'Woltersdorf',15569,9,7791,3881,3910,854),
	(1963,8,3,17,5010,47,'Hohberg',77749,28,7784,3829,3955,269),
	(1964,16,0,76,5053,79,'Weida, Stadt',7570,12,7780,3772,4008,618),
	(1965,6,6,34,4,4,'Frielendorf',34621,85,7778,3876,3902,91),
	(1966,8,4,35,5001,30,'Langenargen',88085,15,7777,3821,3956,509),
	(1967,12,0,65,36,36,'Birkenwerder',16547,18,7774,3871,3903,430),
	(1968,5,3,66,32,32,'Nettersheim',53947,94,7771,3863,3908,82),
	(1969,15,0,89,195,195,'Könnern, Stadt',6420,98,7756,3855,3901,79),
	(1970,8,1,25,5012,98,'Untergruppenbach',74199,27,7753,3829,3924,284),
	(1971,9,6,79,180,180,'Rimpar, M',97222,36,7752,3824,3928,213),
	(1972,1,0,55,16,16,'Grömitz',23743,51,7749,3689,4060,152),
	(1973,7,3,33,5004,39,'Kirchheimbolanden, Stadt',67292,26,7749,3726,4023,294),
	(1974,3,1,56,3,3,'Bad Sachsa, Stadt',37441,33,7745,3756,3989,234),
	(1975,8,3,15,5010,70,'Löffingen, Stadt',79843,88,7745,3872,3873,88),
	(1976,14,6,25,5231,450,'Pulsnitz, Stadt',1896,26,7743,3785,3958,290),
	(1977,1,0,54,5489,76,'Leck',25917,29,7736,3767,3969,260),
	(1978,8,2,16,5001,24,'Kuppenheim, Stadt',76456,18,7736,3840,3896,428),
	(1979,7,1,37,5008,228,'Weißenthurm, Stadt',56575,3,7734,3837,3897,1938),
	(1980,13,0,53,5311,13,'Bützow, Stadt',18246,39,7732,3777,3955,195),
	(1981,9,2,75,122,122,'Fürstenzell, M',94081,79,7727,3766,3961,97),
	(1982,8,4,26,134,134,'Schemmerhofen',88433,50,7726,3863,3863,154),
	(1983,8,2,37,45,45,'Loßburg',72290,79,7722,3895,3827,97),
	(1984,9,7,73,5713,136,'Gundelfingen a.d.Donau, St',89423,54,7715,3799,3916,143),
	(1985,8,1,19,5003,86,'Winterbach',73650,17,7714,3677,4037,450),
	(1986,14,5,22,330,330,'Lichtenau',9244,49,7712,3827,3885,157),
	(1987,12,0,64,512,512,'Wriezen, Stadt',16269,94,7703,3856,3847,81),
	(1988,9,6,72,117,117,'Burkardroth, M',97705,69,7691,3823,3868,111),
	(1989,8,2,15,5003,21,'Forst',76694,11,7686,3833,3853,670),
	(1990,9,4,71,195,195,'Strullendorf',96129,31,7686,3783,3903,242),
	(1991,7,3,38,1,1,'Altrip',67122,10,7685,3777,3908,733),
	(1992,1,0,62,5270,82,'Trittau',22946,28,7679,3727,3952,269),
	(1993,7,1,40,5007,144,'Simmern/ Hunsrück, Stadt',55469,11,7667,3662,4005,641),
	(1994,8,3,26,5001,27,'Hüfingen, Stadt',78183,58,7667,3850,3817,131),
	(1995,14,5,23,170,170,'Lengenfeld, Stadt',8485,47,7667,3782,3885,163),
	(1996,12,0,61,444,444,'Schulzendorf',15732,9,7662,3850,3812,842),
	(1997,9,3,75,179,179,'Obertraubling',93083,24,7661,3795,3866,308),
	(1998,14,6,27,220,220,'Radeburg, Stadt',1471,54,7661,3806,3855,142),
	(1999,9,3,74,162,162,'Vohenstrauß, St',92648,74,7659,3753,3906,103),
	(2000,6,5,35,9,9,'Homberg (Ohm), Stadt',35315,88,7654,3884,3770,87),
	(2001,3,4,61,9,9,'Stadland',26935,113,7653,3857,3796,67),
	(2002,7,3,37,5002,5,'Bad Bergzabern, Stadt',76887,10,7652,3626,4026,714),
	(2003,3,3,56,2,2,'Grasberg',28879,55,7641,3785,3856,138),
	(2004,5,5,66,20,20,'Hopsten',48496,99,7639,3903,3736,77),
	(2005,7,3,31,5006,73,'Wörrstadt, Stadt',55286,16,7635,3706,3929,456),
	(2006,8,1,16,76,76,'Aichwald',73773,14,7632,3698,3934,520),
	(2007,14,5,22,5121,440,'Oederan, Stadt',9569,55,7632,3693,3939,137),
	(2008,8,3,15,5016,108,'Staufen im Breisgau, Stadt',79219,23,7627,3570,4057,328),
	(2009,9,5,71,166,166,'Herrieden, St',91567,81,7622,3781,3841,93),
	(2010,6,5,31,7,7,'Heuchelheim',35452,10,7620,3758,3862,720),
	(2011,9,2,74,176,176,'Rottenburg a.d.Laaber, St',84056,90,7610,3818,3792,84),
	(2012,8,2,36,33,33,'Knittlingen, Stadt',75438,26,7604,3716,3888,289),
	(2013,8,1,15,5005,53,'Jettingen',71131,21,7594,3747,3847,360),
	(2014,9,1,88,127,127,'Krailling',82152,15,7589,3557,4032,475),
	(2015,3,4,53,12,12,'Molbergen',49696,102,7587,3873,3714,74),
	(2016,8,3,27,5004,2,'Aldingen',78554,22,7585,3781,3804,342),
	(2017,9,2,71,125,125,'Hengersberg, M',94491,45,7583,3763,3820,166),
	(2018,8,2,36,5005,43,'Neuenbürg, Stadt',75305,28,7582,3718,3864,269),
	(2019,8,1,18,5003,10,'Bönnigheim, Stadt',74357,20,7579,3726,3853,376),
	(2020,6,4,40,9,9,'Gedern, Stadt',63688,75,7578,3715,3863,101),
	(2021,6,6,32,9,9,'Heringen (Werra), Stadt',36266,61,7568,3832,3736,124),
	(2022,3,4,53,2,2,'Bösel',26219,100,7560,3839,3721,76),
	(2023,16,0,71,3,3,'Bad Berka, Stadt',99438,55,7559,3697,3862,137),
	(2024,15,0,89,5009,175,'Hecklingen, Stadt',39444,95,7552,3716,3836,79),
	(2025,15,0,91,5006,110,'Gräfenhainichen, Stadt',6773,66,7550,3675,3875,114),
	(2026,3,4,54,45,45,'Salzbergen',48499,53,7548,3775,3773,141),
	(2027,3,4,57,24,24,'Bunde',26831,121,7548,3764,3784,62),
	(2028,3,2,52,4,4,'Coppenbrügge, Flecken',31863,89,7546,3714,3832,84),
	(2029,9,2,79,134,134,'Reisbach, M',94419,94,7543,3819,3724,80),
	(2030,9,1,72,116,116,'Berchtesgaden, M',83471,34,7536,3640,3896,217),
	(2031,8,3,37,5007,65,'Lauchringen',79787,12,7534,3680,3854,590),
	(2032,9,3,73,113,113,'Berg b.Neumarkt i.d.OPf.',92348,65,7534,3811,3723,116),
	(2033,9,1,80,123,123,'Mittenwald, M',82481,132,7530,3778,3752,57),
	(2034,8,1,28,126,126,'Weikersheim, Stadt',97990,80,7510,3682,3828,93),
	(2035,7,3,35,5008,38,'Ramstein-Miesenbach, Stadt',66877,43,7508,3700,3808,175),
	(2036,6,6,33,5,5,'Calden',34379,54,7503,3753,3750,137),
	(2037,8,1,25,5006,74,'Nordheim',74226,12,7502,3714,3788,590),
	(2038,9,1,86,5158,147,'Reichertshofen, M',85084,36,7502,3744,3758,203),
	(2039,15,0,85,5001,40,'Ballenstedt, Stadt',6493,57,7502,3651,3851,132),
	(2040,9,1,72,117,117,'Bischofswiesen',83483,34,7496,3567,3929,218),
	(2041,3,3,52,40,40,'Nordholz',27637,65,7495,3852,3643,115),
	(2042,7,2,33,5002,26,'Gerolstein, Stadt',54568,64,7492,3621,3871,116),
	(2043,3,3,61,5401,13,'Thedinghausen',27321,65,7484,3750,3734,114),
	(2044,9,1,87,129,129,'Bad Feilnbach',83075,57,7483,3715,3768,130),
	(2045,16,0,67,19,19,'Friedrichroda, Stadt',99894,36,7475,3601,3874,203),
	(2046,6,6,31,7,7,'Eiterfeld',36132,89,7465,3700,3765,83),
	(2047,1,0,58,5889,22,'Bordesholm',24582,10,7462,3658,3804,734),
	(2048,8,1,15,52,52,'Weissach',71287,22,7458,3700,3758,336),
	(2049,9,1,84,112,112,'Aschheim',85609,28,7454,3677,3777,266),
	(2050,9,2,74,5220,127,'Ergoldsbach, M',84061,57,7448,3669,3779,131),
	(2051,12,0,66,285,285,'Schipkau',1998,68,7442,3727,3715,108),
	(2052,3,2,56,32,32,'Stolzenau',31592,64,7435,3648,3787,115),
	(2053,6,6,34,25,25,'Wabern',34590,51,7430,3701,3729,145),
	(2054,1,0,51,5175,74,'Meldorf, Stadt',25704,21,7425,3624,3801,349),
	(2055,8,1,36,2,2,'Abtsgmünd',73453,71,7421,3663,3758,104),
	(2056,3,3,53,5404,20,'Jesteburg',21266,27,7416,3504,3912,265),
	(2057,9,1,74,111,111,'Altomünster, M',85250,75,7414,3693,3721,98),
	(2058,15,0,83,390,390,'Niedere Börde',39326,77,7411,3758,3653,95),
	(2059,6,4,32,6,6,'Erzhausen',64390,7,7409,3661,3748,1001),
	(2060,10,0,42,115,115,'Perl',66706,75,7405,3619,3786,99),
	(2061,7,1,43,5005,62,'Ransbach-Baumbach, Stadt',56235,12,7403,3639,3764,610),
	(2062,3,2,54,22,22,'Holle',31188,61,7401,3653,3748,121),
	(2063,12,0,72,120,120,'Großbeeren',14979,51,7397,3738,3659,142),
	(2064,8,2,35,5003,33,'Bad Herrenalb, Stadt',76332,33,7389,3524,3865,224),
	(2065,8,1,18,5006,27,'Hemmingen',71282,12,7372,3659,3713,597),
	(2066,9,3,76,170,170,'Teublitz, St',93158,38,7367,3674,3693,193),
	(2067,9,7,72,171,171,'Langweid a.Lech',86462,23,7362,3669,3693,312),
	(2068,9,5,76,132,132,'Schwanstetten, M',90596,32,7361,3556,3805,227),
	(2069,8,3,37,62,62,'Klettgau',79771,45,7360,3650,3710,160),
	(2070,9,6,71,155,155,'Stockstadt a.Main, M',63811,18,7355,3727,3628,390),
	(2071,9,4,75,168,168,'Schwarzenbach a.d.Saale, St',95126,59,7352,3526,3826,124),
	(2072,6,4,35,11,11,'Großkrotzenburg',63538,7,7347,3597,3750,986),
	(2073,1,0,58,5830,53,'Flintbek',24220,17,7346,3562,3784,418),
	(2074,3,4,59,6,6,'Bad Rothenfelde',49214,18,7346,3453,3893,403),
	(2075,3,1,55,7,7,'Katlenburg-Lindau',37191,71,7345,3672,3673,103),
	(2076,7,3,35,5001,3,'Bruchmühlbach-Miesau',66892,26,7341,3546,3795,273),
	(2077,6,4,35,15,15,'Hasselroth',63594,18,7329,3606,3723,387),
	(2078,9,3,73,155,155,'Postbauer-Heng, M',92353,24,7328,3668,3660,297),
	(2079,9,3,72,137,137,'Bad Kötzting, St',93444,62,7323,3611,3712,118),
	(2080,9,6,74,5611,130,'Ebern, St',96106,95,7319,3649,3670,77),
	(2081,8,3,17,5009,110,'Renchen, Stadt',77871,32,7315,3634,3681,228),
	(2082,9,5,77,161,161,'Pleinfeld, M',91785,71,7309,3587,3722,102),
	(2083,5,9,62,20,20,'Herscheid',58849,58,7307,3560,3747,124),
	(2084,6,6,34,17,17,'Neukirchen, Stadt',34626,66,7298,3604,3694,110),
	(2085,8,3,37,2,2,'Albbruck',79774,39,7292,3677,3615,184),
	(2086,9,6,71,134,134,'Kahl a.Main',63796,10,7285,3550,3735,685),
	(2087,10,0,46,113,113,'Namborn',66640,26,7284,3584,3700,280),
	(2088,7,3,40,5004,38,'Rodalben, Stadt',66976,15,7283,3606,3677,464),
	(2089,6,6,34,2,2,'Edermünde',34295,25,7274,3629,3645,282),
	(2090,14,6,25,560,560,'Sohland a. d. Spree',2689,37,7274,3614,3660,195),
	(2091,8,2,25,5001,32,'Hardheim',74736,87,7272,3680,3592,84),
	(2092,13,0,51,89,89,'Dummerstorf',18196,119,7264,3819,3445,61),
	(2093,6,4,37,4,4,'Breuberg, Stadt',64747,30,7263,3544,3719,236),
	(2094,9,5,72,115,115,'Baiersdorf, St',91083,11,7259,3604,3655,615),
	(2095,8,2,37,5005,54,'Pfalzgrafenweiler',72285,44,7257,3551,3706,162),
	(2096,16,0,74,44,44,'Kahla, Stadt',7768,7,7255,3571,3684,911),
	(2097,12,0,62,128,128,'Falkenberg/Elster, Stadt',4895,81,7254,3572,3682,89),
	(2098,10,0,44,122,122,'Bous',66359,7,7252,3459,3793,953),
	(2099,15,0,86,35,35,'Elbe-Parey',39317,108,7252,3579,3673,67),
	(2100,9,6,78,123,123,'Dittelbrunn',97456,23,7248,3612,3636,304),
	(2101,14,6,27,5210,50,'Gröditz, Stadt',1609,8,7244,3548,3696,859),
	(2102,5,9,70,12,12,'Erndtebrück',57339,70,7243,3650,3593,102),
	(2103,6,6,35,21,21,'Waldeck, Stadt',34513,115,7233,3653,3580,62),
	(2104,5,5,66,80,80,'Saerbeck',48369,59,7231,3591,3640,123),
	(2105,9,7,80,132,132,'Oberstaufen, M',87534,125,7225,3402,3823,57),
	(2106,8,1,25,39,39,'Gundelsheim, Stadt',74831,38,7223,3568,3655,188),
	(2107,8,3,15,5004,131,'Ehrenkirchen',79238,37,7221,3597,3624,191),
	(2108,9,3,75,196,196,'Schierling, M',84069,77,7218,3596,3622,93),
	(2109,7,3,39,5005,27,'Heidesheim am Rhein',55262,17,7202,3575,3627,410),
	(2110,9,4,72,119,119,'Bindlach',95463,37,7194,3447,3747,191),
	(2111,14,6,28,130,130,'Glashütte, Stadt',1768,95,7189,3604,3585,75),
	(2112,3,1,55,9,9,'Moringen, Stadt',37186,82,7187,3644,3543,87),
	(2113,14,5,21,5115,380,'Lugau/Erzgeb., Stadt',9385,6,7187,3498,3689,1137),
	(2114,14,6,27,180,180,'Nossen, Stadt',1683,50,7184,3475,3709,142),
	(2115,9,5,72,111,111,'Adelsdorf',91325,31,7180,3618,3562,227),
	(2116,12,0,64,317,317,'Müncheberg, Stadt',15374,151,7177,3657,3520,47),
	(2117,8,2,36,28,28,'Illingen',75428,29,7174,3542,3632,244),
	(2118,16,0,73,5,5,'Bad Blankenburg, Stadt',7422,35,7173,3487,3686,202),
	(2119,9,1,74,113,113,'Bergkirchen',85232,59,7169,3578,3591,120),
	(2120,8,1,35,25,25,'Königsbronn',89551,45,7167,3543,3624,158),
	(2121,8,4,25,108,108,'Schelklingen, Stadt',89601,75,7166,3652,3514,95),
	(2122,3,4,59,5402,2,'Ankum',49577,66,7165,3576,3589,108),
	(2123,8,4,36,5005,11,'Baienfurt',88255,16,7158,3529,3629,447),
	(2124,7,3,31,5006,58,'Saulheim',55291,18,7154,3595,3559,378),
	(2125,9,1,86,158,158,'Vohburg a.d.Donau, St',85088,45,7150,3631,3519,158),
	(2126,13,0,51,42,42,'Kühlungsborn, Stadt',18225,16,7144,3374,3770,442),
	(2127,8,2,26,5004,68,'Reilingen',68799,16,7142,3496,3646,437),
	(2128,8,1,19,1,1,'Alfdorf',73553,68,7136,3589,3547,104),
	(2129,8,1,36,5007,79,'Waldstetten',73550,20,7133,3522,3611,340),
	(2130,8,3,35,5004,2,'Allensbach',78476,26,7132,3253,3879,269),
	(2131,8,3,17,5010,122,'Schutterwald',77746,21,7127,3625,3502,339),
	(2132,7,3,38,20,20,'Neuhofen',67141,12,7126,3529,3597,579),
	(2133,9,2,75,138,138,'Ortenburg, M',94496,60,7126,3546,3580,117),
	(2134,12,0,65,165,165,'Kremmen, Stadt',16766,209,7124,3586,3538,34),
	(2135,15,0,90,225,225,'Havelberg, Hansestadt',39539,149,7124,3570,3554,48),
	(2136,3,4,52,11,11,'Hinte',26759,48,7123,3522,3601,148),
	(2137,6,4,31,14,14,'Lautertal (Odenwald)',64686,30,7117,3482,3635,231),
	(2138,3,4,61,6,6,'Lemwerder',27809,36,7115,3576,3539,196),
	(2139,7,3,39,5002,6,'Bodenheim',55294,13,7111,3454,3657,529),
	(2140,3,3,52,5405,46,'Otterndorf, Stadt',21762,33,7110,3446,3664,212),
	(2141,9,1,87,118,118,'Bernau a.Chiemsee',83233,26,7102,3941,3161,266),
	(2142,7,3,39,5007,49,'Oppenheim, Stadt',55276,7,7098,3379,3719,1001),
	(2143,8,1,19,5001,83,'Weissach im Tal',71554,14,7096,3490,3606,502),
	(2144,6,5,32,10,10,'Greifenstein',35753,67,7092,3519,3573,105),
	(2145,14,5,21,560,560,'Sehmatal',9465,44,7082,3517,3565,159),
	(2146,6,5,34,6,6,'Cölbe',35091,26,7080,3571,3509,266),
	(2147,9,1,88,132,132,'Seefeld',82229,34,7077,3421,3656,203),
	(2148,9,3,77,158,158,'Waldsassen, St',95652,66,7075,3437,3638,106),
	(2149,3,4,54,5407,47,'Sögel',49751,55,7073,3632,3441,128),
	(2150,9,4,71,185,185,'Scheßlitz, St',96110,94,7071,3558,3513,75),
	(2151,15,0,83,5006,410,'Oebisfelde, Stadt',39646,95,7070,3529,3541,74),
	(2152,14,5,23,360,360,'Rodewisch, Stadt',8228,26,7065,3427,3638,263),
	(2153,6,5,33,15,15,'Villmar',65606,43,7064,3483,3581,164),
	(2154,6,4,37,10,10,'Lützelbach',64750,35,7063,3566,3497,199),
	(2155,9,5,76,122,122,'Greding, St',91171,103,7061,3568,3493,68),
	(2156,12,0,61,217,217,'Heidesee',15754,134,7058,3545,3513,52),
	(2157,14,5,21,410,410,'Neukirchen/Erzgeb.',9221,20,7055,3490,3565,351),
	(2158,3,3,55,5404,31,'Reppenstedt',21391,14,7052,3397,3655,477),
	(2159,8,4,15,91,91,'Sonnenbühl',72820,61,7042,3527,3515,115),
	(2160,9,2,75,145,145,'Ruhstorf a.d.Rott, M',94099,51,7029,3491,3538,137),
	(2161,8,1,28,5002,14,'Boxberg, Stadt',97944,101,7027,3491,3536,69),
	(2162,7,3,38,5004,18,'Maxdorf',67133,7,7025,3393,3632,956),
	(2163,6,6,33,14,14,'Immenhausen, Stadt',34376,28,7022,3457,3565,246),
	(2164,14,5,22,5127,510,'Roßwein, Stadt',4741,29,7022,3366,3656,241),
	(2165,9,1,87,137,137,'Großkarolinenfeld',83109,29,7011,3458,3553,241),
	(2166,7,3,35,5002,4,'Enkenbach-Alsenborn',67677,30,7010,3376,3634,233),
	(2167,7,3,34,5003,12,'Jockgrim',76751,12,7009,3525,3484,556),
	(2168,6,5,34,12,12,'Lahntal',35094,40,7007,3476,3531,173),
	(2169,7,1,38,5001,3,'Asbach',53567,38,7003,3516,3487,181),
	(2170,9,3,72,171,171,'Waldmünchen, St',93449,101,7003,3438,3565,69),
	(2171,8,3,16,5002,10,'Elzach, Stadt',79215,75,7002,3466,3536,93),
	(2172,9,2,72,118,118,'Freyung, St',94078,48,6996,3366,3630,144),
	(2173,8,3,17,5004,40,'Haslach im Kinzigtal, Stadt',77716,18,6992,3410,3582,374),
	(2174,3,1,55,8,8,'Kreiensen',37547,65,6990,3406,3584,107),
	(2175,9,1,87,179,179,'Tuntenhausen',83104,68,6986,3541,3445,101),
	(2176,9,7,75,5739,143,'Pfaffenhofen a.d.Roth, M',89284,42,6981,3568,3413,164),
	(2177,14,5,21,620,620,'Thalheim/Erzgeb., Stadt',9380,10,6978,3427,3551,646),
	(2178,3,3,58,4,4,'Bomlitz',29699,64,6973,3427,3546,109),
	(2179,9,1,84,141,141,'Sauerlach',82054,48,6968,3518,3450,144),
	(2180,9,6,75,117,117,'Dettelbach, St',97337,60,6957,3439,3518,114),
	(2181,7,3,38,5001,6,'Dannstadt-Schauernheim',67125,15,6955,3436,3519,456),
	(2182,6,5,34,20,20,'Weimar (Lahn)',35096,47,6943,3385,3558,148),
	(2183,7,1,32,50,50,'Herdorf, Stadt',57562,18,6942,3431,3511,385),
	(2184,3,4,62,5401,3,'Esens, Stadt',26427,21,6941,3203,3738,320),
	(2185,9,6,73,141,141,'Bad Königshofen i.Grabfeld, St',97631,69,6938,3414,3524,100),
	(2186,6,6,36,4,4,'Großalmerode, Stadt',37247,37,6937,3389,3548,184),
	(2187,3,1,55,6,6,'Kalefeld',37589,84,6928,3484,3444,82),
	(2188,8,1,19,5001,6,'Auenwald',71549,19,6925,3429,3496,350),
	(2189,14,6,25,5213,200,'Großröhrsdorf, Stadt',1900,26,6918,3382,3536,262),
	(2190,3,4,61,1,1,'Berne',27804,85,6917,3471,3446,81),
	(2191,3,3,51,10,10,'Faßberg',29328,101,6914,3678,3236,68),
	(2192,9,6,76,160,160,'Sulzbach a.Main, M',63834,19,6910,3446,3464,346),
	(2193,10,0,45,113,113,'Gersheim',66453,57,6910,3412,3498,120),
	(2194,14,7,29,40,40,'Böhlen, Stadt',4564,24,6899,3417,3482,281),
	(2195,8,3,37,5001,22,'Bonndorf im Schwarzwald, Stadt',79848,75,6895,3422,3473,91),
	(2196,9,3,77,5347,141,'Mitterteich, St',95666,39,6893,3367,3526,175),
	(2197,3,4,56,5401,2,'Emlichheim',49824,48,6890,3436,3454,142),
	(2198,13,0,56,5619,41,'Malchow, Stadt',17213,44,6886,3402,3484,154),
	(2199,7,3,37,5001,501,'Annweiler am Trifels, Stadt',76855,39,6885,3376,3509,173),
	(2200,9,5,76,137,137,'Rednitzhembach',91126,13,6880,3319,3561,528),
	(2201,5,3,58,20,20,'Inden',52459,35,6875,3370,3505,191),
	(2202,9,3,75,199,199,'Sinzing',93161,44,6874,3419,3455,156),
	(2203,12,0,72,312,312,'Nuthe-Urstromtal',14947,337,6869,3487,3382,20),
	(2204,6,6,35,20,20,'Volkmarsen, Stadt',34471,67,6855,3392,3463,102),
	(2205,9,6,72,113,113,'Bad Brückenau, St',97769,23,6852,3258,3594,289),
	(2206,8,1,25,7,7,'Bad Wimpfen, Stadt',74206,19,6850,3368,3482,353),
	(2207,14,5,24,170,170,'Lichtentanne',8115,27,6848,3297,3551,251),
	(2208,3,2,51,44,44,'Wagenfeld',49419,117,6846,3363,3483,58),
	(2209,6,5,34,5,5,'Breidenbach',35236,44,6840,3448,3392,153),
	(2210,8,3,37,5005,76,'Murg',79730,20,6827,3341,3486,327),
	(2211,9,4,74,5420,121,'Ebermannstadt, St',91320,49,6826,3411,3415,137),
	(2212,9,4,71,5406,191,'Stegaurach',96135,23,6824,3315,3509,285),
	(2213,15,0,89,307,307,'Seeland, Stadt',6469,62,6810,3367,3443,109),
	(2214,8,3,17,5012,150,'Schwanau',77963,38,6805,3277,3528,177),
	(2215,9,1,87,148,148,'Kiefersfelden',83088,36,6805,3385,3420,185),
	(2216,5,9,62,44,44,'Nachrodt-Wiblingwerde',58769,29,6790,3341,3449,234),
	(2217,3,4,53,9,9,'Lastrup',49688,85,6782,3445,3337,80),
	(2218,9,7,80,120,120,'Durach',87471,20,6773,3343,3430,327),
	(2219,7,1,34,5002,10,'Birkenfeld, Stadt',55765,13,6770,3455,3315,499),
	(2220,5,1,54,48,48,'Rheurdt',47509,30,6769,3391,3378,226),
	(2221,5,5,54,36,36,'Legden',48739,56,6769,3467,3302,120),
	(2222,3,1,51,5406,27,'Schwülper',38179,20,6767,3336,3431,324),
	(2223,1,0,57,5755,73,'Schönberg (Holstein)',24217,11,6766,3295,3471,581),
	(2224,9,1,76,112,112,'Altmannstein, M',93336,114,6765,3384,3381,59),
	(2225,9,2,78,123,123,'Geiselhöring, St',94333,99,6764,3382,3382,68),
	(2226,6,4,40,21,21,'Reichelsheim (Wetterau), Stadt',61203,27,6763,3359,3404,245),
	(2227,9,2,75,116,116,'Bad Füssing',94072,55,6760,3223,3537,123),
	(2228,1,0,58,5824,58,'Gettorf',24214,9,6756,3326,3430,723),
	(2229,8,4,37,86,86,'Ostrach',88356,108,6750,3333,3417,62),
	(2230,16,0,62,5052,2,'Bleicherode, Stadt',99752,28,6740,3240,3500,238),
	(2231,3,4,59,34,34,'Glandorf',49219,59,6734,3432,3302,112),
	(2232,9,2,79,137,137,'Wallersdorf, M',94522,71,6734,3380,3354,95),
	(2233,3,2,54,11,11,'Diekholzen',31199,30,6732,3275,3457,223),
	(2234,6,4,31,22,22,'Zwingenberg, Stadt',64673,5,6732,3293,3439,1189),
	(2235,14,7,29,250,250,'Machern',4827,38,6723,3283,3440,173),
	(2236,8,1,25,107,107,'Wüstenrot',71543,30,6704,3254,3450,223),
	(2237,9,2,75,151,151,'Tiefenbach',94113,49,6703,3322,3381,135),
	(2238,6,6,33,29,29,'Zierenberg, Stadt',34289,86,6700,3280,3420,77),
	(2239,9,3,74,124,124,'Grafenwöhr, St',92655,216,6686,3304,3382,31),
	(2240,9,4,78,116,116,'Burgkunstadt, St',96224,40,6676,3181,3495,164),
	(2241,16,0,63,92,92,'Wutha-Farnroda',99848,36,6675,3461,3214,183),
	(2242,12,0,61,20,20,'Bestensee',15741,37,6672,3339,3333,177),
	(2243,9,7,74,144,144,'Jettingen-Scheppach, M',89343,54,6669,3304,3365,123),
	(2244,9,1,82,131,131,'Schliersee, M',83727,79,6664,3230,3434,84),
	(2245,3,3,60,4,4,'Bienenbüttel',29553,99,6662,3332,3330,67),
	(2246,9,7,74,155,155,'Leipheim, St',89340,32,6653,3322,3331,207),
	(2247,12,0,65,180,180,'Leegebruch',16767,6,6653,3266,3387,1033),
	(2248,9,5,76,121,121,'Georgensgmünd',91166,46,6650,3280,3370,142),
	(2249,6,6,35,9,9,'Edertal',34549,115,6647,3261,3386,57),
	(2250,6,5,33,2,2,'Brechen',65611,24,6645,3317,3328,267),
	(2251,8,1,25,5005,30,'Flein',74223,8,6644,3149,3495,784),
	(2252,3,4,53,3,3,'Cappeln (Oldenburg)',49692,76,6642,3493,3149,87),
	(2253,13,0,54,5418,81,'Neustadt-Glewe, Stadt',19306,93,6636,3335,3301,71),
	(2254,7,2,35,5006,125,'Schweich, Stadt',54338,31,6635,3187,3448,213),
	(2255,14,5,23,5117,200,'Markneukirchen, Stadt',8258,47,6633,3257,3376,140),
	(2256,9,7,73,5716,139,'Höchstädt a.d.Donau, St',89420,37,6632,3267,3365,177),
	(2257,8,2,36,5006,73,'Neulingen',75245,23,6629,3246,3383,286),
	(2258,9,7,78,5764,203,'Türkheim, M',86842,31,6625,3260,3365,210),
	(2259,8,2,36,5003,38,'Maulbronn, Stadt',75433,25,6624,3239,3385,260),
	(2260,10,0,44,123,123,'Ensdorf',66806,8,6623,3201,3422,789),
	(2261,16,0,71,8,8,'Blankenhain, Stadt',99444,113,6622,3266,3356,58),
	(2262,5,7,62,28,28,'Nieheim, Stadt',33039,79,6621,3345,3276,83),
	(2263,6,4,37,2,2,'Beerfelden, Stadt',64743,71,6620,3354,3266,93),
	(2264,6,5,31,4,4,'Fernwald',35463,21,6617,3261,3356,307),
	(2265,8,2,16,5006,63,'Rheinmünster',77836,42,6617,3364,3253,156),
	(2266,8,2,37,2,2,'Alpirsbach, Stadt',72275,64,6616,3258,3358,102),
	(2267,7,3,37,5003,20,'Edenkoben, Stadt',67480,17,6613,3242,3371,369),
	(2268,9,2,75,146,146,'Salzweg',94121,31,6610,3220,3390,207),
	(2269,9,1,72,122,122,'Laufen, St',83410,35,6608,3324,3284,187),
	(2270,8,3,37,5008,123,'Wutöschingen',79793,26,6607,3306,3301,250),
	(2271,8,2,26,5004,59,'Neulußheim',68809,3,6606,3205,3401,1949),
	(2272,9,3,73,151,151,'Parsberg, St',92331,57,6601,3306,3295,115),
	(2273,13,0,55,5513,20,'Friedland, Stadt',17098,97,6601,3335,3266,68),
	(2274,9,4,78,145,145,'Michelau i.OFr.',96247,19,6587,3260,3327,340),
	(2275,9,2,77,111,111,'Arnstorf, M',94424,80,6585,3407,3178,82),
	(2276,12,0,72,2,2,'Am Mellensee',15838,104,6585,3294,3291,63),
	(2277,8,1,36,5008,44,'Mutlangen',73557,8,6584,3180,3404,750),
	(2278,8,4,17,5007,75,'Winterlingen',72474,50,6583,3268,3315,130),
	(2279,9,7,76,129,129,'Weiler-Simmerberg, M',88171,31,6580,3289,3291,210),
	(2280,8,1,15,5001,54,'Grafenau',71120,13,6577,3321,3256,504),
	(2281,9,4,77,136,136,'Mainleus, M',95336,49,6577,3270,3307,133),
	(2282,8,2,15,5004,111,'Dettenheim',76706,30,6562,3284,3278,212),
	(2283,9,1,76,129,129,'Großmehring',85098,47,6560,3381,3179,138),
	(2284,8,4,25,5003,28,'Dietenheim, Stadt',89165,18,6552,3223,3329,349),
	(2285,9,6,78,5642,134,'Gerolzhofen, St',97447,18,6552,3193,3359,356),
	(2286,3,1,52,1,1,'Adelebsen, Flecken',37139,75,6544,3240,3304,86),
	(2287,7,2,31,5001,8,'Bernkastel-Kues, Stadt',54470,23,6542,3096,3446,276),
	(2288,7,3,39,5003,19,'Gau-Algesheim, Stadt',55435,13,6534,3140,3394,467),
	(2289,14,5,22,310,310,'Leisnig, Stadt',4703,30,6522,3159,3363,214),
	(2290,9,7,72,131,131,'Dinkelscherben, M',86424,67,6520,3244,3276,96),
	(2291,3,4,60,5,5,'Holdorf',49451,54,6519,3283,3236,119),
	(2292,5,5,66,24,24,'Horstmar, Stadt',48612,44,6519,3302,3217,146),
	(2293,8,4,37,5001,31,'Gammertingen, Stadt',72501,52,6517,3163,3354,123),
	(2294,12,0,70,173,173,'Karstädt',19357,252,6512,3259,3253,26),
	(2295,9,2,74,5227,183,'Velden, M',84149,49,6510,3312,3198,132),
	(2296,6,5,32,20,20,'Sinn',35764,18,6508,3180,3328,348),
	(2297,7,1,37,5002,89,'Polch, Stadt',56751,28,6506,3248,3258,227),
	(2298,8,2,36,5001,65,'Wiernsheim',75446,24,6502,3280,3222,264),
	(2299,14,5,21,5103,120,'Burkhardtsdorf',9235,21,6499,3217,3282,307),
	(2300,8,4,15,73,73,'Trochtelfingen, Stadt',72818,79,6497,3245,3252,82),
	(2301,8,2,25,5007,75,'Osterburken, Stadt',74706,47,6490,3242,3248,137),
	(2302,9,2,77,121,121,'Gangkofen, M',84140,108,6488,3226,3262,60),
	(2303,8,4,17,54,54,'Rosenfeld, Stadt',72348,51,6484,3260,3224,127),
	(2304,7,1,33,5007,501,'Bad Sobernheim, Stadt',55566,54,6481,3171,3310,120),
	(2305,8,2,26,5005,6,'Bammental',69245,12,6481,3157,3324,533),
	(2306,9,2,78,148,148,'Mallersdorf-Pfaffenberg, M',84066,72,6476,2929,3547,89),
	(2307,9,4,71,5408,120,'Burgebrach, M',96138,87,6476,3277,3199,74),
	(2308,8,1,16,5006,14,'Deizisau',73779,5,6470,3235,3235,1251),
	(2309,16,0,63,98,98,'Hörselberg-Hainich',99947,141,6469,3314,3155,46),
	(2310,16,0,75,62,62,'Bad Lobenstein, Stadt',7356,48,6466,3201,3265,132),
	(2311,9,2,79,113,113,'Eichendorf, M',94428,98,6456,3205,3251,66),
	(2312,1,0,59,5996,53,'Kropp',24848,31,6447,3240,3207,202),
	(2313,9,6,77,5625,203,'Zellingen, M',97225,41,6445,3178,3267,156),
	(2314,9,6,79,136,136,'Gerbrunn',97218,4,6444,3099,3345,1407),
	(2315,9,7,72,5711,209,'Untermeitingen',86836,16,6440,3166,3274,402),
	(2316,8,1,18,5008,12,'Eberdingen',71735,26,6438,3203,3235,246),
	(2317,9,5,74,139,139,'Leinburg',91227,29,6434,3185,3249,219),
	(2318,6,6,31,2,2,'Burghaun',36151,65,6431,3215,3216,99),
	(2319,7,1,38,5001,44,'Neustadt (Wied)',53577,35,6427,3201,3226,179),
	(2320,10,0,42,117,117,'Weiskirchen',66709,33,6427,3160,3267,191),
	(2321,9,3,71,156,156,'Vilseck, St',92249,64,6426,2981,3445,99),
	(2322,14,5,24,230,230,'Oberlungwitz, Stadt',9353,14,6424,3132,3292,438),
	(2323,16,0,73,111,111,'Unterwellenborn',7333,56,6414,3200,3214,114),
	(2324,8,1,36,5001,21,'Essingen',73457,58,6410,3199,3211,110),
	(2325,16,0,66,23,23,'Floh-Seligenthal',98593,68,6408,3214,3194,93),
	(2326,9,1,89,5173,162,'Waging a.See, M',83329,48,6403,3110,3293,131),
	(2327,12,0,63,148,148,'Ketzin, Stadt',14669,92,6403,3202,3201,69),
	(2328,9,1,83,119,119,'Haag i.OB, M',83527,20,6400,3105,3295,314),
	(2329,9,2,74,134,134,'Geisenhausen, M',84144,62,6395,3147,3248,102),
	(2330,9,4,72,5415,199,'Weidenberg, M',95466,68,6392,3155,3237,93),
	(2331,9,4,74,123,123,'Eggolsheim, M',91330,48,6391,3167,3224,131),
	(2332,9,1,89,120,120,'Grassau, M',83224,35,6388,3081,3307,179),
	(2333,6,4,33,1,1,'Biebesheim am Rhein',64584,18,6383,3175,3208,342),
	(2334,16,0,73,109,109,'Uhlstädt-Kirchhasel',7407,122,6380,3280,3100,52),
	(2335,6,4,35,4,4,'Birstein',63633,86,6379,3157,3222,74),
	(2336,5,5,66,32,32,'Ladbergen',49549,52,6378,3124,3254,122),
	(2337,7,2,35,5005,118,'Saarburg, Stadt',54439,20,6376,3135,3241,311),
	(2338,9,6,74,163,163,'Knetzgau',97478,61,6376,3214,3162,104),
	(2339,14,5,22,5126,490,'Rochlitz, Stadt',9306,23,6361,3006,3355,268),
	(2340,12,0,65,84,84,'Fürstenberg/Havel, Stadt',16798,212,6356,3117,3239,30),
	(2341,6,4,32,17,17,'Otzberg',64853,41,6355,3198,3157,151),
	(2342,14,5,21,260,260,'Grünhain-Beierfeld, Stadt',8344,22,6354,3161,3193,285),
	(2343,9,7,71,5771,156,'Pöttmes, M',86554,82,6348,3173,3175,77),
	(2344,5,5,66,52,52,'Metelen',48629,40,6340,3164,3176,158),
	(2345,9,1,74,141,141,'Röhrmoos',85244,31,6340,3182,3158,200),
	(2346,1,0,62,76,76,'Tangstedt',22889,39,6338,3180,3158,159),
	(2347,9,4,73,158,158,'Bad Rodach, St',96476,77,6331,3056,3275,82),
	(2348,7,3,38,16,16,'Lambsheim',67245,12,6308,3080,3228,495),
	(2349,12,0,72,297,297,'Niedergörsdorf',14913,204,6307,3142,3165,31),
	(2350,3,2,57,3,3,'Auetal',31749,62,6306,3135,3171,101),
	(2351,3,3,51,5404,18,'Nienhagen',29336,17,6305,3062,3243,359),
	(2352,8,1,16,5005,73,'Wolfschlugen',72649,7,6302,3109,3193,885),
	(2353,9,1,89,140,140,'Ruhpolding',83324,147,6296,3047,3249,43),
	(2354,3,3,55,5402,4,'Bardowick, Flecken',21357,23,6295,3103,3192,271),
	(2355,6,6,35,22,22,'Willingen (Upland)',34508,80,6293,3062,3231,78),
	(2356,9,1,84,121,121,'Grasbrunn',85630,23,6289,3128,3161,267),
	(2357,6,6,31,16,16,'Kalbach',36148,70,6287,3192,3095,89),
	(2358,5,5,66,36,36,'Laer',48366,35,6286,3187,3099,179),
	(2359,3,4,61,3,3,'Butjadingen',26969,129,6283,3068,3215,49),
	(2360,9,7,77,5754,154,'Obergünzburg, M',87634,46,6283,3113,3170,135),
	(2361,6,6,31,13,13,'Hofbieber',36145,87,6281,3166,3115,72),
	(2362,6,4,39,14,14,'Schlangenbad',65388,36,6276,3151,3125,172),
	(2363,13,0,60,5023,49,'Lübz, Stadt',19386,49,6275,3020,3255,128),
	(2364,5,5,70,12,12,'Beelen',48361,31,6269,3156,3113,200),
	(2365,10,0,46,116,116,'Oberthal',66649,23,6268,3039,3229,263),
	(2366,8,1,26,5001,58,'Neuenstein, Stadt',74632,47,6262,3171,3091,131),
	(2367,1,0,58,5833,54,'Fockbek',24787,26,6261,2994,3267,235),
	(2368,6,5,32,18,18,'Schöffengrund',35641,34,6257,3133,3124,183),
	(2369,8,4,26,5009,108,'Schwendi',88477,49,6257,3134,3123,127),
	(2370,9,3,76,5342,163,'Schwarzenfeld, M',92521,38,6257,3020,3237,164),
	(2371,1,0,57,5782,74,'Schönkirchen',24226,15,6253,3019,3234,392),
	(2372,12,0,68,477,477,'Wusterhausen/Dosse',16868,195,6251,3189,3062,32),
	(2373,8,1,18,5004,63,'Pleidelsheim',74385,10,6250,3046,3204,614),
	(2374,1,0,58,5864,117,'Nortorf, Stadt',24589,12,6245,3049,3196,489),
	(2375,6,6,34,24,24,'Spangenberg, Liebenbachstadt',34286,97,6243,3163,3080,64),
	(2376,8,1,35,5002,26,'Nattheim',89564,44,6239,3092,3147,139),
	(2377,8,1,18,5007,54,'Murr',71711,7,6237,3064,3173,801),
	(2378,9,5,72,164,164,'Weisendorf, M',91085,36,6233,3057,3176,170),
	(2379,9,1,84,118,118,'Feldkirchen',85622,6,6222,3140,3082,971),
	(2380,9,1,79,119,119,'Emmering',82275,10,6215,3101,3114,568),
	(2381,14,6,28,5209,80,'Dohna, Stadt',1809,28,6215,3101,3114,217),
	(2382,9,5,73,5517,130,'Veitsbronn',90587,16,6212,3023,3189,384),
	(2383,8,1,27,5005,43,'Ilshofen, Stadt',74532,54,6211,3169,3042,113),
	(2384,12,0,66,296,296,'Schwarzheide, Stadt',1987,33,6211,3091,3120,187),
	(2385,3,3,51,5404,21,'Wathlingen',29339,17,6210,3053,3157,351),
	(2386,16,0,63,5057,66,'Ruhla, Stadt',99842,38,6210,3014,3196,161),
	(2387,6,4,34,13,13,'Weilrod',61276,71,6206,3093,3113,87),
	(2388,8,1,16,5004,46,'Neuffen, Stadt',72639,17,6205,3060,3145,356),
	(2389,14,5,21,5106,170,'Eibenstock, Stadt',8309,90,6195,3008,3187,69),
	(2390,7,1,32,5007,72,'Mudersbach',57555,9,6190,3058,3132,657),
	(2391,9,2,79,132,132,'Pilsting, M',94431,71,6190,2994,3196,87),
	(2392,8,3,25,12,12,'Dornhan, Stadt',72175,44,6189,3074,3115,138),
	(2393,9,6,76,134,134,'Klingenberg a.Main, St',63911,21,6188,3078,3110,293),
	(2394,8,2,36,5002,74,'Kämpfelbach',75236,13,6185,3035,3150,453),
	(2395,9,5,75,5519,168,'Uffenheim, St',97215,59,6184,2969,3215,104),
	(2396,7,3,37,5007,61,'Offenbach an der Queich',76877,15,6180,3070,3110,406),
	(2397,8,2,16,5005,33,'Muggensturm',76461,11,6178,3056,3122,534),
	(2398,3,3,58,2,2,'Bispingen',29646,128,6171,3043,3128,48),
	(2399,9,2,75,153,153,'Untergriesbach, M',94107,73,6167,3076,3091,84),
	(2400,3,2,57,5406,32,'Rodenberg, Stadt',31552,15,6163,2998,3165,395),
	(2401,9,6,78,135,135,'Gochsheim',97469,20,6163,3005,3158,298),
	(2402,14,6,27,360,360,'Zeithain',1619,81,6161,3074,3087,76),
	(2403,16,0,67,87,87,'Nesse-Apfelstädt',99192,39,6159,3094,3065,156),
	(2404,9,1,74,143,143,'Schwabhausen',85247,30,6152,3069,3083,204),
	(2405,9,7,72,223,223,'Zusmarshausen, M',86441,68,6152,3049,3103,89),
	(2406,14,6,27,5225,190,'Nünchritz',1612,31,6152,3006,3146,197),
	(2407,6,4,40,25,25,'Wöllstadt',61206,15,6150,3061,3089,400),
	(2408,8,2,16,5002,41,'Ottersweier',77833,29,6148,3084,3064,210),
	(2409,8,1,16,5003,42,'Neckartenzlingen',72654,9,6141,3080,3061,680),
	(2410,6,4,39,6,6,'Hohenstein',65329,63,6137,3071,3066,96),
	(2411,14,6,27,100,100,'Klipphausen',1665,61,6134,3104,3030,99),
	(2412,14,6,26,5214,140,'Großschönau',2779,23,6132,3006,3126,257),
	(2413,8,1,25,5012,8,'Beilstein, Stadt',71717,25,6120,2984,3136,242),
	(2414,3,1,51,5404,13,'Isenbüttel',38550,18,6119,3054,3065,328),
	(2415,12,0,61,112,112,'Eichwalde',15732,2,6113,2957,3156,2183),
	(2416,8,1,25,5010,38,'Güglingen, Stadt',74363,16,6108,3080,3028,375),
	(2417,6,6,33,6,6,'Bad Emstal',34308,38,6106,2966,3140,158),
	(2418,3,4,58,3,3,'Dötlingen',27801,101,6103,3072,3031,60),
	(2419,9,4,73,121,121,'Ebersdorf b.Coburg',96237,26,6098,2977,3121,231),
	(2420,16,0,74,5050,94,'Stadtroda, Stadt',7646,16,6093,3032,3061,362),
	(2421,8,3,25,5003,72,'Deißlingen',78652,32,6090,3000,3090,189),
	(2422,6,4,31,6,6,'Einhausen',64683,26,6088,3075,3013,228),
	(2423,8,4,35,5002,24,'Immenstaad am Bodensee',88090,9,6081,3004,3077,657),
	(2424,9,3,76,5341,144,'Nabburg, St',92507,62,6081,2968,3113,97),
	(2425,14,5,21,110,110,'Breitenbrunn/Erzgeb.',8359,60,6078,2963,3115,101),
	(2426,16,0,63,97,97,'Gerstungen',99834,75,6077,3141,2936,80),
	(2427,8,3,26,5001,6,'Bräunlingen, Stadt',78199,62,6076,2985,3091,98),
	(2428,9,5,75,121,121,'Emskirchen, M',91448,67,6076,3042,3034,90),
	(2429,9,1,83,112,112,'Ampfing',84539,31,6074,3020,3054,195),
	(2430,8,3,15,5006,50,'Heitersheim, Stadt',79423,11,6067,2949,3118,518),
	(2431,9,1,82,116,116,'Gmund a.Tegernsee',83703,34,6065,2879,3186,176),
	(2432,14,6,25,5205,30,'Bernsdorf, Stadt',2994,43,6065,3031,3034,139),
	(2433,9,1,83,5149,129,'Neumarkt-Sankt Veit, St',84494,61,6062,3008,3054,99),
	(2434,8,1,19,89,89,'Berglen',73663,25,6059,3033,3026,234),
	(2435,8,3,27,5003,18,'Geisingen, Stadt',78187,73,6055,3032,3023,82),
	(2436,8,4,36,94,94,'Argenbühl',88260,76,6054,3054,3000,79),
	(2437,9,3,73,121,121,'Dietfurt a.d.Altmühl, St',92345,78,6054,3072,2982,77),
	(2438,8,1,15,5006,46,'Steinenbronn',71144,9,6053,3089,2964,623),
	(2439,9,1,74,136,136,'Petershausen',85238,32,6053,2949,3104,185),
	(2440,1,0,61,5189,42,'Hohenlockstedt',25551,45,6051,2989,3062,133),
	(2441,12,0,65,5502,100,'Gransee, Stadt',16775,121,6051,3035,3016,50),
	(2442,6,4,39,1,1,'Aarbergen',65326,33,6049,3051,2998,178),
	(2443,3,3,57,5406,45,'Sottrum',27367,28,6048,2970,3078,212),
	(2444,8,2,25,5005,117,'Elztal',74834,46,6044,3052,2992,130),
	(2445,8,3,15,5014,98,'Schallstadt',79227,19,6041,2928,3113,309),
	(2446,6,6,35,19,19,'Vöhl',34516,98,6040,3002,3038,61),
	(2447,7,1,32,5001,501,'Altenkirchen (Westerwald), Stadt',57610,10,6039,2816,3223,550),
	(2448,8,3,25,5001,14,'Dunningen',78655,48,6039,3030,3009,125),
	(2449,9,4,71,117,117,'Bischberg',96120,17,6037,2976,3061,344),
	(2450,9,1,89,152,152,'Tittmoning, St',84529,72,6034,3062,2972,84),
	(2451,9,5,71,226,226,'Windsbach, St',91575,68,6030,3112,2918,88),
	(2452,3,4,54,5404,29,'Lathen',49762,38,6029,2972,3057,159),
	(2453,8,4,17,5002,22,'Geislingen, Stadt',72351,31,6029,3052,2977,189),
	(2454,9,1,84,140,140,'Putzbrunn',85640,11,6027,2956,3071,540),
	(2455,8,2,26,5003,40,'Laudenbach',69514,10,6026,2947,3079,586),
	(2456,9,3,71,127,127,'Hirschau, St',92242,74,6026,2945,3081,80),
	(2457,8,2,16,5003,5,'Bietigheim',76467,13,6025,2902,3123,433),
	(2458,9,4,71,155,155,'Litzendorf',96123,25,6015,3003,3012,233),
	(2459,14,6,25,640,640,'Wittichenau, Stadt',2997,60,6009,3015,2994,99),
	(2460,8,1,18,5002,77,'Ingersheim',74379,11,5999,2909,3090,519),
	(2461,9,4,72,190,190,'Speichersdorf',95469,52,5998,3000,2998,113),
	(2462,6,6,33,10,10,'Grebenstein, Stadt',34393,49,5991,2996,2995,120),
	(2463,6,5,32,5,5,'Dietzhölztal',35716,37,5989,2990,2999,160),
	(2464,8,3,26,31,31,'Königsfeld im Schwarzwald',78126,40,5989,2825,3164,149),
	(2465,8,3,36,5009,103,'Zell im Wiesental, Stadt',79669,36,5987,2982,3005,166),
	(2466,12,0,71,57,57,'Drebkau, Stadt',3116,142,5984,3068,2916,42),
	(2467,14,5,22,210,210,'Großschirma, Stadt',9603,61,5982,3017,2965,97),
	(2468,9,5,71,214,214,'Wassertrüdingen, St',91717,53,5979,2980,2999,112),
	(2469,9,7,74,5732,185,'Thannhausen, St',86470,20,5979,2942,3037,299),
	(2470,14,6,26,340,340,'Neugersdorf, Stadt',2727,5,5978,2922,3056,1081),
	(2471,6,6,31,10,10,'Gersfeld (Rhön), Stadt',36129,89,5968,2972,2996,67),
	(2472,9,5,71,115,115,'Bechhofen, M',91572,61,5968,3046,2922,96),
	(2473,8,2,36,30,30,'Ispringen',75228,8,5963,2840,3123,726),
	(2474,8,3,26,5004,41,'Niedereschach',78078,33,5962,2975,2987,180),
	(2475,13,0,52,5224,74,'Stavenhagen, Reuterstadt, Stadt',17153,40,5951,2903,3048,146),
	(2476,3,2,51,5403,10,'Bruchhausen-Vilsen, Flecken',27305,41,5944,2907,3037,144),
	(2477,1,0,56,5642,1,'Appen',25482,20,5939,3376,2563,293),
	(2478,8,3,25,5003,69,'Zimmern ob Rottweil',78658,33,5921,2895,3026,175),
	(2479,9,2,75,128,128,'Hutthurm, M',94116,37,5912,2968,2944,159),
	(2480,1,0,59,113,113,'Glücksburg (Ostsee), Stadt',24960,39,5911,2752,3159,149),
	(2481,7,2,31,5007,124,'Traben-Trarbach, Stadt',56841,31,5898,2897,3001,188),
	(2482,13,0,52,5222,3,'Altentreptow, Stadt',17087,52,5898,2866,3032,112),
	(2483,12,0,62,500,500,'Uebigau-Wahrenbrück, Stadt',4938,134,5892,2972,2920,44),
	(2484,8,1,27,75,75,'Schrozberg, Stadt',74575,105,5889,3001,2888,56),
	(2485,9,3,74,139,139,'Neustadt a.d.Waldnaab, St',92660,9,5889,2844,3045,592),
	(2486,9,3,75,213,213,'Zeitlarn',93197,16,5889,2920,2969,366),
	(2487,3,2,51,5402,5,'Barnstorf, Flecken',49406,52,5888,2913,2975,112),
	(2488,14,6,28,5202,20,'Bad Gottleuba-Berggießhübel, Stadt',1816,88,5885,2935,2950,66),
	(2489,8,1,36,5004,82,'Westhausen',73463,38,5884,2918,2966,153),
	(2490,8,3,15,5002,59,'Ihringen',79241,23,5884,2863,3021,256),
	(2491,15,0,85,110,110,'Falkenstein/Harz, Stadt',6463,102,5882,2979,2903,57),
	(2492,3,4,52,5403,8,'Hage, Flecken',26524,16,5878,2802,3076,354),
	(2493,9,6,73,5633,142,'Mellrichstadt, St',97638,55,5876,2918,2958,105),
	(2494,14,7,29,5305,150,'Geithain, Stadt',4643,30,5876,2830,3046,195),
	(2495,1,0,51,5166,72,'Marne, Stadt',25709,4,5874,2742,3132,1216),
	(2496,8,1,16,5006,4,'Altbach',73776,3,5874,2889,2985,1753),
	(2497,14,6,28,380,380,'Stolpen, Stadt',1833,60,5872,2931,2941,96),
	(2498,6,4,40,18,18,'Ober-Mörlen',61239,37,5856,2894,2962,156),
	(2499,8,1,15,5005,4,'Bondorf',71149,17,5853,2904,2949,334),
	(2500,6,5,32,16,16,'Leun, Stadt',35638,28,5851,2869,2982,204),
	(2501,8,1,36,5001,33,'Hüttlingen',73460,18,5850,2927,2923,313),
	(2502,9,6,71,112,112,'Bessenbach',63856,29,5850,2925,2925,195),
	(2503,9,3,75,180,180,'Pentling',93080,32,5848,2933,2915,180),
	(2504,13,0,54,5426,37,'Grabow, Stadt',19300,47,5846,2854,2992,123),
	(2505,7,1,38,5003,12,'Dierdorf, Stadt',56269,31,5845,2911,2934,183),
	(2506,8,1,25,5001,78,'Oedheim',74229,21,5845,2923,2922,275),
	(2507,7,1,38,5004,41,'Linz am Rhein, Stadt',53545,17,5842,2768,3074,325),
	(2508,14,6,25,330,330,'Lohsa',2999,134,5838,2904,2934,44),
	(2509,8,3,27,5003,25,'Immendingen',78194,74,5837,3101,2736,79),
	(2510,8,3,17,5013,145,'Wolfach, Stadt',77709,67,5831,2918,2913,86),
	(2511,8,2,37,5001,74,'Waldachtal',72178,29,5830,2869,2961,195),
	(2512,8,1,26,5001,47,'Kupferzell',74635,54,5829,2918,2911,107),
	(2513,3,4,61,5,5,'Jade',26349,93,5828,2917,2911,62),
	(2514,6,4,40,6,6,'Echzell',61209,37,5828,2920,2908,155),
	(2515,6,5,33,11,11,'Mengerskirchen, Marktflecken',35794,30,5827,2881,2946,189),
	(2516,16,0,65,2,2,'Artern/Unstrut, Stadt',6556,24,5824,2809,3015,242),
	(2517,8,3,17,5006,56,'Kappelrodeck',77876,17,5811,2875,2936,324),
	(2518,3,4,52,20,20,'Norderney, Stadt',26548,26,5810,2591,3219,221),
	(2519,8,3,17,5005,41,'Hausach, Stadt',77756,36,5806,2862,2944,161),
	(2520,13,0,51,68,68,'Sanitz',18190,82,5806,2927,2879,70),
	(2521,14,5,21,310,310,'Jahnsdorf/Erzgeb.',9387,26,5804,2909,2895,222),
	(2522,6,4,32,5,5,'Eppertshausen',64859,13,5803,2852,2951,443),
	(2523,8,2,25,5008,9,'Billigheim',74842,48,5802,2958,2844,118),
	(2524,8,4,16,5002,6,'Bodelshausen',72411,13,5802,2889,2913,420),
	(2525,7,1,37,5001,88,'Plaidt',56637,9,5801,2851,2950,618),
	(2526,3,4,60,1,1,'Bakum',49456,78,5799,2901,2898,74),
	(2527,3,1,58,5406,30,'Sickte',38173,25,5788,2869,2919,228),
	(2528,16,0,62,5,5,'Ellrich, Stadt',99755,69,5781,2875,2906,83),
	(2529,9,6,76,5630,133,'Kleinwallstadt, M',63839,15,5777,2878,2899,366),
	(2530,3,3,51,5403,16,'Lachendorf',29331,38,5774,2818,2956,151),
	(2531,8,1,26,72,72,'Schöntal',74214,81,5771,2962,2809,71),
	(2532,6,5,33,16,16,'Waldbrunn (Westerwald)',65620,29,5767,2887,2880,194),
	(2533,16,0,67,5050,53,'Ohrdruf, Stadt',99885,39,5765,2805,2960,145),
	(2534,3,3,59,5402,17,'Fredenbeck',21717,48,5763,2879,2884,119),
	(2535,9,7,73,122,122,'Buttenwiesen',86647,59,5740,2955,2785,96),
	(2536,14,7,29,320,320,'Neukieritzsch',4575,50,5740,2803,2937,114),
	(2537,1,0,60,19,19,'Ellerau',25479,7,5738,2785,2953,809),
	(2538,7,1,38,5002,4,'Bad Hönningen, Stadt',53557,20,5738,2771,2967,286),
	(2539,8,1,26,5003,39,'Ingelfingen, Stadt',74653,46,5736,2804,2932,123),
	(2540,13,0,60,5025,61,'Plau am See, Stadt',19395,77,5734,2805,2929,74),
	(2541,9,1,87,120,120,'Brannenburg',83098,33,5730,2788,2942,170),
	(2542,6,6,32,12,12,'Ludwigsau',36251,111,5729,2799,2930,51),
	(2543,9,2,79,127,127,'Mengkofen',84152,84,5722,2873,2849,68),
	(2544,9,4,71,220,220,'Schlüsselfeld, St',96132,70,5718,2848,2870,81),
	(2545,9,1,87,114,114,'Aschau i.Chiemgau',83229,79,5716,2693,3023,72),
	(2546,13,0,58,5825,28,'Gadebusch, Stadt',19205,47,5715,2834,2881,120),
	(2547,7,3,38,5002,7,'Dudenhofen',67373,12,5709,2806,2903,441),
	(2548,8,1,27,52,52,'Mainhardt',74535,58,5709,2818,2891,97),
	(2549,7,3,36,5005,92,'Schönenberg-Kübelberg',66901,18,5700,2769,2931,305),
	(2550,9,6,74,221,221,'Zeil a.Main, St',97475,35,5700,2835,2865,159),
	(2551,8,1,18,5005,6,'Benningen am Neckar',71726,4,5697,2819,2878,1170),
	(2552,8,2,26,5009,91,'Waibstadt, Stadt',74915,25,5697,2805,2892,223),
	(2553,7,1,43,5002,229,'Hachenburg, Stadt',57627,21,5696,2714,2982,266),
	(2554,14,6,28,5201,10,'Altenberg, Stadt',1773,89,5694,2928,2766,63),
	(2555,3,3,58,17,17,'Neuenkirchen',29643,96,5691,2835,2856,59),
	(2556,8,1,28,5001,58,'Igersheim',97999,42,5685,2792,2893,133),
	(2557,14,6,25,630,630,'Wilthen, Stadt',2681,17,5684,2725,2959,333),
	(2558,9,4,78,120,120,'Ebensfeld, M',96250,68,5682,2862,2820,83),
	(2559,16,0,74,5015,11,'Dornburg-Camburg, Stadt',7774,30,5674,2788,2886,185),
	(2560,8,3,15,133,133,'Vogtsburg im Kaiserstuhl, Stadt',79235,37,5670,2857,2813,152),
	(2561,8,2,35,5007,32,'Haiterbach, Stadt',72221,28,5669,2760,2909,196),
	(2562,16,0,63,76,76,'Treffurt, Stadt',99830,54,5666,2837,2829,103),
	(2563,6,5,33,1,1,'Beselich',65614,31,5664,2775,2889,180),
	(2564,6,4,33,13,13,'Stockstadt am Rhein',64589,18,5658,2770,2888,303),
	(2565,9,3,76,150,150,'Wernberg-Köblitz, M',92533,66,5656,2844,2812,86),
	(2566,9,1,76,138,138,'Kipfenberg, M',85110,81,5654,2827,2827,69),
	(2567,3,2,55,5402,3,'Bodenwerder, Stadt',37619,28,5646,2715,2931,195),
	(2568,9,4,79,112,112,'Arzberg, St',95659,43,5646,2709,2937,131),
	(2569,14,5,21,5139,700,'Zschorlau',8321,21,5641,2762,2879,257),
	(2570,9,4,75,158,158,'Oberkotzau, M',95145,21,5638,2766,2872,262),
	(2571,7,2,35,5001,45,'Hermeskeil, Stadt',54411,30,5637,2726,2911,183),
	(2572,13,0,51,86,86,'Satow',18239,119,5636,2881,2755,47),
	(2573,13,0,53,5321,47,'Laage, Stadt',18299,81,5634,2842,2792,69),
	(2574,14,5,21,500,500,'Raschau-Markersbach',8352,39,5634,2774,2860,143),
	(2575,9,1,88,137,137,'Pöcking',82343,20,5633,2739,2894,269),
	(2576,7,1,43,5001,206,'Bad Marienberg (Westerwald), Stadt',56470,9,5632,2766,2866,565),
	(2577,16,0,69,5050,12,'Eisfeld, Stadt',98673,46,5632,2832,2800,120),
	(2578,9,1,82,129,129,'Rottach-Egern',83700,59,5628,2487,3141,95),
	(2579,8,4,35,5004,36,'Meersburg, Stadt',88709,12,5627,2717,2910,466),
	(2580,3,1,51,5405,18,'Müden (Aller)',38539,67,5623,2810,2813,84),
	(2581,6,6,33,12,12,'Helsa',34298,25,5617,2651,2966,218),
	(2582,9,5,75,145,145,'Markt Erlbach, M',91459,60,5616,2830,2786,92),
	(2583,16,0,65,61,61,'Roßleben, Stadt',6571,33,5616,2795,2821,168),
	(2584,14,7,29,220,220,'Kitzscher, Stadt',4567,28,5615,2738,2877,194),
	(2585,6,6,35,1,1,'Allendorf (Eder)',35108,41,5614,2781,2833,134),
	(2586,8,1,16,5001,16,'Dettingen unter Teck',73265,15,5614,2810,2804,371),
	(2587,8,1,17,5004,33,'Kuchen',73329,8,5613,2816,2797,627),
	(2588,14,7,30,330,330,'Wermsdorf',4779,104,5613,2750,2863,54),
	(2589,9,3,73,156,156,'Pyrbaum, M',90602,50,5612,2796,2816,112),
	(2590,1,0,53,5318,20,'Büchen',21514,16,5611,2752,2859,333),
	(2591,9,2,75,156,156,'Wegscheid, M',94110,80,5607,2797,2810,69),
	(2592,9,3,75,119,119,'Bernhardswald',93170,71,5604,2739,2865,78),
	(2593,6,4,39,17,17,'Walluf',65396,6,5602,2699,2903,831),
	(2594,9,7,79,5723,228,'Wemding, St',86650,31,5601,2753,2848,177),
	(2595,9,2,73,164,164,'Riedenburg, St',93339,100,5600,2784,2816,56),
	(2596,3,2,55,5407,34,'Stadtoldendorf, Stadt',37627,24,5599,2651,2948,225),
	(2597,6,5,34,13,13,'Lohra',35102,49,5594,2803,2791,114),
	(2598,9,7,80,115,115,'Blaichach',87544,50,5589,2769,2820,112),
	(2599,14,6,26,5227,400,'Olbersdorf',2785,15,5589,2663,2926,369),
	(2600,14,6,26,390,390,'Oderwitz',2791,35,5588,2704,2884,156),
	(2601,9,1,86,149,149,'Rohrbach',85296,29,5587,2761,2826,189),
	(2602,9,1,81,122,122,'Geltendorf',82269,34,5586,2755,2831,160),
	(2603,12,0,64,448,448,'Seelow, Stadt',15306,42,5575,2630,2945,131),
	(2604,6,4,40,15,15,'Münzenberg, Stadt',35516,31,5574,2752,2822,176),
	(2605,8,2,15,5001,39,'Kronau',76709,10,5574,2730,2844,511),
	(2606,15,0,88,5003,125,'Götschetal',6193,32,5572,2768,2804,169),
	(2607,14,5,21,640,640,'Thum, Stadt',9419,18,5571,2736,2835,295),
	(2608,9,5,71,135,135,'Dietenhofen, M',90599,63,5565,2812,2753,87),
	(2609,9,1,78,116,116,'Au i.d.Hallertau, M',84072,54,5564,2856,2708,101),
	(2610,9,5,71,174,174,'Leutershausen, St',91578,84,5564,2739,2825,66),
	(2611,1,0,59,5940,171,'Tarp',24963,16,5563,2890,2673,340),
	(2612,12,0,60,5003,24,'Biesenthal, Stadt',16359,60,5563,2753,2810,92),
	(2613,3,4,61,8,8,'Ovelgönne',26939,123,5560,2806,2754,45),
	(2614,8,2,35,5005,47,'Neubulach, Stadt',75387,24,5554,2761,2793,225),
	(2615,6,4,39,16,16,'Waldems',65529,36,5551,2789,2762,151),
	(2616,8,4,16,22,22,'Kirchentellinsfurt',72138,11,5551,2729,2822,505),
	(2617,7,1,43,5009,308,'Westerburg, Stadt',56457,18,5547,2733,2814,300),
	(2618,8,1,35,5003,31,'Sontheim an der Brenz',89567,28,5538,2794,2744,191),
	(2619,9,1,84,142,142,'Schäftlarn',82069,16,5534,2709,2825,331),
	(2620,9,1,82,134,134,'Waakirchen',83666,42,5530,2690,2840,131),
	(2621,3,3,57,5405,44,'Sittensen',27419,18,5529,2741,2788,298),
	(2622,16,0,68,5006,34,'Kölleda, Stadt',99625,31,5526,2709,2817,177),
	(2623,8,4,16,5001,11,'Dußlingen',72144,13,5525,2749,2776,423),
	(2624,9,1,74,118,118,'Erdweg',85253,36,5525,2782,2743,153),
	(2625,8,1,16,5007,7,'Baltmannsweiler',73666,18,5520,2728,2792,298),
	(2626,13,0,62,56,56,'Strasburg (Uckermark), Stadt',17335,86,5517,2650,2867,64),
	(2627,9,1,89,149,149,'Tacherting',83342,50,5514,2739,2775,110),
	(2628,8,3,37,5003,125,'Küssaberg',79790,26,5505,2726,2779,210),
	(2629,6,6,35,4,4,'Battenberg (Eder), Stadt',35088,64,5504,2785,2719,85),
	(2630,8,1,28,64,64,'Külsheim, Stadt',97900,81,5502,2842,2660,68),
	(2631,14,5,24,60,60,'Fraureuth',8427,22,5501,2690,2811,244),
	(2632,8,3,17,5001,116,'Sasbach',77880,16,5496,2722,2774,328),
	(2633,9,7,79,155,155,'Harburg (Schwaben), St',86655,73,5495,2767,2728,75),
	(2634,3,3,59,5405,27,'Horneburg, Flecken',21640,17,5492,2692,2800,320),
	(2635,14,6,27,130,130,'Lommatzsch, Stadt',1623,66,5490,2644,2846,83),
	(2636,14,6,28,5240,400,'Tharandt, Stadt',1737,71,5490,2770,2720,77),
	(2637,9,2,77,5241,113,'Bad Birnbach, M',84364,68,5489,2671,2818,80),
	(2638,3,3,56,5401,3,'Hambergen',27729,30,5485,2645,2840,181),
	(2639,9,3,75,118,118,'Beratzhausen, M',93176,72,5483,2675,2808,76),
	(2640,13,0,61,5,5,'Binz',18609,25,5483,2655,2828,217),
	(2641,9,1,77,130,130,'Moosinning',85452,39,5477,2758,2719,137),
	(2642,9,5,76,111,111,'Abenberg, St',91183,48,5471,2647,2824,113),
	(2643,16,0,72,5051,13,'Neuhaus am Rennweg, Stadt',98724,22,5468,2655,2813,241),
	(2644,8,4,16,9,9,'Dettenhausen',72135,11,5465,2714,2751,496),
	(2645,9,1,87,167,167,'Riedering',83083,37,5460,2691,2769,144),
	(2646,9,3,76,5343,153,'Pfreimd, St',92536,51,5460,2757,2703,106),
	(2647,8,1,17,5001,14,'Deggingen',73326,22,5458,2697,2761,240),
	(2648,8,2,36,5001,25,'Heimsheim, Stadt',71296,14,5458,3120,2338,382),
	(2649,14,7,29,190,190,'Großpösna',4463,41,5458,2732,2726,132),
	(2650,3,1,58,5405,27,'Schöppenstedt, Stadt',38170,39,5457,2625,2832,138),
	(2651,9,1,87,169,169,'Rohrdorf',83101,28,5457,2739,2718,190),
	(2652,8,1,17,10,10,'Böhmenkirch',89558,51,5455,2779,2676,107),
	(2653,9,6,78,150,150,'Kolitzheim',97509,59,5449,2761,2688,92),
	(2654,6,4,32,3,3,'Bickenbach',64404,9,5448,2679,2769,588),
	(2655,6,6,32,15,15,'Niederaula',36272,64,5448,2645,2803,85),
	(2656,16,0,69,43,43,'Schleusingen, Stadt',98553,36,5445,2674,2771,148),
	(2657,9,1,82,114,114,'Fischbachau',83730,75,5440,2686,2754,72),
	(2658,15,0,90,5007,545,'Tangerhütte, Stadt',39517,31,5439,2690,2749,174),
	(2659,8,2,15,5003,29,'Hambrücken',76707,10,5437,2714,2723,496),
	(2660,7,3,34,5002,8,'Hagenbach, Stadt',76767,15,5432,2716,2716,343),
	(2661,14,5,22,240,240,'Halsbrücke',9633,41,5432,2730,2702,132),
	(2662,7,3,34,5005,17,'Lingenfeld',67360,15,5431,2719,2712,356),
	(2663,13,0,57,5719,104,'Sundhagen ',18510,159,5431,2771,2660,34),
	(2664,7,3,33,5005,502,'Rockenhausen, Stadt',67806,36,5429,2692,2737,147),
	(2665,16,0,66,94,94,'Grabfeld',98631,110,5426,2717,2709,49),
	(2666,8,2,37,5003,27,'Eutingen im Gäu',72184,32,5424,2742,2682,165),
	(2667,3,4,56,5404,23,'Uelsen',49843,19,5418,2684,2734,278),
	(2668,8,1,25,5002,49,'Kirchardt',74912,21,5415,2754,2661,252),
	(2669,9,4,78,111,111,'Altenkunstadt',96264,32,5415,2626,2789,164),
	(2670,16,0,66,69,69,'Steinbach-Hallenberg, Kurort, Stadt',98587,22,5414,2625,2789,239),
	(2671,12,0,72,5204,53,'Dahme/Mark, Stadt',15936,162,5412,2661,2751,33),
	(2672,14,5,23,10,10,'Adorf/Vogtl., Stadt',8626,42,5411,2603,2808,126),
	(2673,8,1,17,5008,38,'Rechberghausen',73098,6,5409,2630,2779,845),
	(2674,1,0,55,41,41,'Süsel',23701,75,5407,2684,2723,72),
	(2675,8,4,26,5007,45,'Ertingen',88521,37,5407,2691,2716,143),
	(2676,14,5,24,20,20,'Callenberg',9337,39,5402,2662,2740,136),
	(2677,1,0,57,5727,48,'Lütjenburg, Stadt',24321,6,5397,2578,2819,878),
	(2678,6,6,35,8,8,'Diemelstadt, Stadt',34474,82,5391,2707,2684,65),
	(2679,8,2,15,47,47,'Marxzell',76359,34,5388,2672,2716,154),
	(2680,8,1,16,5005,50,'Oberboihingen',72644,6,5387,2692,2695,854),
	(2681,8,2,36,5007,44,'Neuhausen',75242,29,5385,2629,2756,181),
	(2682,8,1,18,5001,47,'Löchgau',74369,10,5381,2652,2729,491),
	(2683,8,4,15,5001,89,'Engstingen',72829,31,5377,2644,2733,171),
	(2684,9,2,74,120,120,'Bodenkirchen',84155,62,5371,2715,2656,87),
	(2685,8,1,19,5004,75,'Sulzbach an der Murr',71560,40,5367,2558,2809,134),
	(2686,14,7,30,190,190,'Mockrehna',4862,115,5367,2722,2645,47),
	(2687,9,7,71,5704,122,'Dasing',86453,40,5361,2720,2641,131),
	(2688,6,4,40,14,14,'Limeshain',63694,12,5360,2645,2715,429),
	(2689,14,5,22,540,540,'Striegistal',9661,77,5359,2737,2622,70),
	(2690,9,1,77,5123,133,'Oberding',85445,64,5358,2753,2605,83),
	(2691,6,6,34,18,18,'Niedenstein, Stadt',34305,30,5354,2715,2639,175),
	(2692,8,2,16,13,13,'Forbach',76596,131,5351,2629,2722,41),
	(2693,9,2,73,5216,166,'Saal a.d.Donau',93342,44,5345,2570,2775,121),
	(2694,9,3,77,116,116,'Erbendorf, St',92681,67,5341,2620,2721,79),
	(2695,9,4,72,179,179,'Pottenstein, St',91278,73,5339,2687,2652,73),
	(2696,8,2,36,5007,62,'Tiefenbronn',75233,14,5336,2676,2660,361),
	(2697,5,7,62,24,24,'Marienmünster, Stadt',37696,64,5335,2693,2642,83),
	(2698,3,2,56,30,30,'Steyerberg, Flecken',31595,101,5331,2662,2669,52),
	(2699,8,1,15,5003,37,'Nufringen',71154,10,5330,2653,2677,531),
	(2700,7,3,39,5002,39,'Nackenheim',55299,8,5328,2655,2673,617),
	(2701,3,3,60,5403,6,'Ebstorf, Flecken',29574,27,5327,2634,2693,195),
	(2702,8,2,25,5009,1,'Adelsheim, Stadt',74740,43,5323,2820,2503,121),
	(2703,8,1,17,5011,30,'Heiningen',73092,12,5319,2648,2671,427),
	(2704,14,6,26,60,60,'Boxberg/O.L.',2943,217,5319,2736,2583,25),
	(2705,14,6,26,5235,480,'Rothenburg/O.L., Stadt',2929,72,5317,2728,2589,74),
	(2706,9,1,72,132,132,'Schönau a.Königssee',83471,131,5314,2615,2699,40),
	(2707,6,6,36,14,14,'Wehretal',37287,39,5311,2606,2705,135),
	(2708,12,0,71,301,301,'Neuhausen/Spree',3058,133,5310,2683,2627,40),
	(2709,6,4,34,3,3,'Glashütten',61479,27,5306,2609,2697,196),
	(2710,8,3,15,5009,13,'Bötzingen',79268,12,5302,2651,2651,408),
	(2711,9,6,79,185,185,'Rottendorf',97228,14,5302,2555,2747,358),
	(2712,9,7,71,112,112,'Affing',86444,44,5300,2683,2617,118),
	(2713,6,6,34,8,8,'Guxhagen',34302,26,5296,2602,2694,202),
	(2714,6,6,33,25,25,'Trendelburg, Stadt',34388,69,5294,2587,2707,76),
	(2715,9,5,74,147,147,'Pommelsbrunn',91224,50,5290,2615,2675,106),
	(2716,15,0,91,5004,160,'Kemberg, Stadt',6901,80,5288,2589,2699,65),
	(2717,14,6,25,380,380,'Neukirch/Lausitz',1904,21,5287,2610,2677,248),
	(2718,8,2,26,5002,49,'Meckesheim',74909,16,5282,2653,2629,323),
	(2719,8,1,18,5008,68,'Sersheim',74372,11,5281,2592,2689,460),
	(2720,7,2,32,5006,296,'Prüm, Stadt',54595,22,5280,2611,2669,231),
	(2721,9,6,71,139,139,'Laufach',63846,15,5276,2660,2616,338),
	(2722,9,1,73,120,120,'Egling',82544,74,5275,2670,2605,71),
	(2723,6,4,34,4,4,'Grävenwiesbach',61279,43,5273,2674,2599,122),
	(2724,9,7,78,5768,144,'Bad Grönenbach, M',87730,42,5272,2556,2716,125),
	(2725,7,3,36,5006,102,'Waldmohr',66914,13,5270,2612,2658,403),
	(2726,7,3,38,5005,26,'Waldsee',67165,12,5267,2618,2649,407),
	(2727,9,1,73,118,118,'Dietramszell',83623,96,5262,2682,2580,54),
	(2728,6,6,33,18,18,'Naumburg, Stadt',34311,66,5261,2567,2694,79),
	(2729,8,4,17,5004,51,'Rangendingen',72414,21,5261,2573,2688,243),
	(2730,9,3,74,168,168,'Windischeschenbach, St',92670,36,5261,2552,2709,145),
	(2731,8,1,27,8,8,'Blaufelden',74572,90,5260,2714,2546,58),
	(2732,8,3,36,5005,78,'Schliengen',79418,37,5257,2583,2674,140),
	(2733,9,1,72,128,128,'Piding',83451,17,5254,2547,2707,299),
	(2734,9,2,77,149,149,'Triftern, M',84371,62,5253,2614,2639,84),
	(2735,1,0,57,5755,43,'Laboe',24235,5,5252,2575,2677,1004),
	(2736,3,2,54,5402,18,'Gronau (Leine), Stadt',31028,20,5244,2471,2773,254),
	(2737,9,1,72,130,130,'Saaldorf-Surheim',83416,39,5243,2617,2626,134),
	(2738,9,1,77,123,123,'Isen, M',84424,43,5243,2655,2588,120),
	(2739,9,3,77,5348,129,'Kemnath, St',95478,56,5242,2557,2685,92),
	(2740,6,5,31,15,15,'Rabenau',35466,43,5239,2605,2634,121),
	(2741,1,0,61,5134,44,'Horst (Holstein)',25358,29,5235,2551,2684,180),
	(2742,13,0,62,5216,12,'Eggesin, Stadt',17367,88,5234,2600,2634,59),
	(2743,3,3,58,5403,20,'Schwarmstedt',29690,29,5233,2531,2702,175),
	(2744,8,2,26,5004,3,'Altlußheim',68804,15,5233,2535,2698,328),
	(2745,9,6,74,133,133,'Eltmann, St',97483,40,5232,2628,2604,128),
	(2746,16,0,67,86,86,'Drei Gleichen',99869,57,5232,2626,2606,90),
	(2747,8,1,18,5003,40,'Kirchheim am Neckar',74366,8,5230,2581,2649,613),
	(2748,9,2,77,128,128,'Kirchdorf a.Inn',84375,31,5228,2592,2636,165),
	(2749,15,0,85,100,100,'Elbingerode (Harz), Stadt',38875,80,5226,2473,2753,65),
	(2750,8,1,27,5002,73,'Satteldorf',74589,46,5223,2612,2611,113),
	(2751,13,0,56,5621,57,'Röbel/Müritz, Stadt',17207,30,5222,2501,2721,173),
	(2752,6,4,37,3,3,'Brensbach',64395,23,5221,2627,2594,225),
	(2753,8,3,15,5011,115,'Umkirch',79224,8,5220,2625,2595,599),
	(2754,8,1,28,82,82,'Niederstetten, Stadt',97996,104,5218,2724,2494,50),
	(2755,8,1,27,5008,71,'Rot am See',74585,74,5215,2635,2580,70),
	(2756,8,2,25,5005,74,'Obrigheim',74847,24,5215,2550,2665,215),
	(2757,9,5,76,148,148,'Thalmässing, M',91177,80,5213,2591,2622,65),
	(2758,8,4,15,93,93,'St. Johann',72813,58,5212,2599,2613,88),
	(2759,9,3,73,167,167,'Velburg, St',92355,175,5212,2646,2566,30),
	(2760,16,0,76,61,61,'Ronneburg, Stadt',7580,19,5212,2516,2696,272),
	(2761,7,3,35,5007,35,'Otterberg, Stadt',67697,32,5211,2583,2628,162),
	(2762,9,1,74,122,122,'Hebertshausen',85241,29,5211,2581,2630,176),
	(2763,1,0,58,5888,124,'Osterrönfeld',24783,17,5208,2591,2617,291),
	(2764,9,1,80,125,125,'Oberammergau',82487,30,5204,2499,2705,173),
	(2765,6,5,34,1,1,'Amöneburg, Stadt',35287,43,5201,2627,2574,118),
	(2766,14,5,21,50,50,'Bad Schlema',8301,15,5195,2549,2646,335),
	(2767,9,7,78,5758,115,'Babenhausen, M',87727,27,5192,2589,2603,191),
	(2768,8,1,17,5009,12,'Bad Boll',73087,10,5191,2455,2736,474),
	(2769,7,1,37,5002,86,'Ochtendung',56299,24,5190,2552,2638,216),
	(2770,3,4,54,5406,11,'Esterwegen',26897,49,5189,2622,2567,105),
	(2771,8,3,37,5004,128,'Ühlingen-Birkendorf',79777,77,5189,2638,2551,67),
	(2772,3,4,57,2,2,'Borkum, Stadt',26757,30,5186,2354,2832,167),
	(2773,9,1,85,139,139,'Karlshuld',86668,29,5185,2557,2628,178),
	(2774,14,6,25,90,90,'Cunewalde',2733,26,5185,2554,2631,195),
	(2775,16,0,73,42,42,'Königsee, Stadt',7426,31,5183,2513,2670,165),
	(2776,6,4,35,20,20,'Neuberg',63543,10,5182,2513,2669,492),
	(2777,8,3,26,5004,75,'Brigachtal',78086,22,5181,2540,2641,227),
	(2778,8,1,25,68,68,'Neudenau, Stadt',74861,32,5175,2584,2591,157),
	(2779,9,4,76,178,178,'Stockheim',96342,25,5172,2567,2605,204),
	(2780,6,6,34,26,26,'Willingshausen',34628,59,5170,2610,2560,86),
	(2781,15,0,83,5001,530,'Wanzleben, Stadt',39164,44,5169,2514,2655,116),
	(2782,14,7,29,30,30,'Bennewitz',4828,46,5165,2577,2588,111),
	(2783,8,4,15,80,80,'Wannweil',72827,5,5162,2528,2634,967),
	(2784,9,3,75,5333,162,'Laaber, M',93164,28,5161,2609,2552,179),
	(2785,15,0,84,20,20,'Bad Kösen, Stadt',6628,35,5161,2480,2681,144),
	(2786,8,4,37,5007,107,'Stetten am kalten Markt',72510,56,5159,2610,2549,91),
	(2787,6,4,35,5,5,'Brachttal',63636,30,5157,2533,2624,167),
	(2788,8,1,27,5009,100,'Rosengarten',74538,31,5156,2518,2638,166),
	(2789,8,3,15,5016,130,'Münstertal/Schwarzwald',79244,67,5156,2562,2594,76),
	(2790,8,3,35,5004,66,'Reichenau',78479,12,5156,2567,2589,405),
	(2791,9,2,73,5217,141,'Langquaid, M',84085,56,5150,2573,2577,91),
	(2792,9,7,80,5745,144,'Weitnau, M',87480,65,5150,2573,2577,79),
	(2793,9,4,72,5412,154,'Hollfeld, St',96142,80,5148,2507,2641,64),
	(2794,8,3,37,106,106,'Stühlingen, Stadt',79780,93,5141,2570,2571,55),
	(2795,13,0,58,5826,65,'Lüdersdorf',23923,54,5140,2568,2572,95),
	(2796,8,3,17,5007,59,'Kippenheim',77971,20,5135,2571,2564,246),
	(2797,9,1,88,144,144,'Weßling',82234,22,5135,2577,2558,227),
	(2798,6,6,33,11,11,'Habichtswald',34317,28,5132,2534,2598,182),
	(2799,3,4,54,5402,12,'Freren, Stadt',49832,48,5129,2532,2597,105),
	(2800,13,0,51,5118,71,'Schwaan, Stadt',18258,38,5123,2513,2610,134),
	(2801,9,5,72,130,130,'Hemhofen',91334,6,5122,2528,2594,758),
	(2802,7,1,40,5003,64,'Kastellaun, Stadt',56288,8,5118,2539,2579,604),
	(2803,9,1,75,133,133,'Pliening',85652,22,5117,2582,2535,225),
	(2804,3,1,51,5404,6,'Calberlah',38547,27,5114,2559,2555,185),
	(2805,9,4,73,175,175,'Weitramsdorf',96479,33,5110,2517,2593,152),
	(2806,9,6,78,115,115,'Bergrheinfeld',97493,19,5108,2538,2570,257),
	(2807,9,4,73,166,166,'Sonnefeld',96242,34,5107,2514,2593,147),
	(2808,6,6,32,1,1,'Alheim',36211,63,5097,2585,2512,80),
	(2809,14,5,21,160,160,'Ehrenfriedersdorf, Stadt',9427,15,5094,2446,2648,321),
	(2810,7,1,43,5010,81,'Wirges, Stadt',56422,10,5093,2430,2663,503),
	(2811,8,3,37,5002,60,'Jestetten',79798,20,5093,2488,2605,247),
	(2812,3,1,58,5404,26,'Schladen',38315,30,5090,2448,2642,166),
	(2813,14,7,30,250,250,'Rackwitz',4519,39,5088,2594,2494,129),
	(2814,6,4,31,15,15,'Lindenfels, Stadt',64678,21,5086,2478,2608,241),
	(2815,3,3,55,49,49,'Amt Neuhaus',19273,237,5083,2560,2523,21),
	(2816,15,0,84,5006,135,'Freyburg (Unstrut), Stadt',6632,46,5081,2446,2635,109),
	(2817,6,6,35,7,7,'Diemelsee',34519,121,5080,2563,2517,42),
	(2818,3,3,59,5403,2,'Ahlerstedt',21702,62,5077,2558,2519,81),
	(2819,9,6,76,125,125,'Großheubach, M',63920,19,5077,2513,2564,267),
	(2820,14,5,22,420,420,'Niederwiesa',9577,16,5076,2513,2563,310),
	(2821,8,3,15,68,68,'Lenzkirch',79853,57,5074,2472,2602,88),
	(2822,9,5,73,133,133,'Wilhermsdorf, M',91452,26,5073,2557,2516,190),
	(2823,9,5,76,117,117,'Büchenbach',91186,30,5072,2493,2579,165),
	(2824,9,6,72,140,140,'Oerlenbach',97714,33,5058,2490,2568,151),
	(2825,3,3,53,5402,16,'Hanstedt',21271,59,5055,2407,2648,85),
	(2826,9,7,79,5721,197,'Oettingen i.Bay., St',86732,34,5055,2497,2558,148),
	(2827,6,5,32,7,7,'Driedorf',35759,47,5053,2506,2547,106),
	(2828,8,3,17,5011,127,'Seelbach',77960,29,5050,2490,2560,169),
	(2829,6,6,32,20,20,'Wildeck',36208,39,5048,2451,2597,127),
	(2830,14,5,21,540,540,'Schönheide',8304,28,5047,2485,2562,180),
	(2831,9,6,79,205,205,'Waldbüttelbrunn',97297,19,5045,2540,2505,263),
	(2832,15,0,81,5004,280,'Klötze, Stadt',38486,61,5044,2497,2547,82),
	(2833,9,5,76,147,147,'Spalt, St',91174,55,5042,2506,2536,90),
	(2834,13,0,55,5520,9,'Burg Stargard, Stadt',17094,61,5042,2512,2530,82),
	(2835,9,6,72,139,139,'Oberthulba, M',97723,52,5039,2465,2574,96),
	(2836,9,4,72,131,131,'Eckersdorf',95488,36,5036,2416,2620,139),
	(2837,8,2,16,5006,28,'Lichtenau, Stadt',77839,27,5027,2500,2527,182),
	(2838,9,6,79,5648,138,'Giebelstadt, M',97232,48,5024,2562,2462,105),
	(2839,9,4,71,214,214,'Zapfendorf, M',96199,30,5023,2498,2525,164),
	(2840,8,4,37,5006,65,'Krauchenwies',72505,44,5022,2481,2541,112),
	(2841,6,6,33,24,24,'Söhrewald',34320,58,5018,2482,2536,85),
	(2842,9,3,73,160,160,'Seubersdorf i.d.OPf.',92358,68,5018,2488,2530,73),
	(2843,9,3,71,5301,126,'Hahnbach, M',92256,67,5017,2554,2463,74),
	(2844,1,0,58,5853,172,'Westerrönfeld',24784,7,5013,2466,2547,644),
	(2845,9,6,74,5612,149,'Hofheim i.UFr., St',97461,56,5007,2511,2496,89),
	(2846,8,1,26,5004,28,'Forchtenberg, Stadt',74670,38,5006,2490,2516,131),
	(2847,15,0,85,5009,30,'Aue-Fallstein',38835,118,5004,2541,2463,42),
	(2848,16,0,66,5051,13,'Breitungen/Werra',98597,44,5003,2512,2491,111),
	(2849,6,5,35,7,7,'Grebenhain',36355,91,5001,2517,2484,55);

/*!40000 ALTER TABLE `gemeinden` ENABLE KEYS */;
UNLOCK TABLES;



/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
