pdf_datei<-"balkendiagramme_mehrfach_alle.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=10.5)

par(omi=c(0.0,0.75,1.25,0.75),mai=c(1.6,3.75,0.5,0),lheight=1.15,
family="Lato Light",las=1)  

# Daten einlesen und Grafik vorbereiten

source("skripte/inc_beschriftungen_za4753.r",encoding="UTF-8")
source("skripte/inc_daten_za4753.r",encoding="UTF-8")

f1<-rgb(0,208,226,maxColorValue=255)
f2<-rgb(109,221,225,maxColorValue=255)
f3<-rgb(255,138,238,maxColorValue=255)
f4<-rgb(255,0,210,maxColorValue=255)
farben<-c("grey",f1,f2,f3,f4)

daten0<-cbind(z[,1]+z[,2],z[,3],z[,4],z[,5],z[,6])
daten1<-t(daten0)

# Grafik erstellen

x<-barplot(daten1,names.arg=namen,cex.names=1.1,horiz=T,
	border=NA,xlim=c(0,100),col=farben,axes=F)

# weitere Elemente

px<-c(2,8,35,68,98); py<-rep(9,5); tx<-c(-5,31,47,65,95); ty<-rep(9,5)
points(px,py,pch=15,cex=4,col=farben,xpd=T)
text(tx,ty,antworten,adj=1,xpd=T,family="Lato Light",font=3)
mtext(c(0,20,40,60,80,100),at=c(0,20,40,60,80,100),1,line=0,cex=0.90)

# Betitelung

mtext("Man spricht ja oft davon, dass sich heutzutage die Rollen von Mann und Frau verändern",3,line=2.2,adj=0,cex=1.8,outer=T,family="Lato Black")
mtext("Alle Angaben in Prozent",1,line=2,adj=1,cex=0.95,font=3)
mtext("Quelle: European Values Study 2008 Deutschland, ZA4753. www.gesis.org. Design: Stefan Fichtel, ixtract",1,line=4.5,adj=1,cex=0.95,font=3)
mtext("N=2.075",1,line=2,adj=0,cex=1.15,family="Lato",font=3)
dev.off()
