pdf_datei<-"balkendiagramme_mehrfach_panel.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=13,height=10.5)

par(omi=c(1.25,1.25,1.25,0.25),lheight=1.15,family="Lato Light",las=1)  
library(RColorBrewer)

# Daten einlesen und Grafik vorbereiten

source("skripte/inc_beschriftungen_za4753.r")
source("skripte/inc_daten_za4753.r")
layout(matrix(data=c(1,2,3,4,5),nrow=1,ncol=5),
		widths=c(2.5,1,1,1,1),heights=c(1,1))
		
daten1<-cbind(z[,1]+z[,2],z[,3],z[,4],z[,5],z[,6])
tdaten<-daten1
DD_pos<-c(45,45,45,45,35)
f1<-rgb(0,208,226,maxColorValue=255)
f2<-rgb(109,221,225,maxColorValue=255)
f3<-rgb(255,138,238,maxColorValue=255)
f4<-rgb(255,0,210,maxColorValue=255)
farben<-c("grey",f1,f2,f3,f4)

# Grafik erstellen

for (i in 1:5) {
if (i == 1)
{
par(mai=c(0.25,2.75,0.25,0.15))
bp1<-barplot(tdaten[ ,i],horiz=T,cex.names=1.6,names.arg=namen,
		xlim=c(0,50),col=farben[i],border=NA,axes=F)
} else
{
par(mai=c(0.25,0.1,0.25,0.15))
bp2<-barplot(tdaten[ ,i],horiz=T,axisnames=F,xlim=c(0,50),
	col=farben[i],border=NA,axes=F)
}

# weitere Elemente

rect(0,0,10,8.5,col=rgb(191,239,255,80,maxColorValue=255),border=NA)
rect(10,0,20,8.5,col=rgb(191,239,255,120,maxColorValue=255),border=NA)
rect(20,0,30,8.5,col=rgb(191,239,255,80,maxColorValue=255),border=NA)
rect(30,0,40,8.5,col=rgb(191,239,255,120,maxColorValue=255),border=NA)
rect(40,0,50,8.5,col=rgb(191,239,255,80,maxColorValue=255),border=NA)

mtext(antworten[i],3,adj=0,line=0,cex=0.95,font=3)
mtext(c(10,20,30,40,50),at=c(10,20,30,40,50),1,line=1,cex=0.85)
mtext(0,at=0,1,line=1,cex=0.90,family="Lato Bold")
arrows(0,-0.1,0,8.6,lwd=2.5,length=0,xpd=T,col="skyblue3") 
}

# Betitelung

mtext("Man spricht ja oft davon, dass sich heutzutage die Rollen von Mann und Frau verändern",3,line=3.5,adj=1,cex=1.8,family="Lato Black",outer=T)
mtext("N=2.075",1,line=3,adj=0.25,cex=1.1,family="Lato",font=4,outer=T)
mtext("Alle Angaben in Prozent",1,line=3,adj=1,cex=1.1,font=3,outer=T)
mtext("Quelle: European Values Study 2008 Deutschland, ZA4753. www.gesis.org. Design: Stefan Fichtel, ixtract",1,line=5.5,adj=1.0,cex=0.95,outer=T)
dev.off()
