pdf_datei<-"grafiktabellen_symbol_signs.pdf"
cairo_pdf(bg="grey98",pdf_datei,width=9,height=4)

par(omi=c(0.5,0.25,0.5,0.25),mai=c(0,0,0,0),family="Lato Light",cex=1.2)

# Daten einlesen

daten<-read.xls("daten/leaking_pipeline.xlsx")
attach(daten)

# Grafiken erstellen

b1<-barplot(Maenner+75,horiz=T,xlim=c(-175,175),border=NA,col="gainsboro",axes=F)
barplot(-Frauen-75,horiz=T,border=NA,add=T,col="gainsboro",axes=F)
barplot(rep(75,5),horiz=T,border=par("bg"),add=T,col=par("bg"),axes=F)
barplot(rep(-75,5),horiz=T,border=par("bg"),add=T,col=par("bg"),axes=F)
abline(v=seq(-175,195,by=10),col=par("bg"))
text(0,b1,Stufe)

# Betitelung

mtext("Die "Leaky Pipeline" (2005)",3,line=0.25,adj=0,cex=1.75,family="Lato Black",outer=T)
mtext("Quelle: Wissenschaftsrat, Drucksache Drs. 8036-07.",1,line=0.25,adj=1.0,cex=0.65,outer=T,font=3)

# Symbole

par(family="Symbol Signs")
for (i in 1:5) 
{
M_anzahl<-Maenner[i]
text(seq(10,10*round(M_anzahl/10),by=10)+73.5,rep(b1[i],5),rep("M",M_anzahl),
	cex=2.75,col="cornflowerblue")
F_anzahl<-Frauen[i]
text(-seq(10,10*round(F_anzahl/10),by=10)-68,rep(b1[i],5),rep("F",F_anzahl),
	cex=2.75,col="deeppink")
}

par(family="Lato Bold")
text(55,b1,paste(Maenner, "%", sep=" "))
text(-55,b1,paste(Frauen, "%", sep=" "))
dev.off()
