# inc_gantt_vereinfacht.r
cairo_pdf(bg="grey98", pdf_datei,width=11.7,height=8.26)
source("skripte/0inc_datendesign_grundeinstellungen.r")
par(lend=1,omi=c(0.25,1,1,0.25),mai=c(1,1.85,0.25,2.75),
	family="Lato Light",las=1)
plan<-read.xls("daten/projektplanung.xlsx")
n<-nrow(plan)
plandaten<-subset(plan,nchar(as.character(plan$von))>0)
anfang<-min(as.Date(as.matrix(plandaten[,c('von','bis')])))
ende<-max(as.Date(as.matrix(plandaten[,c('von','bis')])))
attach(plan)

plot(von,1:n,type="n",axes=F,xlim=c(anfang,ende),ylim=c(n,1))
for (i in 1:n)
{
if (nchar(as.character(Gruppe[i]))>0)
{
text(anfang-2,i,Gruppe[i],adj=1,xpd=T,cex=1.25)
}
else if (nchar(as.character(was[i]))>0)
{
x1<-as.Date(plan[i,'von'])
x2<-as.Date(plan[i,'bis'])
x3<-x1+((x2-x1)*plan[i,'erledigt']/100)
x<-c(x1,x2)
x_erl<-c(x1,x3)
y<-c(i,i)
segments(anfang, i, ende, i, col="grey")
lines(x,y,lwd=20,col=farbe[i])
points(ende+90,i,cex=(plan[i,'Personen']*plan[i,'Dauer'])**0.5,pch=19,
	col=rgb(110,110,110,50,maxColorValue=255),xpd=T)
if (x3-x1>1) lines(x_erl,y,lwd=20,col=farbe_erl)
if (plan[i,'PAG'] > 0) 
{
x4<-as.Date(plan[i,'AG_von'])
x5<-as.Date(plan[i,'AG_bis'])
x_ag<-c(x4,x5)
rect(x4,i-0.75,x5,i+0.75,lwd=2)
}
text(anfang-2,i,was[i],adj=1,xpd=T,cex=0.75)
text(ende+25,i,paste(erledigt[i],"%",sep=" "),adj=1,xpd=T,cex=0.75)
text(ende+35,i,paste(format(x1,format="%d.%m.%y"),"-",
	format(x2,format="%d.%m.%y"),sep=" "),adj=0,xpd=T,cex=0.75)
}
else # dann: ein Meilenstein
{
x3<-as.Date(plan[i,'wann'])
halbzeit<-(ende-anfang)/2
if (x3-x1<halbzeit)
{
points(as.Date(plan[i,'wann']),i,pch=18,cex=1.25,col="red")
text(as.Date(plan[i,'wann'])+5,i,Meilenstein[i],adj=0,xpd=T,cex=0.75)
} else
{
points(as.Date(plan[i,'wann']),i,pch=18,cex=1.25,col="red")
text(as.Date(plan[i,'wann'])-5,i,Meilenstein[i],adj=1,xpd=T,cex=0.75)
}
}
}
axis(3,at=c(anfang,ende),labels=c(format(anfang,format="%d. %B %Y"),
	format(ende,format="%d. %B %Y")))
heute<-as.Date("15.08.2012", "%d.%m.%Y")
abline(v=heute)

mtext("heute",1,line=0,at=heute)

# Betitelung

mtext(DD_t1,3,line=2,adj=0,cex=2.25,family="Lato Black",outer=T)
mtext(paste("Planungsstand: ",format(heute,format="%d.%m.%y"),sep=""),1,
	line=4,adj=0,at=ende+40,cex=1.25,font=3)
rect(anfang-36, n+5, anfang+40, n+4, xpd=T,lwd=2)
text(anfang-35, n+4.5, "Rahmen: Auftraggeber",xpd=T, adj=0)
