pdf_datei<-"original/karten_deutschland_3d_verschiedene_winkel.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=15,height=6.5)
source("skripte/0inc_datendesign_grundeinstellungen.r")
layout(matrix(data=c(1,2,3),nrow=1,ncol=3),widths=c(2,1.25,2),heights=c(1,1))
par(omi=c(0.5,0,0.5,0),mai=c(0,0,0,0),family="Lato Light",las=1,bg="white")  
library(scatterplot3d)
library(mapdata) 
dt.map<-map("worldHires","Germany",plot=F)
skalierung<-c(3.5,3.5,3.5)
winkel<-c(65,90,110)
for (i in 1:3)
{
s3d<-scatterplot3d(dt.map$x,dt.map$y,rep(0,length(dt.map$x)),xlab="",
	ylab="",zlab="",zlim=c(0,5),scale.y=skalierung[i],type="n",
	mar=c(0,0.35,0,0.35),box=T,axis=T,grid=F,angle=winkel[i])
s3d$points3d(dt.map$x,dt.map$y,rep(1,length(dt.map$x)),type="l")
mtext(winkel[i])
}
dev.off()
