pdf_datei<-"karten_minard_napoleon_inc.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11.69,height=7.26)

par(omi=c(1,0.1,0.75,0.1),mai=c(0.25,0,3,0),lend=1,family="Felipa",las=1)  
library(HistData); library(mapdata)

# Daten einlesen

load("daten/Minard.troops_de"); data(Minard.cities)
hin_alle<-subset(Minard.troops,Richtung=="Feldzug")
zurueck_alle<-subset(Minard.troops,Richtung=="Rückzug")

# Grafik definieren und weitere Elemente

plot(Minard.troops$long,Minard.troops$lat,type="n",axes=F,xlab="",ylab="")
for (i in 1:3)
{
hin<-hin_alle[hin_alle$group==i,]
n<-nrow(hin)-1
for (j in 1:n)
{
z<-j+1
x<-hin[j:z,]
x
lines(x$long,x$lat,type="l",col="bisque2",lwd=x$Überlebende[1]/4500)
}
zurueck<-zurueck_alle[zurueck_alle$group==i,]
n<-nrow(zurueck)-1
for (j in 1:n)
{
zurueck<-zurueck_alle[zurueck_alle$group==i,]
z<-j+1
x<-zurueck[j:z,]
x
lines(x$long,x$lat,type="l",col="azure4",lwd=x$Überlebende[1]/4500)
}
}
attach(Minard.cities)
text(long,lat,city)
fluesse<-map("rivers",plot=F,add=T)
points(fluesse$x,fluesse$y,col=rgb(0,0,255,120,maxColorValue=255),type="l")
par(xpd=T)
legend(32.5,54.15,c("300.000","200.000","100.000"),border=F,pch="|",
	col=c("bisque2","bisque2","bisque2"),bty="n",cex=1.3,pt.cex=c(3,2,1),
	xpd=NA,ncol=3)
legend(32.5,53.6,c("Feldzug","Rückzug"),border=F,pch=19,pt.cex=4,
	col=c("bisque2","azure4"),bty="n",cex=1.3,xpd=NA,ncol=3)
text(37.4,53.93,"Überlebende",cex=1.1,xpd=T)
par(family="Dr Sugiyama")

# Betitelung

mtext("Carte figurative",line=-0.5,adj=0.12,cex=3,col="azure4",outer=T)
mtext("des pertes successives en hommes de l'Armée Française dans la campagne de Russie 1812-1813",line=-0.5,adj=0.80,cex=1.5,col="azure4",outer=T)
par(family="Lato Light")
mtext(side=1,adj=0,line=3,"Quelle: www.insee.fr/fr/ffc/docs_ffc/CS126L.PDF (Text); R library histdata (Daten)",outer=T)
dev.off()

