pdf_datei<-"karten_nuts2006.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=7)

par(omi=c(0,0,0,0),mai=c(0,0,0,0),family="Lato Light",las=1)  
library(maptools)
library(rgdal)
library(RColorBrewer)

# Daten einlesen und Grafik vorbereiten

x<-readShapeSpatial("daten/NUTS-2006/NUTS_RG_03M_2006.shp",
	proj4string=CRS("+proj=longlat"))
m=spTransform(x,CRS=CRS("+proj=merc")) 
farbe<-sample(1:7,length(m),replace=T)
m$farbe<-farbe
palette<-brewer.pal(7,"Purples")

# Grafik erstellen

plot(m,xlim=c(-1000000,3000000),ylim=c(4000000,10000000),
	border=F,col=palette[m$farbe])
dev.off()

