pdf_datei<-"pyramiden_fein_innen_1x2.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=12,height=9)

par(mai=c(0.2,0.1,0.8,0.1),omi=c(0.75,0.2,0.85,0.2),mfcol=c(1,2),cex=0.75,
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

x1991<-read.xls("daten/12411-0008_1991_unformatiert.xlsx")
x1991<-x1991[1:nrow(x1991)-1,]

attach(x1991)

f_verheiratet<-X6/1000
f_nverheiratet<-(X5+X7+X8)/1000
m_verheiratet<-X2/1000
m_nverheiratet<-(X1+X3+X4)/1000

rechts<-data.frame(f_verheiratet,f_nverheiratet)
links<-data.frame(m_verheiratet,m_nverheiratet)

source("skripte/inc_pyramide.r")
mtext("1970",3,line=0,adj=0.5,cex=1,font=3)

x2010<-read.xls("daten/12411-0008_2010_unformatiert.xlsx")
x2010<-x2010[1:nrow(x2010)-1,]

attach(x2010)

f_verheiratet<-X6/1000
f_nverheiratet<-(X5+X7+X8)/1000
m_verheiratet<-X2/1000
m_nverheiratet<-(X1+X3+X4)/1000

links<-data.frame(m_verheiratet,m_nverheiratet)
rechts<-data.frame(f_verheiratet,f_nverheiratet)

source("skripte/inc_pyramide.r")

mtext("2010",3,line=0,adj=0.5,cex=1,font=3)

# Betitelung

mtext("Altersaufbau  und Verheiratete der Bevölkerung in Deutschland",3,line=2,adj=0,cex=2.25,family="Lato Black",outer=T)
mtext("alle Angaben in Tausend je Altersjahr",3,line=-0.5,adj=0,cex=1.25,font=3,outer=T)
mtext("destatis, GENESIS-Online, Tab. 12411-0008",1,line=2,adj=1.0,cex=0.95,font=3,outer=T)
mtext("Innere hervorgehobener Bereiche: vereiratet",1,line=2,adj=0,cex=0.95,font=3,outer=T)
dev.off()
