pdf_datei<-"pyramiden_zusammenfassung.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=8,height=8)

par(mai=c(0.2,0.25,0.8,0.25),omi=c(0.75,0.2,0.85,0.2),cex=0.75,
	family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

x<-read.xls("daten/bevklass.xlsx")

rechts<-t(as.matrix(data.frame(800,x$F)))
links<--t(as.matrix(data.frame(800,x$M)))

farbe_rechts<-c(par("bg"),rgb(255,0,210,150,maxColorValue=255))
farbe_links<-c(par("bg"),rgb(191,239,255,maxColorValue=255))

# Grafiken erstellen und weitere Elemente

b1<-barplot(rechts,axes=F,horiz=T,axis.lty=0,border=NA,
	col=farbe_rechts,xlim=c(-8000,8000))
barplot(links,axes=F,horiz=T,axis.lty=0,border=NA,
	col=farbe_links,xlim=c(-7500,7500),add=T)

abline(v=seq(0,6000,by=2000)+800,col="darkgrey",lty=3) 
abline(v=seq(-6000,0,by=2000)-800,col="darkgrey",lty=3) 

mtext(format(seq(0,6000,by=2000),big.mark="."),
	at=seq(0,6000,by=2000)+800,1,line=0,cex=0.95)
mtext(format(abs(seq(-6000,0,by=2000)),big.mark="."),
	at=seq(-6000,0,by=2000)-800,1,line=0,cex=0.95)
text(0,b1,x$bez,cex=1.25,font=3)

mtext("Männer",3,line=1,adj=0.25,cex=1.5,col="darkgrey")
mtext("Frauen",3,line=1,adj=0.75,cex=1.5,col="darkgrey")

# Betitelung

mtext("Altersaufbau der Bevölkerung in Deutschland 2010",3,line=2,adj=0,cex=1.75,family="Lato Black",outer=T)
mtext("Angaben in Tausend je Altersjahr",3,line=-0.5,adj=0,cex=1.25,font=3,outer=T)
mtext("Quelle: www.destatis.de/bevoelkerungspyramide, eigene Berechnungen",1,line=2,adj=1.0,cex=0.95,font=3,outer=T)
mtext("",1,line=2,adj=0,cex=0.95,font=3,outer=T)
dev.off()

