pdf_datei<-"streudiagramme_ausreisser.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11.69,height=9)

par(mar=c(4,4,0.5,2),omi=c(0.5,0.5,1,0),family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

strukturdaten<-read.csv(file="daten/struktbtwkr2005.csv",
	head=F,sep=";",dec=".")
daten<-subset(strukturdaten,V2 > 0 & V34 > 10)
attach(daten)

xbez<-"Arbeitslose (%)"
ybez<-"Wanderungssaldo (je 1.000 Einwohner)"

# Grafik definieren und weitere Elemente

plot(type="n",xlab=xbez,ylab=ybez,V34,V21,xlim=c(10,26),
	ylim=c(-20,35),axes=F,cex.lab=1.2)
axis(1,lwd.ticks=0.5,cex.axis=1.15,tck=-0.015)
axis(2,lwd.ticks=0.5,cex.axis=1.15,tck=-0.015)

f1<-rgb(0,208,226,200,maxColorValue=255)
f2<-rgb(255,0,210,150,maxColorValue=255)

fit<-lm(V21 ~ V34)
daten$fit<-fitted(fit)
points(V34,daten$fit,col=f2,type="l",lwd=8)

daten$resid<-residuals(fit)
daten.sort<-daten[order(-abs(daten$resid)) ,]
daten.sort_anfang<-daten.sort[1:5,]

p1<-daten.sort[5+1:length(daten$fit),c("V34","V21")]
p2<-daten.sort_anfang[c("V34","V21")]

r1<-sqrt(daten.sort$V6)/10
r2<-sqrt(daten.sort_anfang$V6)/10

symbols(p1,circles=r1,inches=0.3,bg=f1,fg="white",add=T)
symbols(p2,circles=r2,inches=0.3,bg=f2,fg="white",add=T)

text(p2,iconv(as.matrix(daten.sort_anfang["V3"]),"LATIN1","UTF-8"),
	cex=0.65,pos=3,offset=1.1)

abline(v=mean(V34,na.rm=T),col="black",lty=3)
abline(h=mean(V21,na.rm=T),col="black",lty=3)


text(20,20, "Die fünf größten Abweichungen sind hervorgehoben.\n\nPunktgröße: Wahlkreisfläche", adj=0)

# Betitelung

mtext("Arbeitslose, Zu- und Abwanderungen in Deutschland 2005",3,adj=0,line=2,cex=2.5,outer=T,family="Lato Black")
mtext("Kreisebene, Arbeitslosenquote über 10 Prozent",3,adj=0,line=0,cex=1.5,outer=T,font=3)
mtext("Quelle: www.bundeswahlleiter.de",1,line=4,adj=1,cex=1.15,font=3)
dev.off()

