pdf_datei<-"zeitreihen_flaechen_zwischen.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11.69,height=8.27)

par(mai=c(1,1,0.5,0.5),omi=c(0,0.5,1,0),family="Lato Light",las=1)

# Daten einlesen und Grafik vorbereiten

rs<-read.xlsx("daten/B1_01.xls",1,header=F)
farbe1_150<-rgb(68,90,111,150,maxColorValue=255) 
farbe1_50<-rgb(68,90,111,50,maxColorValue=255)   
farbe2_150<-rgb(255,97,0,150,maxColorValue=255)  
farbe2_50<-rgb(255,97,0,50,maxColorValue=255)    
attach(rs)

# Grafik definieren und weitere Elemente

plot(X1,X11,axes=F,type="n",xlab="",ylab="Anzahl (je 100 Tsd. Einwohner)",
	cex.lab=1.5,xlim=c(1820,2020),ylim=c(10,40),xpd=T)
axis(1,at=c(1820,1870,1920,1970,2010))
axis(2,at=c(10,15,20,25,30,35,40),col=par("bg"),col.ticks="grey81",
	lwd.ticks=0.5,tck=-0.025)
lines(X1,X11,type="l",col=farbe1_150,lwd=3,xpd=T)
lines(X1,X12,type="l",col=farbe2_150,lwd=3)
text(1910,35,"Lebendgeborene",adj=0,cex=1.5,col=farbe1_150)
text(1850,22,"Gestorbene",adj=0,cex=1.5,col=farbe2_150)
beginn<-c(1817,1915,1919,1972); ende<-c(1914,1918,1971,2000)
farbe<-c(farbe1_50,farbe2_50,farbe1_50,farbe2_50)
for (i in 1:length(beginn))
{
mysubset<-subset(rs,X1 >= beginn[i] & X1 <= ende[i])
attach(mysubset)
xx<-c(mysubset$X1,rev(mysubset$X1)); yy<-c(mysubset$X11,rev(mysubset$X12))
polygon(xx,yy,col=farbe[i],border=F)
}

# Betitelung

mtext("Lebendgeborene und Gestorbene in Deutschland 1820–2010",3,line=1.5,adj=0,family="Lato Black",cex=2.2,outer=T)
mtext("Jahreswerte",3,line=-0.75,adj=0,font=3,cex=1.8,outer=T)
mtext("Quelle: gesis.org/histat",1,line=3,adj=1,cex=1.2,font=3)
dev.off()
