pdf_datei<-"zeitreihen_monatswerte_monatsbeschriftung.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11,height=4.8)

source("skripte/0inc_datendesign_dbconnect.r")
par(cex=0.75,bg=rgb(240,240,240,maxColorValue=255))
par(omi=c(0.75,0.25,0.5,0.25),mai=c(0.25,0.55,0.25,0),mgp=c(2,1,0),
	family="Lato Light",las=1)  
farbe1<-rgb(255,0,0,150,maxColorValue=255)
farbe2<-rgb(0,0,0,150,maxColorValue=255)

# Daten einlesen

sql<-"select concat_ws('-',jahr,monat,'01') monat, v8, v9 from t_za2391_zeitreihen where jahr >= 2002"
dataset<-dbGetQuery(con,sql)
attach(dataset)

# Grafik definieren und weitere Elemente

plot(type="n",axes=F,xlab="",ylab="Mittelwert",as.Date(monat),v8,
	col=rgb(255,97,0,150,maxColorValue=255),lwd=2,ylim=c(-1,2))

manfang<-seq(as.Date("2002-01-01"),as.Date("2008-01-01"),by="1 months")
janfang<-seq(as.Date("2002-01-01"),as.Date("2008-01-01"),by="1 years")
abline(v=janfang,col="lightgrey")

points(as.Date(monat),v8,col=farbe1,lwd=5,type="l")
points(as.Date(monat),v9,col=farbe2,lwd=5,type="l")

text(as.Date("2007-10-01"),0.5,"SPD",col=farbe1,cex=1.5)
text(as.Date("2007-10-01"),1.5,"CDU",col=farbe2,cex=1.5)

axis(1,col=rgb(60,60,60,maxColorValue=255),at=manfang,
	labels=format(manfang,"%b\n%Y"),cex.axis=0.85,
	lwd.ticks=0.1,tck=-0.02)
axis(2,col=rgb(240,240,240,maxColorValue=255),
	col.ticks=rgb(60,60,60,maxColorValue=255),lwd.ticks=0.5,
	cex.axis=0.85,tck=-0.025,pos=as.Date("2001-12-15"))

# Betitelung

mtext("Politbarometer 2002–2007",3,line=0,adj=0,cex=1.5,family="Lato Black",outer=T)
mtext("Monatswerte. Quelle: ZA2391 Partielle Kumulation der  Politbarometer West 1977-2007",1,line=2,adj=1.0,cex=0.85,font=3,outer=T)
dev.off()

