pdf_datei<-"lorenzkurven_10.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=6.5,height=7.25)

par(mai=c(0,0,0,0),omi=c(0.75,0.5,0.85,0.2),pin=c(4,4),
	family="Lato Light",las=1)
	
# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/einkommen_zehn_klassen.xlsx",head=T,skip=1,dec=".")
attach(daten)
G<-rep(10,10)
G_kum<-c(0,cumsum(G/100))
U2_kum<-c(0,cumsum(U2/100))

# Grafik definieren und weitere Elemente

plot(G_kum,U2_kum,type="n",axes=F,xlab="aufsummierter Anteil Bevölkerung",
	ylab="aufsummierter Anteil Einkommen",xlim=c(0,1),ylim=c(0,1))
lines(G_kum,U2_kum,lwd=2)
points(G_kum,U2_kum,pch=19)
x<-array(c(0,1,0,1),dim=c(2,2))
lines(x,lwd=2,col="black")
text(0.12,0.585,"Gleichverteilung",adj=c(0,0))
text(0.72,0.265,"Ungleichheit",adj=c(0,0))
arrows(0.4,0.28,0.7,0.28,length=0.10,angle=10,code=1,lwd=2,col="black")
arrows(0.49,0.6,0.6,0.60,length=0.10,angle=10,code=2,lwd=2,col="black")
xx<-c(G_kum,rev(G_kum))
yy<-c(U2_kum,rev(G_kum))
polygon(xx,yy,col=rgb(255,97,0,50,maxColorValue=255),border=F)
source("skripte/inc_achsen_mit_linien_lorenz.r")

# Betitelung

mtext("Einkommensverteilung in den USA im Jahr 2000 ",side=3,line=1,cex=1.5,family="Lato Black",adj=0,outer=T)
mtext("(10 Klassen)",side=3,line=-1.5,cex=1.25,font=3,adj=0,outer=T)
mtext("Source: United Nations University, UNU-WIDER World Income Inequality Database",1,line=1,adj=1,cex=0.85,font=3,outer=T)
dev.off()


