pdf_datei<-"radial_polygone_2x3.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=12,height=12)

par(mfcol=c(2,3),omi=c(1,0.5,1,0.5),mai=c(0,0,0,0),cex.axis=0.9,
	cex.lab=1,xpd=T,col.axis="green",col.main="red",
	family="Lato Light",las=1)
library(plotrix)

# Daten einlesen und Grafik vorbereiten

regionen<-read.xls("daten/weltenergiemix.xlsx")
row.names(regionen)<-regionen$Region
regionen$Region<-NULL
beschriftung<-c("Öl","Kohle","Gas","Erneuerbare E.","Kernenergie")

regionen<-regionen[, c(1,3,2,4,5)]
beschriftung<-beschriftung[c(1, 3, 2, 4, 5)]

# Grafiken erstellen

for (i in 2:nrow(regionen))
{
radial.plot(rep(100/length(regionen),length(regionen)),
	labels=beschriftung,rp.type="p",main="",line.col="grey",
	show.grid=F,radial.lim=c(0,55),poly.col="grey")
radial.plot(regionen[i,],labels="",rp.type="p",main="",
	line.col="red",show.grid=F,radial.lim=c(0,55),poly.col="red",add=T)
mtext(row.names(regionen)[i],line=2,family="Lato Black")
}

# Betitelung

mtext("Energiemix in Regionen der Welt",line=2,cex=3,family="Lato Black",outer=T,adj=0)
mtext(line=-1,"Anteile verschiedener Energiearten am Gesamtenergieverbrauch",cex=1.5,font=3,outer=T,adj=0)
mtext(side=1,"Quelle: Bundeszentrale für politische Bildung: Stichwort 'Energiemix', www.bpb.de",line=2,cex=1.3,font=3,outer=T,adj=1)
dev.off()
