pdf_datei<-"radial_polygone_uebereinander.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=10,height=10)

par(omi=c(1,0.25,1,1),mai=c(0,2,0,0.5),cex.axis=1.5,cex.lab=1,xpd=T,
	family="Lato Light",las=1)
library(plotrix)

# Daten einlesen und Grafik vorbereiten

regionen<-read.xls("daten/weltenergiemix.xlsx")
f1<-rgb(80,80,80,155,maxColorValue=255)
f2<-rgb(255,97,0,155,maxColorValue=255)
regionen$Region<-NULL
beschriftung<-c("Öl","Kohle","Gas","Erneuerbare Energien","Kern-\nenergie")

# Grafik erstellen

radial.plot(regionen[2:3,],start=1,grid.left=T,labels=beschriftung,
	rp.type="p",main="",line.col=c(f1,f2),poly.col=c(f1,f2),show.grid=T,
	radial.lim=c(0,55),lwd=8)
legend("bottomleft",c("OECD","Asien"),pch=15,col=c(f1,f2),bty="n",cex=1.5)

# Betitelung

mtext(line=3,"Energiemix: OECD und Asien im Vergleich",cex=2.5,adj=0,family="Lato Black")
mtext(line=1,"Alle Angaben in Prozent",cex=1.5,adj=0,font=3)
mtext(side=1,line=2,"Quelle: Bundeszentrale für politische Bildung: Stichwort 'Energiemix', www.bpb.de",cex=1.25,adj=1,font=3,outer=T)
dev.off()
