pdf_datei<-"zeitreihen_flaechen_unterhalb_inc.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=11.69,height=8.26)

par(cex.axis=1.1,mai=c(0.75,1.5,0.25,0.5),omi=c(0.5,0.5,1.1,0.5), mgp=c(6,1,0),
	family="Lato Light",las=1)
	
# Daten einlesen und Grafik vorbereiten

farbe<-rgb(68,90,111,150,maxColorValue=255)
daten<-read.xls("daten/chile.xlsx")
attach(daten)

# Grafik definieren und weitere Elemente

plot(x,y,axes=F,type="n",xlab="",xlim=c(1800,2020),ylim=c(0,14000),xpd=T,
	ylab="million 1990 International Geary-Khamis dollars")
axis(1,at=pretty(x),col=farbe)
axis(2,at=py<-pretty(y),col=farbe,cex.lab=1.2,
	labels=format(py,big.mark="."))

y<-ts(y,start=1800,frequency=1)
points(window(y, end=1869))
lines(window(y, start=1870))

shapefarbe1<-rgb(0,128,128,50,maxColorValue=255)
shapefarbe2<-rgb(0,128,128,80,maxColorValue=255)
auswahl<-subset(daten,x >= 1879 & x <= 1884)
attach(auswahl)
polygon(c(min(auswahl$x),auswahl$x,max(auswahl$x)),
	c(-500,auswahl$y,-500),col=shapefarbe2,border=NA)
text(1860,2200,adj=0,col=farbe,"Pacific War")
auswahl<-subset(daten,x >= 1940 & x <= 1973)
attach(auswahl)
polygon(c(min(auswahl$x),auswahl$x,max(auswahl$x)),
	c(-500,auswahl$y,-500),col=shapefarbe1,border=NA)
text(1930,5000,adj=0,col=farbe,"Allende Regime")
auswahl<-subset(daten,x >= 1973 & x <= 1990)
attach(auswahl)
polygon(c(min(auswahl$x),auswahl$x,max(auswahl$x)),
	c(-500,auswahl$y,-500),col=shapefarbe2,border=NA)
text(1960,6800,adj=0,col=farbe,"Militärregime")

# Betitelung

mtext("Bruttosozialprodukt von Chile 1820–2008",3,line=2,adj=0,cex=2.4,family="Lato Black", outer=T)
mtext("Jahreswerte",3,line=-0.5,adj=0,cex=1.8,font=3, outer=T)
mtext("Quelle:  Rolf Lüders, The Comparative Economic Performance of Chile 1810-1995, www.ggdc.net/maddison",1,line=3,adj=1.0,cex=0.95,font=3)
dev.off()

