pdf_datei<-"zeitreihen_saison_minmax_2x1.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=14,height=7)

par(omi=c(0.25,0.25,0.5,0.25),mai=c(0.45,0.35,0.5,0),mfcol=c(1,2),
	family="Lato Light",las=1)  
library(gplots)

# Daten einlesen und Grafik vorbereiten

daten<-read.xls("daten/Klima.xlsx")
attach(daten)
linien<-c(-5,0,5,10,15,20,25,30)

# Grafiken erstellen und weitere Elemente

t1<-barplot2(t(cbind(NY_min,NY_max-NY_min)),col=c(NA,"coral3"),
	border=NA,names.arg=Monat,ylim=c(-5,35),panel.first=abline(h=linien,
	col="grey",lwd=1,lty="dotted"),axes=F)
for (i in 1:length(linien)) {text(-0.8,linien[i]+1.1,linien[i],xpd=T)}
text(-0.25,33,"Grad Celisus",xpd=T,cex=0.8)
mtext(side=3,"New York",cex=1.5,col=rgb(64,64,64,maxColorValue=255))
t2<-barplot2(t(cbind(MAL_min,MAL_max-MAL_min)),col=c(NA,"cornflowerblue"),
	border=NA,names.arg=Monat,ylim=c(-5,35),panel.first=abline(h=linien,
	col="grey",lwd=1,lty="dotted"),axes=F)

# Betitelung

mtext(side=3,"Mallorca",cex=1.5,col=rgb(64,64,64,maxColorValue=255))
mtext(side=3,"Monatliche Durchschnittstemperaturen",cex=1.5,family="Lato Black",outer=T)
mtext(side=1,"Quelle: Wikipedia",cex=0.75,adj=1,font=3,outer=T)
dev.off()
