pdf_datei<-"zeitreihen_tageswerte_wochensymbole_3x1.pdf"
cairo_pdf(bg="grey98", pdf_datei,width=9,height=8.27)

par(mfcol=c(3,1),cex.axis=1.4,omi=c(1,0.5,0.75,0.5),
	mai=c(0.1,0.2,0.1,0.2),family="Lato Light",las=1) 

# Grafik vorbereiten und Daten einlesen

land<-c("US","GB","DE")
landbezeichnung<-c("USA","Großbritannien","Deutschland")
for (i in 1:length(land)) 
{
datei<-paste("daten/Facebook Happiness Index-",land[i],".csv",sep="")
daten<-read.csv(datei,skip=1)
daten$x<-as.Date(daten$Date)
daten<-subset(daten,daten$x>"2010-10-01")

# Grafik definieren und weitere Elemente

plot(daten$x,daten$GNH,type="n",axes=F,ylab="",ylim=c(-0.05,0.4))
points(daten$x,daten$GNH,type="l",col="darkblue")

daten$jahr<-as.numeric(format(daten$x,"%Y"))
daten$kw<-as.numeric(format(daten$x,"%V"))
neudaten<-daten[order(daten$jahr,daten$kw,daten$GNH),]
tag<-NULL
farbe<-NULL
n<-nrow(neudaten)-1
for (j in 1:n) 
{
if(neudaten$kw[j+1] != neudaten$kw[j]) 
{
	tag<-c(tag,as.character(neudaten$x[j]))
	farbe<-c(farbe,weekdays(neudaten$x[j]))
}
}
farbe<-as.numeric(as.factor(farbe))
points(as.Date(tag),rep(-0.05,length(tag)),pch=15,cex=1.5, col=farbe)

mtext(landbezeichnung[i],3,line=-3,adj=0,cex=1.3,font=3)
source("skripte/inc_tageswerte_wochensymbole_datumsbeschriftungen.r")
}
axis(1,at=daten$x[c(1,length(daten$x))],
	labels=format(daten$x[c(1,length(daten$x))],"%d. %b. %Y "))
mtext("Glücklichster Tag in der Woche:",1,line=3,adj=0,cex=0.9,font=3,outer=T)
legend(as.Date("2010-08-22"),-0.21,c("Mo","Di","Mi","Do","Fr","Sa","So"),
	pch=15,col=c(1,2,3,4,5,6,7),ncol=7,bty="n",xpd=NA,cex=1.5)

# Betitelung

mtext("Facebook Gross National Happiness Index 2010–2012",3,line=1,adj=0,cex=2,family="Lato Black",outer=T)
mtext("Tageswerte. Quelle: www.facebook.com",1,line=4.25,adj=1,cex=0.9,font=3,outer=T)
dev.off()

