import java.util.*;

/**
 * A simple dictionary to illustrate the ArrayList in use.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class Dictionary
{
    // Instance variables
    private ArrayList<String> words;

    /**
     * Constructor for Dictionary
     */
    public Dictionary()
    {
        // Initialise the ArrayList
        words = new ArrayList<String>();
        addInitialWords();
    }

    /** 
     * Adds some initial words to the words ArrayList.
     * @param none
     * @return none
     */
    public void addInitialWords()
    {   
        words.add("crocodile");
        words.add("antelope");
        words.add("gnu");
        words.add("zebra");
        words.add("giraffe");
    }

    /** 
     * Display all words in the ArrayList
     * @param none
     * @return none
     */
    public void displayAllWords()
    {
        for (int i=0; i<words.size(); i++)
        {
            // Retrieve the String at position i
            String w = words.get(i);
            System.out.println(w);
        }
    }
    
    /** 
     * Display all words in the ArrayList using for each
     * @param none
     * @return none
     */
    public void displayAllWords2()
    {
        for (String w:words)
        {
            System.out.println(w);
        }
    }
    /**
     * Add a new word to the ArrayList
     * @param word as a String
     * @return true if the word added is unique, false otherwise
     */
    public boolean addNewWord(String w)
    {
        if (checkWord(w) == false)
        {
            words.add(w);
            return true;
        }
        else
        {
            return false;
        }
    }
    
    /**
     * check to see whether a word is in the dictionary
     * @param word as a String
     * @return true if the word is present in the dictionary
     */
    public boolean checkWord(String w)
    {
        boolean x;
        x = words.contains(w);
        if (x == true)
        {
            // w is already in the dictionary
            return false;
        }
        else
        {
            return true;
        }
    }
    
}
