/**
 * An example to demonstrate multi-dimensional arrays.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class TicTacToeBoard
{
    private char[][] board;
    
    public TicTacToeBoard()
    {
        board = new char[3][3];
        for (int row=0; row<board.length; row++)
        {
            for (int col=0; col<board[row].length; col++)
            {
                board[row][col] = '-';
            }
        }
    }
    
    public void fillSpaceOnBoard(int row, int col, char value)
    {
        if ((row < board.length)&&(col < board[row].length))
        {
            board[row][col] = value;
        }
    }
    
    public void displayBoard()
    {
        for (int row=0; row < board.length; row++)
        {
            for (int col=0; col < board[row].length; col++)
            {
                System.out.print(board[row][col] + " ");
            }
            System.out.println();
        }
    }
    
    public void makeSomeMoves()
    {
        fillSpaceOnBoard(1,1,'X');
        fillSpaceOnBoard(0,2,'O');
        displayBoard();
    }
   
}
