import java.util.*;

/**
 * Example of a HashSet in action.
 * 
 * @author Kingsley Sage 
 * @version 1.0
 */
public class HashSetDemo
{
    private HashSet<Card> cardPack;
    
    public HashSetDemo()
    {
        // We happen to know there are at 
        // most exactly 52 max cards.
        cardPack = new HashSet<Card>(52);
        Card c1 = new Card('A',"Spades");
        Card c2 = new Card('2',"Spades");
        Card c3 = new Card('3',"Spades");
        
        // Could just keep on adding cards ...
        cardPack.add(c1); // ignoring returned value
        cardPack.add(c2);
        cardPack.add(c3);
        
        // Now the size is 3 ...
        showSize();
        
        // Now try to add c1 again ...
        cardPack.add(c1);
        
        // Size remains the same.
        showSize();
        
        // But we can create another distinct object
        // with the same internal data ...
        Card c4 = new Card('A',"Spades");
        cardPack.add(c4);
        
        // Size is now 4 ...
        showSize();
    }
    
    public void showSize()
    {
        System.out.println("Number of elements: " 
                          + cardPack.size());       
    }
}
