import java.awt.*;
import javax.swing.*;

/**
 * A thread driven version of "Hello World"
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class HelloWorld implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Our first Swing application");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create a button
        JButton b = new JButton("You can press me!");
        // Create a place where we can put some text
        JLabel label1 = new JLabel("Hello World");
        // Add the button and the label to the panel
        p.add(label1);
        p.add(b);
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }
    
    public static void main(String[] args)
    {
        // Create an instance of this class
        HelloWorld hw = new HelloWorld();
        // Schedule the application to run
        SwingUtilities.invokeLater(hw);
    }
}
