import java.awt.*;
import javax.swing.*;
import javax.swing.border.Border;

/**
 * An example of a GridLayout in action.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class GridLayoutExample implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("GridLayoutExample");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel organised using GridLayout
        // with a horizontal and vertical gap of 10
        // between the labels
        JPanel p = new JPanel(new GridLayout(3,3,10,10));
        // Add a 3 x 3 grid of JLabels 
        for (int y=0; y<3; y++)
        {
            for (int x=0; x<3; x++)
            {
                // Show position as (x,y), with centred text
                JLabel j = new JLabel("(" + x +"," + y +")",
                              SwingConstants.CENTER);
                // Add a border to the label
                Border b = BorderFactory.createLineBorder(Color.BLACK);
                j.setBorder(b);
                // Add to the panel
                p.add(j);
            }
        }
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }
    
    public static void main(String[] args)
    {
        // Create an instance of this class
        GridLayoutExample g = new GridLayoutExample();
        // Schedule the application to run
        SwingUtilities.invokeLater(g);
    }
}
