import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A Swing GUI for the NumberApp class.
 * Complete with Menu bar wth two options.
 * 
 * @author Kingsley Sage 
 * @version 1.0
 */
public class NumberAppGUI implements Runnable
{
    // An instance of Number app is required
    private NumberApp app;
    
    public NumberAppGUI()
    {
        // Create an instance of NumberApp
        app = new NumberApp();
    }
    
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Number app");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create two buttons
        JButton up = new JButton("Up");
        JButton down = new JButton("Down");
        // Create a place where we can put some text
        JLabel label1 = new JLabel(app.getValueAsString());
        // Add the button and the label to the panel
        p.add(label1);
        // Link independent listeners for the buttons
        up.addActionListener(new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    if (app.incValue() == true)
                    {
                        label1.setText(app.getValueAsString());
                    }
                    else
                    {
                        showWarning(f);
                    }
                }
            }
        );
        down.addActionListener(new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    if (app.decValue() == true)
                    {
                        label1.setText(app.getValueAsString());
                    }
                    else
                    {
                        showWarning(f);
                    }
                }
            }
        );
        p.add(up);
        p.add(down);
        //Set the contentPane size
        pane.setSize(220,100);
        p.setPreferredSize(new Dimension(240,120));
        // Add the panel to the frame
        f.add(p);
        // Add the menu bar
        makeMenuBar(f);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    public void showWarning(JFrame f)
    {
        JDialog d;
        d = new JDialog(f, "Alert");
        d.setSize(100,100);
        JLabel x = new JLabel("Range 0 to 10!");
        d.setLocation(250,200);
        d.add(x);
        d.setVisible(true);
    }
    
    public void makeMenuBar(JFrame f)
    {
        JMenuBar m = new JMenuBar();
        // set the menu bar for the frame f
        f.setJMenuBar(m);
        // Create the "Options" menu
        JMenu optionsMenu = new JMenu("Options");
        // Now add some items to the menu
        JMenuItem aboutItem = new JMenuItem("About");
        JMenuItem quitItem = new JMenuItem("Quit");
        // Now we add some listeners for the menu items
        aboutItem.addActionListener((event) -> showAbout(f));
        quitItem.addActionListener((event) -> System.exit(0));
        // Add the items to the menu
        optionsMenu.add(aboutItem);
        optionsMenu.add(quitItem);
        // Finally, add the menu to the menu bar
        m.add(optionsMenu);
    }
    
    public void showAbout(JFrame f)
    {
        JOptionPane.showMessageDialog(f,"Created by Kingsley Sage \nEnjoy!");
    }
    
    public static void main(String[] args)
    {
        // Create an instance of this class
        NumberAppGUI gui = new NumberAppGUI();
        // Schedule the application to run
        SwingUtilities.invokeLater(gui);
    }
}
