

import static org.junit.Assert.*;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * The test class NumberAppTest.
 *
 * @author  Kingsley Sage
 * @version 1.0
 */
public class NumberAppTest
{
    /**
     * Default constructor for test class NumberAppTest
     */
    public NumberAppTest()
    {
    }

    /**
     * Sets up the test fixture.
     *
     * Called before every test case method.
     */
    @Before
    public void setUp()
    {
    }

    /**
     * Tears down the test fixture.
     *
     * Called after every test case method.
     */
    @After
    public void tearDown()
    {
    }
    /**
     * To test the actual application
     */
    @Test
    public void test()
    {
        NumberApp n = new NumberApp();
        // value should be zero initially ...
        assertEquals(n.getValueAsString(),"0");
        // try to decrease by 1, should stay at 0 ...
        n.decValue();
        assertEquals(n.getValueAsString(),"0");
        // Increase to 3 ...
        n.incValue();
        n.incValue();
        n.incValue();
        assertEquals(n.getValueAsString(),"3");
        // reset to 0 ...
        n.resetCount();
        assertEquals(n.getValueAsString(),"0");
        // Increase to 10;
        for (int i=0; i<10; i++)
        {
            n.incValue();
        }
        assertEquals(n.getValueAsString(),"10");
        // Try to inc again, should stay at 10
        n.incValue();
        assertEquals(n.getValueAsString(),"10");
    }
}
