import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An example incorporating two buttons and a 
 * centralised event listener.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class TwoButtonsCentralisedControl implements Runnable
{
    // These elements need to be instance variables so they
    // are accessible throughout the class
    private JButton b1;
    private JButton b2;
    private JLabel label1;

    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Two buttons");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create two buttons
        b1 = new JButton("Set to Yes");
        b2 = new JButton("Set to No");
        // Create a place where we can put some text
        label1 = new JLabel("----");
        // Add the button and the label to the panel
        p.add(label1);
        // Create the instance of the centralised listener
        CentralisedListener c = new CentralisedListener();
        // Link the buttons to the listener
        b1.addActionListener(c);
        b2.addActionListener(c);
        p.add(b1);
        p.add(b2);
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    public static void main(String[] args)
    {
        // Create an instance of this class
        TwoButtonsCentralisedControl app = 
            new TwoButtonsCentralisedControl();
        // Schedule the application to run
        SwingUtilities.invokeLater(app);
    }

    private class CentralisedListener implements ActionListener
    {
        // Implement the requirements of the ActionListener
        // interface - provide the actionPerformed() method
        public void actionPerformed(ActionEvent e)
        {
            // Interrogate e ...
            if (e.getSource() == b1)
            {
                label1.setText("Yes");
            }
            else if (e.getSource() == b2)
            {
                label1.setText("No ");
            }
        }
    }
}

