import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * An example incorporating two independent buttons. 
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class TwoIndependentButtons implements Runnable
{
    public void run()
    {
        // First create the JFrame window
        JFrame f = new JFrame("Two buttons");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        JPanel p = new JPanel();
        // Create two buttons
        JButton b1 = new JButton("Set to Yes");
        JButton b2 = new JButton("Set to No");
        // Create a place where we can put some text
        JLabel label1 = new JLabel("----");
        // Add the button and the label to the panel
        p.add(label1);
        // Add the buttons and the label to the panel
        p.add(label1);
        // Link independent listeners for the buttons
        b1.addActionListener(new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    label1.setText("Yes");
                }
            }
        );
        b2.addActionListener(new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    label1.setText("No ");
                }
            }
        );
        p.add(b1);
        p.add(b2);
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    public static void main(String[] args)
    {
        // Create an instance of this class
        TwoIndependentButtons app = 
            new TwoIndependentButtons();
        // Schedule the application to run
        SwingUtilities.invokeLater(app);
    }

}

