import static org.junit.Assert.*;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * The test class CustomerTest.
 *
 * @author  Kingsley Sage
 * @version 1.0
 */
public class CustomerTest
{
    /**
     * Default constructor for test class CustomerTest
     */
    public CustomerTest()
    {
    }

    /**
     * Sets up the test fixture.
     *
     * Called before every test case method.
     */
    @Before
    public void setUp()
    {
    }

    /**
     * Tears down the test fixture.
     *
     * Called after every test case method.
     */
    @After
    public void tearDown()
    {
    }
    
    @Test
    /** Create a customer, add some items to their order.
     */
    public void placeAnOrder()
    {
        Customer c = new Customer("Smith","John","1 The Avenue");

        c.addItemToOrder(new Fruit("Apples",0.20,5));
        c.addItemToOrder(new Vegetable("potatoes",1.0, 2.0));
        c.addItemToOrder(new HealthyCake("Chocolate Cake",10.00, "Happy Birthday"));
        
        // Delete the potatoes for now ...
        c.deleteItemFromOrder(1);
        assertEquals(c.getOrder().getNumberOfItems(),2);
        
        // Calculate the costs and delivery charges
        // 5 apples and the cake should be £11.00
        // with a delivery charge of £5.00.
        // Costs are compared to the nearest penny.
        double cost = c.calculateTotalCost();
        assertEquals(cost,16.00,0.01);
        
        // Summarise the order ...
        c.summariseOrder(); 
        
    }
}
