import java.util.*;

/**
 * Represents GoodLifeFoods as a complete entity.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class GoodLifeFoods
{

    HashMap<String,Customer> allOrders; // All orders
    ArrayList<Customer> allCustomers;   // All our customers
    
    /*
     * Constructor for GoodLifeFoods
     */
    public GoodLifeFoods()
    {
        allOrders = new HashMap<String, Customer>();
        allCustomers = new ArrayList<Customer>();
    }
    
    /**
     * Registers a customer.
     * @param lastname as a String.
     * @param firstname as a String.
     * @param address as a String.
     * @return Customer object.
     */
    public Customer registerCustomer(String lastname, String firstname, String address)
    {
        Customer c = new Customer(lastname, firstname, address);
        c.displayDetailsOfOrder();
        allCustomers.add(c);
        return c;
    }
    
    /**
     * Place an order for a customer. 
     * @param Customer object c.
     */
    public void placeOrderForCustomer(Customer c)
    {        
        // Add the order to our collection of orders
        allOrders.put(c.getLastName(), c);
        
        // Process the order
        processCustOrder(c);
    }
    
    /**
     * Recover an order based on the unique order reference.
     * @param unique order refernce as a String.
     * @return the Customer object containing the order.
     */
    public Customer recoverOrder(String uniqueReference)
    {
        // Locate the customer in allOrders using the reference ...
        Customer c = allOrders.get(uniqueReference);
        
        // Summarise the order
        c.summariseOrder();
        
        return c;
    }
    
    /** 
     * Causes goods to be packed and sent to the customer.
     * Goods are specified in Order within Customer object c.
     * @param Customer object c.
     */
    public void processCustOrder(Customer c)
    {
        // Whatever is needed to process the order
    }
    
    /**
     * A factory method to generate a unique reference
     * for any order. For now, we generate a random numer
     * and convert it to a String. There is currently
     * no guarantee that references will be unique.
     * @return a uniqueReference as a String
     */
    public static String genUniqueReference()
    {
        Random r = new Random();
        int ref = r.nextInt(1000);
        return "" + ref;
    }
    
}
