import java.util.*;

/**
 * An Order placed by a Customer on the GoodLifeFoods site
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class Order
{
    private String uniqueReference;
    private ArrayList<Item> allItems;
    private double costOfItems;
    private double deliveryCharge;

    /**
     * Constructor.
     * @param uniqueReference as a String. The
     * reference values are generated by a factory
     * method in GoodLifeFoods.
     */
    public Order(String uniqueReference)
    {
        allItems = new ArrayList<Item>();
        costOfItems = 0.0;
        deliveryCharge = 0.0;
        this.uniqueReference = uniqueReference;
    }
    
    /**
     * Displays a summary of this order.
     */
    public void summarise()
    {
        System.out.println("Order reference: " + uniqueReference);
        System.out.println("Your order is as follows:");
        for (int i=0; i< allItems.size(); i++)
        {
            allItems.get(i).describeItem();
        }
        // And display the costs
        System.out.println("Cost of items is: £" + 
                           String.format("%.2f",costOfItems));
        System.out.println("Delivery charge is: £" + 
                           String.format("%.2f",deliveryCharge));
    }
    
    /**
     * Calculates the total cost for this order
     * including delivery charges.
     * @return total cost in pounds as a double.
     */
    public double calculateTotalCost()
    {
        double totalCost = 0.0;
        
         // First the cost of all of the items in the order
        for (int i=0; i<allItems.size(); i++)
        {
            costOfItems = costOfItems + allItems.get(i).calculateCost();
        }
        // Now the delivery charge
        if (costOfItems >= 30.0)
        {
            deliveryCharge = 0.0;
        }
        else if (costOfItems >= 10.0)
        {
            deliveryCharge = 5.00;
        }
        else
        {
            System.out.println("You need to add more items as your order is < £10");
        }
        totalCost = costOfItems + deliveryCharge;
        return totalCost;
    }
    
    /**
     * Accessor method for allItems ArrayList.
     */
    public ArrayList<Item> getAllItems()
    {
        return allItems;
    }
    
    /**
     * Returns the number of items in this order.
     * @return number of items in this order as an int.
     */
    public int getNumberOfItems()
    {
        return allItems.size();
    }
    
    /**
     * Accessor.
     * @return the unique order reference as a String.
     */
    public String getUniqueReference()
    {
        return uniqueReference;
    }
}
