import java.util.*;

/**
 * Model for the Guessing Game project.
 * 
 * @author Kingsley Sage 
 * @version 1.0
 */
public class GuessingGame
{
    private int answer;         // The answer
    private int numTurns;       // How many turns user has had
    private int[] allGuesses;   // All guesses made
    private int maxTurns;       // The maximum permitted number of turns
    
    /**
     * Constructor
     */
    public GuessingGame()
    {
        resetGame();
    }
    
    /**
     * Accessor for the current number of turns.
     * @return the current number of turns as an int.
     */
    public int getTurns()
    {
        return numTurns;
    }
    
    /**
     * Accessor for the correct answer.
     * @return the correct answer as an int.
     */
    public int getAnswer()
    {
        return answer;
    }
    
    /**
     * Accessor for maxTurns.
     * @return the max number of turns as an int.
     */
    public int getMaxTurns()
    {
        return maxTurns;
    }
    
    /**
     * Analyses the guess provided by the user and 
     * increments numTurns if appropriate.
     * Returns -1 if too low, +1 if too high, 0 if correct
     * and -2 if the user made this guess previously.
     * @param the current user guess an an int.
     * @return the analysis result as an int.
     */
    public int analyseGuess(int guess)
    {
        if (triedThatAlready(guess) == true)
        {
            return -2;
        }
        else if (guess == answer)
        {
            allGuesses[numTurns] = guess;
            return 0;
        }
        else if (guess > answer)
        {
            allGuesses[numTurns] = guess;
            numTurns++;
            return 1;
        }
        else
        // Guess must be too low
        {
            allGuesses[numTurns] = guess;
            numTurns++;
            return -1;
        }
    }
    
    /**
     * Determine if the user has previously entered
     * a value for guess.
     * @param the current user guess as an int.
     * @return true if the entered value has been tried previously. 
     */
    private boolean triedThatAlready(int guess)
    {
        for (int i=0; i<numTurns; i++)
        {
            if (guess == allGuesses[i])
            {
                return true;
            }
        }
        return false;
    }
    
    /** 
     * Resets the game to an initial state.
     */
    public void resetGame()
    {
        Random r = new Random();
        answer = r.nextInt(98) + 1;
        maxTurns = 10;
        numTurns = 0;
        allGuesses = new int[maxTurns];
    }
}
