import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border;

/**
 * A Swing GUI for the Guessing Game project.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class GuessingGameGUI implements Runnable
{
    // Instance variables ...
    GuessingGame game;
    JFrame f;
    JPanel p;
    JTextField ourGuess;
    JLabel turns;
    JLabel info;
    
    /**
     * Constructor.
     */
    public GuessingGameGUI()
    {
        // Create an instance of the Model ...
        game = new GuessingGame();
    }

    /**
     * Required by the Runnable interface.
     */
    public void run()
    {
        // First create the JFrame window
        f = new JFrame("The Guessing Game");
        // Determine what happens when the window is closed
        f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        // Set the frame to be fixed size
        f.setResizable(false);
        // Fetch a reference to the JFrame's contentPane
        Container pane = f.getContentPane();
        // Create a JPanel
        p = new JPanel();
        // Set up some menu options
        createMenus();
        // See up the remainder of the GUI estate
        // on the single panel
        createGUI();
        // Add the panel to the frame
        f.add(p);
        // Pack the frame ready for display
        f.pack();
        // Make the frame visible
        f.setVisible(true);
    }

    /**
     * Reset all GUI values to their initial settings.
     */
    public void resetGUI()
    {
        ourGuess.setText("");
        info.setText("");
        turns.setText(""+game.getTurns());
    }
    
    /**
     * Set up the 3 menu options.
     */
    public void createMenus()
    {
        JMenuBar m = new JMenuBar();
        // set the menu bar for the frame f
        f.setJMenuBar(m);
        // Create the "Options" menu
        JMenu optionsMenu = new JMenu("Options");
        // Now add some items to the menu
        JMenuItem aboutItem = new JMenuItem("About");
        JMenuItem retireItem = new JMenuItem("Retire");
        JMenuItem quitItem = new JMenuItem("Quit");
        // Now we add some listeners for the menu items
        aboutItem.addActionListener((event) -> showAbout());
        retireItem.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    String msg = "The answer was " + game.getAnswer();
                    JOptionPane.showMessageDialog(f,msg);
                    game.resetGame();
                    resetGUI();
                }   
            }
        );
        quitItem.addActionListener((event) -> System.exit(0));
        // Add the items to the menu
        optionsMenu.add(aboutItem);
        optionsMenu.add(retireItem);
        optionsMenu.add(quitItem);
        // Finally, add the menu to the menu bar
        m.add(optionsMenu);
    }

    /**
     * Display information about this application.
     */
    public void showAbout()
    {
        JOptionPane.showMessageDialog
        (f,"Created by Kingsley Sage\nEnjoy!");
    }

    /**
     * Create the main GUI estate under control of 
     * a GridLayout manager.
     */
    public void createGUI()
    {
        Border b = BorderFactory.createLineBorder(Color.BLACK);
        p.setLayout(new GridLayout(3,2,10,10));
        JLabel l1 = new JLabel("Place guess <ENTER>");
        // A field where we can enter our guess.
        // Pressing return will evaluate our guess.
        ourGuess = new JTextField();
        ourGuess.setBorder(b);
        JLabel l2 = new JLabel("Number of turns");
        // A field to display how many turns we had.
        turns = new JLabel(""+game.getTurns());
        turns.setBorder(b);
        // A field to display messages about our guess.
        info = new JLabel("No guesses yet!");
        info.setBorder(b);
        // Add an ActionListener so that our guess is
        // evaluated when return is pressed.
        ourGuess.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    if (game.getTurns() < game.getMaxTurns())
                    {
                        // Parse text into required int ...
                        int x = game.analyseGuess(Integer.parseInt(ourGuess.getText()));
                        updateDisplay(x);
                    }
                    else
                    {
                        game.resetGame();
                        resetGUI();
                        JOptionPane.showMessageDialog
                            (f,"Out of turns!");

                    }
                }
            }
        );
        // Add elements to the GUI (order left to right
        // and top to bottom for this GridLayout).
        p.add(l1);
        p.add(ourGuess);
        p.add(l2);
        p.add(turns);
        p.add(info);

    }

    /**
     * Updates the GUI as a result of the current guess.
     * @param the current user guess as an int.
     */
    public void updateDisplay(int x)
    {
        ourGuess.setText("");
        turns.setText(""+game.getTurns());
        switch (x)
        {
            case -2:
                info.setText("Tried that already!");
                break;
            case -1:
                info.setText("Too low");
                break;
            case 1:
                info.setText("Too high");
                break;
            case 0:
                JOptionPane.showMessageDialog(f,"Well done!");
                game.resetGame();
                resetGUI();
                break;
            default:
                info.setText("Internal error");
                break;
        }
    }

    /**
     * To permit standalone operation.
     */
    public static void main(String[] args)
    {
        // Create an instance of this class
        GuessingGameGUI g = new GuessingGameGUI();
        // Schedule the application to run
        SwingUtilities.invokeLater(g);
    }
}
