import static org.junit.Assert.*;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * Automated test class for GuessingGame.
 *
 * @author  Kingsley Sage
 * @version 1.0
 */
public class GuessingGameTest
{
    /**
     * Default constructor for test class GuessingGameTest
     */
    public GuessingGameTest()
    {
    }

    /**
     * Sets up the test fixture.
     *
     * Called before every test case method.
     */
    @Before
    public void setUp()
    {
    }

    /**
     * Tears down the test fixture.
     *
     * Called after every test case method.
     */
    @After
    public void tearDown()
    {
    }
    
    @Test
    public void test1()
    {
        int someGuess;
        GuessingGame game = new GuessingGame();
        int x = game.getAnswer();
        someGuess = x - 1;
        // someGuess is too low ...
        assertEquals(game.analyseGuess(someGuess),-1);
        assertEquals(game.getTurns(),1);
        someGuess = x + 1;
        // someGuess is too high ...
        assertEquals(game.analyseGuess(someGuess),1);
        assertEquals(game.getTurns(),2);
        // Try that guess again. Should be marked
        // as a repeat guess.
        assertEquals(game.analyseGuess(someGuess),-2);
        // Try the right answer ...
        someGuess = x;
        assertEquals(game.analyseGuess(someGuess),0);
        // Check maxTurns ...
        assertEquals(game.getMaxTurns(),10);
    }
    
}
