
/**
 * Write a description of class StringExamples here.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class StringExamples
{
    public void example1()
    {
        // Separate declaration and initialisation
        String s1;
        s1 = new String("Skywalker");
        
        // Combined declaration and initialisation
        String s2 = new String("Leia");
        
        // Combined and shortened syntax form
        String s3 = "Vader";
    }
    
    public void usingReferences()
    {
        String s1 = "Yoda";
        String s2 = "Dent";
        String s3;
        
        System.out.println(s1); // produces "Yoda"
        System.out.println(s2); // produces "Dent"
        
        s3 = s2;
        System.out.println(s3); // produces "Dent"
        
        s3 = s1;
        System.out.println(s3); // produces "Yoda"
        
        s1 = "Ewok";
        System.out.println(s3); // produces "Yoda"
    }
    
    public void stringExamples()
    {
        String s1 = "Woodpecker";
        String s2 = "Starling";
        String s3 = "  starling";
        // length() tells us how many characters are
        // in the text content of a String
        System.out.println("s1 has " + s1.length() + " chars");
        
        // charAt() is a method that picks a single
        // character out of a String
        for (int x=0; x < s1.length(); x++)
        {
            System.out.println(s1.charAt(x));
        }
        
        // trim() eliminates whitespace around a String
        // Note that we replace s3 with its new value
        // as String objects are immutable
        s3 = s3.trim();
        
        // compareTo() compares the text content of two Strings
        // The method produces a value of 0 only if the two strings
        // have identical content including matching case
        int y;
        y = s2.compareTo(s3);
        System.out.println(y);
        
        // compareToIgnoreCase() does something similar,
        // but is case insensitive, so here we expect the
        // returned value to be 0
        int z;
        z = s2.compareToIgnoreCase(s3);
        System.out.println(z);
    }
}
