import java.io.*;

/**
 * An example of catch a checked error
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class ExceptionExample2
{
    /**
     * Here we deal with the IOExeception locally.
     */
    public void openFileAndReadLinesV1()
    {
        try
        {
            FileReader f = new FileReader("C:\\test.txt");
            BufferedReader r = new BufferedReader(f);

            String line;
            line = r.readLine();
            while (line != null)
            {
                System.out.println(line);
                line = r.readLine();
            }
            r.close();
            f.close(); 
        }
        catch (IOException e)
        {
            System.out.println("Problem opening file");
        }
    }

    /**
     * Here we rely on something else to catch our exception.
     */
    public void openFileAndReadLinesV2() throws IOException
    {
        FileReader f = new FileReader("C:\\test.txt");
        BufferedReader r = new BufferedReader(f);

        String line;
        line = r.readLine();
        while (line != null)
        {
            System.out.println(line);
            line = r.readLine();
        }
        r.close();
        f.close();
    }

}
