/**
 * Example showing how a method higher up the call
 * stack can catch an exception.
 * 
 * @author Kingsley Sage
 * @version 1.0
 */
public class ExceptionExample4
{
    public void method1()
    {
        try
        {
            method2();
        }
        catch (ArithmeticException e)
        {
            System.out.println("method1() catches the error");
        }
    }

    public void method2()
    {
        method3();
    }

    public void method3() throws ArithmeticException
    {
        int x=0;
        // Does some useful work ...
        // But throws a built in ArithmeticException.
        // Note we do not need the try catch block here.
        if (x == 0)
        {
            throw new ArithmeticException("0 value");
        }
    }
}
